// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateApplication
func (c *ApplicationInsights) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for Amazon CloudWatch Application Insights.
//
// Adds an application that is created from a resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The resource is already created or in use.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * TagsAlreadyExistException
//   Tags are already registered for the specified application ARN.
//
//   * AccessDeniedException
//   User does not have permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateApplication
func (c *ApplicationInsights) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComponent = "CreateComponent"

// CreateComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComponent for more information on using the CreateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateComponentRequest method.
//    req, resp := client.CreateComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateComponent
func (c *ApplicationInsights) CreateComponentRequest(input *CreateComponentInput) (req *request.Request, output *CreateComponentOutput) {
	op := &request.Operation{
		Name:       opCreateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateComponentInput{}
	}

	output = &CreateComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateComponent API operation for Amazon CloudWatch Application Insights.
//
// Creates a custom component by grouping similar standalone instances to monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation CreateComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The resource is already created or in use.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateComponent
func (c *ApplicationInsights) CreateComponent(input *CreateComponentInput) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	return out, req.Send()
}

// CreateComponentWithContext is the same as CreateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) CreateComponentWithContext(ctx aws.Context, input *CreateComponentInput, opts ...request.Option) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLogPattern = "CreateLogPattern"

// CreateLogPatternRequest generates a "aws/request.Request" representing the
// client's request for the CreateLogPattern operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLogPattern for more information on using the CreateLogPattern
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLogPatternRequest method.
//    req, resp := client.CreateLogPatternRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateLogPattern
func (c *ApplicationInsights) CreateLogPatternRequest(input *CreateLogPatternInput) (req *request.Request, output *CreateLogPatternOutput) {
	op := &request.Operation{
		Name:       opCreateLogPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLogPatternInput{}
	}

	output = &CreateLogPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLogPattern API operation for Amazon CloudWatch Application Insights.
//
// Adds an log pattern to a LogPatternSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation CreateLogPattern for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The resource is already created or in use.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateLogPattern
func (c *ApplicationInsights) CreateLogPattern(input *CreateLogPatternInput) (*CreateLogPatternOutput, error) {
	req, out := c.CreateLogPatternRequest(input)
	return out, req.Send()
}

// CreateLogPatternWithContext is the same as CreateLogPattern with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLogPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) CreateLogPatternWithContext(ctx aws.Context, input *CreateLogPatternInput, opts ...request.Option) (*CreateLogPatternOutput, error) {
	req, out := c.CreateLogPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteApplication
func (c *ApplicationInsights) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for Amazon CloudWatch Application Insights.
//
// Removes the specified application from monitoring. Does not delete the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * BadRequestException
//   The request is not understood by the server.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteApplication
func (c *ApplicationInsights) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComponent for more information on using the DeleteComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteComponentRequest method.
//    req, resp := client.DeleteComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteComponent
func (c *ApplicationInsights) DeleteComponentRequest(input *DeleteComponentInput) (req *request.Request, output *DeleteComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	output = &DeleteComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteComponent API operation for Amazon CloudWatch Application Insights.
//
// Ungroups a custom component. When you ungroup custom components, all applicable
// monitors that are set up for the component are removed and the instances
// revert to their standalone status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DeleteComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteComponent
func (c *ApplicationInsights) DeleteComponent(input *DeleteComponentInput) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	return out, req.Send()
}

// DeleteComponentWithContext is the same as DeleteComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DeleteComponentWithContext(ctx aws.Context, input *DeleteComponentInput, opts ...request.Option) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLogPattern = "DeleteLogPattern"

// DeleteLogPatternRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLogPattern operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLogPattern for more information on using the DeleteLogPattern
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLogPatternRequest method.
//    req, resp := client.DeleteLogPatternRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteLogPattern
func (c *ApplicationInsights) DeleteLogPatternRequest(input *DeleteLogPatternInput) (req *request.Request, output *DeleteLogPatternOutput) {
	op := &request.Operation{
		Name:       opDeleteLogPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLogPatternInput{}
	}

	output = &DeleteLogPatternOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLogPattern API operation for Amazon CloudWatch Application Insights.
//
// Removes the specified log pattern from a LogPatternSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DeleteLogPattern for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * BadRequestException
//   The request is not understood by the server.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteLogPattern
func (c *ApplicationInsights) DeleteLogPattern(input *DeleteLogPatternInput) (*DeleteLogPatternOutput, error) {
	req, out := c.DeleteLogPatternRequest(input)
	return out, req.Send()
}

// DeleteLogPatternWithContext is the same as DeleteLogPattern with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLogPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DeleteLogPatternWithContext(ctx aws.Context, input *DeleteLogPatternInput, opts ...request.Option) (*DeleteLogPatternOutput, error) {
	req, out := c.DeleteLogPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplication = "DescribeApplication"

// DescribeApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplication for more information on using the DescribeApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationRequest method.
//    req, resp := client.DescribeApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeApplication
func (c *ApplicationInsights) DescribeApplicationRequest(input *DescribeApplicationInput) (req *request.Request, output *DescribeApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationInput{}
	}

	output = &DescribeApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplication API operation for Amazon CloudWatch Application Insights.
//
// Describes the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeApplication
func (c *ApplicationInsights) DescribeApplication(input *DescribeApplicationInput) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	return out, req.Send()
}

// DescribeApplicationWithContext is the same as DescribeApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeApplicationWithContext(ctx aws.Context, input *DescribeApplicationInput, opts ...request.Option) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComponent = "DescribeComponent"

// DescribeComponentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComponent for more information on using the DescribeComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComponentRequest method.
//    req, resp := client.DescribeComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponent
func (c *ApplicationInsights) DescribeComponentRequest(input *DescribeComponentInput) (req *request.Request, output *DescribeComponentOutput) {
	op := &request.Operation{
		Name:       opDescribeComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComponentInput{}
	}

	output = &DescribeComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComponent API operation for Amazon CloudWatch Application Insights.
//
// Describes a component and lists the resources that are grouped together in
// a component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponent
func (c *ApplicationInsights) DescribeComponent(input *DescribeComponentInput) (*DescribeComponentOutput, error) {
	req, out := c.DescribeComponentRequest(input)
	return out, req.Send()
}

// DescribeComponentWithContext is the same as DescribeComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeComponentWithContext(ctx aws.Context, input *DescribeComponentInput, opts ...request.Option) (*DescribeComponentOutput, error) {
	req, out := c.DescribeComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComponentConfiguration = "DescribeComponentConfiguration"

// DescribeComponentConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComponentConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComponentConfiguration for more information on using the DescribeComponentConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComponentConfigurationRequest method.
//    req, resp := client.DescribeComponentConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfiguration
func (c *ApplicationInsights) DescribeComponentConfigurationRequest(input *DescribeComponentConfigurationInput) (req *request.Request, output *DescribeComponentConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeComponentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComponentConfigurationInput{}
	}

	output = &DescribeComponentConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComponentConfiguration API operation for Amazon CloudWatch Application Insights.
//
// Describes the monitoring configuration of the component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeComponentConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfiguration
func (c *ApplicationInsights) DescribeComponentConfiguration(input *DescribeComponentConfigurationInput) (*DescribeComponentConfigurationOutput, error) {
	req, out := c.DescribeComponentConfigurationRequest(input)
	return out, req.Send()
}

// DescribeComponentConfigurationWithContext is the same as DescribeComponentConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComponentConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeComponentConfigurationWithContext(ctx aws.Context, input *DescribeComponentConfigurationInput, opts ...request.Option) (*DescribeComponentConfigurationOutput, error) {
	req, out := c.DescribeComponentConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComponentConfigurationRecommendation = "DescribeComponentConfigurationRecommendation"

// DescribeComponentConfigurationRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComponentConfigurationRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComponentConfigurationRecommendation for more information on using the DescribeComponentConfigurationRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComponentConfigurationRecommendationRequest method.
//    req, resp := client.DescribeComponentConfigurationRecommendationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfigurationRecommendation
func (c *ApplicationInsights) DescribeComponentConfigurationRecommendationRequest(input *DescribeComponentConfigurationRecommendationInput) (req *request.Request, output *DescribeComponentConfigurationRecommendationOutput) {
	op := &request.Operation{
		Name:       opDescribeComponentConfigurationRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComponentConfigurationRecommendationInput{}
	}

	output = &DescribeComponentConfigurationRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComponentConfigurationRecommendation API operation for Amazon CloudWatch Application Insights.
//
// Describes the recommended monitoring configuration of the component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeComponentConfigurationRecommendation for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfigurationRecommendation
func (c *ApplicationInsights) DescribeComponentConfigurationRecommendation(input *DescribeComponentConfigurationRecommendationInput) (*DescribeComponentConfigurationRecommendationOutput, error) {
	req, out := c.DescribeComponentConfigurationRecommendationRequest(input)
	return out, req.Send()
}

// DescribeComponentConfigurationRecommendationWithContext is the same as DescribeComponentConfigurationRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComponentConfigurationRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeComponentConfigurationRecommendationWithContext(ctx aws.Context, input *DescribeComponentConfigurationRecommendationInput, opts ...request.Option) (*DescribeComponentConfigurationRecommendationOutput, error) {
	req, out := c.DescribeComponentConfigurationRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLogPattern = "DescribeLogPattern"

// DescribeLogPatternRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLogPattern operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLogPattern for more information on using the DescribeLogPattern
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLogPatternRequest method.
//    req, resp := client.DescribeLogPatternRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeLogPattern
func (c *ApplicationInsights) DescribeLogPatternRequest(input *DescribeLogPatternInput) (req *request.Request, output *DescribeLogPatternOutput) {
	op := &request.Operation{
		Name:       opDescribeLogPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLogPatternInput{}
	}

	output = &DescribeLogPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLogPattern API operation for Amazon CloudWatch Application Insights.
//
// Describe a specific log pattern from a LogPatternSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeLogPattern for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeLogPattern
func (c *ApplicationInsights) DescribeLogPattern(input *DescribeLogPatternInput) (*DescribeLogPatternOutput, error) {
	req, out := c.DescribeLogPatternRequest(input)
	return out, req.Send()
}

// DescribeLogPatternWithContext is the same as DescribeLogPattern with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLogPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeLogPatternWithContext(ctx aws.Context, input *DescribeLogPatternInput, opts ...request.Option) (*DescribeLogPatternOutput, error) {
	req, out := c.DescribeLogPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeObservation = "DescribeObservation"

// DescribeObservationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeObservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeObservation for more information on using the DescribeObservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeObservationRequest method.
//    req, resp := client.DescribeObservationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeObservation
func (c *ApplicationInsights) DescribeObservationRequest(input *DescribeObservationInput) (req *request.Request, output *DescribeObservationOutput) {
	op := &request.Operation{
		Name:       opDescribeObservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeObservationInput{}
	}

	output = &DescribeObservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeObservation API operation for Amazon CloudWatch Application Insights.
//
// Describes an anomaly or error with the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeObservation for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeObservation
func (c *ApplicationInsights) DescribeObservation(input *DescribeObservationInput) (*DescribeObservationOutput, error) {
	req, out := c.DescribeObservationRequest(input)
	return out, req.Send()
}

// DescribeObservationWithContext is the same as DescribeObservation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeObservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeObservationWithContext(ctx aws.Context, input *DescribeObservationInput, opts ...request.Option) (*DescribeObservationOutput, error) {
	req, out := c.DescribeObservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProblem = "DescribeProblem"

// DescribeProblemRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProblem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProblem for more information on using the DescribeProblem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProblemRequest method.
//    req, resp := client.DescribeProblemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblem
func (c *ApplicationInsights) DescribeProblemRequest(input *DescribeProblemInput) (req *request.Request, output *DescribeProblemOutput) {
	op := &request.Operation{
		Name:       opDescribeProblem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProblemInput{}
	}

	output = &DescribeProblemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProblem API operation for Amazon CloudWatch Application Insights.
//
// Describes an application problem.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeProblem for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblem
func (c *ApplicationInsights) DescribeProblem(input *DescribeProblemInput) (*DescribeProblemOutput, error) {
	req, out := c.DescribeProblemRequest(input)
	return out, req.Send()
}

// DescribeProblemWithContext is the same as DescribeProblem with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProblem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeProblemWithContext(ctx aws.Context, input *DescribeProblemInput, opts ...request.Option) (*DescribeProblemOutput, error) {
	req, out := c.DescribeProblemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProblemObservations = "DescribeProblemObservations"

// DescribeProblemObservationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProblemObservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProblemObservations for more information on using the DescribeProblemObservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProblemObservationsRequest method.
//    req, resp := client.DescribeProblemObservationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblemObservations
func (c *ApplicationInsights) DescribeProblemObservationsRequest(input *DescribeProblemObservationsInput) (req *request.Request, output *DescribeProblemObservationsOutput) {
	op := &request.Operation{
		Name:       opDescribeProblemObservations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProblemObservationsInput{}
	}

	output = &DescribeProblemObservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProblemObservations API operation for Amazon CloudWatch Application Insights.
//
// Describes the anomalies or errors associated with the problem.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation DescribeProblemObservations for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblemObservations
func (c *ApplicationInsights) DescribeProblemObservations(input *DescribeProblemObservationsInput) (*DescribeProblemObservationsOutput, error) {
	req, out := c.DescribeProblemObservationsRequest(input)
	return out, req.Send()
}

// DescribeProblemObservationsWithContext is the same as DescribeProblemObservations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProblemObservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) DescribeProblemObservationsWithContext(ctx aws.Context, input *DescribeProblemObservationsInput, opts ...request.Option) (*DescribeProblemObservationsOutput, error) {
	req, out := c.DescribeProblemObservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications
func (c *ApplicationInsights) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for Amazon CloudWatch Application Insights.
//
// Lists the IDs of the applications that you are monitoring.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListApplications
func (c *ApplicationInsights) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *applicationinsights.ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComponentsRequest method.
//    req, resp := client.ListComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents
func (c *ApplicationInsights) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponents API operation for Amazon CloudWatch Application Insights.
//
// Lists the auto-grouped, standalone, and custom components of the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListComponents for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents
func (c *ApplicationInsights) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListComponentsWithContext(ctx aws.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentsPages iterates over the pages of a ListComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListComponents operation.
//    pageNum := 0
//    err := client.ListComponentsPages(params,
//        func(page *applicationinsights.ListComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListComponentsPages(input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool) error {
	return c.ListComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentsPagesWithContext same as ListComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListComponentsPagesWithContext(ctx aws.Context, input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfigurationHistory = "ListConfigurationHistory"

// ListConfigurationHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationHistory for more information on using the ListConfigurationHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationHistoryRequest method.
//    req, resp := client.ListConfigurationHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListConfigurationHistory
func (c *ApplicationInsights) ListConfigurationHistoryRequest(input *ListConfigurationHistoryInput) (req *request.Request, output *ListConfigurationHistoryOutput) {
	op := &request.Operation{
		Name:       opListConfigurationHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationHistoryInput{}
	}

	output = &ListConfigurationHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationHistory API operation for Amazon CloudWatch Application Insights.
//
// Lists the INFO, WARN, and ERROR events for periodic configuration updates
// performed by Application Insights. Examples of events represented are:
//
//    * INFO: creating a new alarm or updating an alarm threshold.
//
//    * WARN: alarm not created due to insufficient data points used to predict
//    thresholds.
//
//    * ERROR: alarm not created due to permission errors or exceeding quotas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListConfigurationHistory for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The parameter is not valid.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListConfigurationHistory
func (c *ApplicationInsights) ListConfigurationHistory(input *ListConfigurationHistoryInput) (*ListConfigurationHistoryOutput, error) {
	req, out := c.ListConfigurationHistoryRequest(input)
	return out, req.Send()
}

// ListConfigurationHistoryWithContext is the same as ListConfigurationHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListConfigurationHistoryWithContext(ctx aws.Context, input *ListConfigurationHistoryInput, opts ...request.Option) (*ListConfigurationHistoryOutput, error) {
	req, out := c.ListConfigurationHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationHistoryPages iterates over the pages of a ListConfigurationHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurationHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConfigurationHistory operation.
//    pageNum := 0
//    err := client.ListConfigurationHistoryPages(params,
//        func(page *applicationinsights.ListConfigurationHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListConfigurationHistoryPages(input *ListConfigurationHistoryInput, fn func(*ListConfigurationHistoryOutput, bool) bool) error {
	return c.ListConfigurationHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationHistoryPagesWithContext same as ListConfigurationHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListConfigurationHistoryPagesWithContext(ctx aws.Context, input *ListConfigurationHistoryInput, fn func(*ListConfigurationHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLogPatternSets = "ListLogPatternSets"

// ListLogPatternSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListLogPatternSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLogPatternSets for more information on using the ListLogPatternSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLogPatternSetsRequest method.
//    req, resp := client.ListLogPatternSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatternSets
func (c *ApplicationInsights) ListLogPatternSetsRequest(input *ListLogPatternSetsInput) (req *request.Request, output *ListLogPatternSetsOutput) {
	op := &request.Operation{
		Name:       opListLogPatternSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLogPatternSetsInput{}
	}

	output = &ListLogPatternSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLogPatternSets API operation for Amazon CloudWatch Application Insights.
//
// Lists the log pattern sets in the specific application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListLogPatternSets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatternSets
func (c *ApplicationInsights) ListLogPatternSets(input *ListLogPatternSetsInput) (*ListLogPatternSetsOutput, error) {
	req, out := c.ListLogPatternSetsRequest(input)
	return out, req.Send()
}

// ListLogPatternSetsWithContext is the same as ListLogPatternSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListLogPatternSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListLogPatternSetsWithContext(ctx aws.Context, input *ListLogPatternSetsInput, opts ...request.Option) (*ListLogPatternSetsOutput, error) {
	req, out := c.ListLogPatternSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLogPatternSetsPages iterates over the pages of a ListLogPatternSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLogPatternSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLogPatternSets operation.
//    pageNum := 0
//    err := client.ListLogPatternSetsPages(params,
//        func(page *applicationinsights.ListLogPatternSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListLogPatternSetsPages(input *ListLogPatternSetsInput, fn func(*ListLogPatternSetsOutput, bool) bool) error {
	return c.ListLogPatternSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLogPatternSetsPagesWithContext same as ListLogPatternSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListLogPatternSetsPagesWithContext(ctx aws.Context, input *ListLogPatternSetsInput, fn func(*ListLogPatternSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLogPatternSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLogPatternSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLogPatternSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLogPatterns = "ListLogPatterns"

// ListLogPatternsRequest generates a "aws/request.Request" representing the
// client's request for the ListLogPatterns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLogPatterns for more information on using the ListLogPatterns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLogPatternsRequest method.
//    req, resp := client.ListLogPatternsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatterns
func (c *ApplicationInsights) ListLogPatternsRequest(input *ListLogPatternsInput) (req *request.Request, output *ListLogPatternsOutput) {
	op := &request.Operation{
		Name:       opListLogPatterns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLogPatternsInput{}
	}

	output = &ListLogPatternsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLogPatterns API operation for Amazon CloudWatch Application Insights.
//
// Lists the log patterns in the specific log LogPatternSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListLogPatterns for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatterns
func (c *ApplicationInsights) ListLogPatterns(input *ListLogPatternsInput) (*ListLogPatternsOutput, error) {
	req, out := c.ListLogPatternsRequest(input)
	return out, req.Send()
}

// ListLogPatternsWithContext is the same as ListLogPatterns with the addition of
// the ability to pass a context and additional request options.
//
// See ListLogPatterns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListLogPatternsWithContext(ctx aws.Context, input *ListLogPatternsInput, opts ...request.Option) (*ListLogPatternsOutput, error) {
	req, out := c.ListLogPatternsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLogPatternsPages iterates over the pages of a ListLogPatterns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLogPatterns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLogPatterns operation.
//    pageNum := 0
//    err := client.ListLogPatternsPages(params,
//        func(page *applicationinsights.ListLogPatternsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListLogPatternsPages(input *ListLogPatternsInput, fn func(*ListLogPatternsOutput, bool) bool) error {
	return c.ListLogPatternsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLogPatternsPagesWithContext same as ListLogPatternsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListLogPatternsPagesWithContext(ctx aws.Context, input *ListLogPatternsInput, fn func(*ListLogPatternsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLogPatternsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLogPatternsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLogPatternsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProblems = "ListProblems"

// ListProblemsRequest generates a "aws/request.Request" representing the
// client's request for the ListProblems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProblems for more information on using the ListProblems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProblemsRequest method.
//    req, resp := client.ListProblemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems
func (c *ApplicationInsights) ListProblemsRequest(input *ListProblemsInput) (req *request.Request, output *ListProblemsOutput) {
	op := &request.Operation{
		Name:       opListProblems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProblemsInput{}
	}

	output = &ListProblemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProblems API operation for Amazon CloudWatch Application Insights.
//
// Lists the problems with your application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListProblems for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The parameter is not valid.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListProblems
func (c *ApplicationInsights) ListProblems(input *ListProblemsInput) (*ListProblemsOutput, error) {
	req, out := c.ListProblemsRequest(input)
	return out, req.Send()
}

// ListProblemsWithContext is the same as ListProblems with the addition of
// the ability to pass a context and additional request options.
//
// See ListProblems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListProblemsWithContext(ctx aws.Context, input *ListProblemsInput, opts ...request.Option) (*ListProblemsOutput, error) {
	req, out := c.ListProblemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProblemsPages iterates over the pages of a ListProblems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProblems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProblems operation.
//    pageNum := 0
//    err := client.ListProblemsPages(params,
//        func(page *applicationinsights.ListProblemsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationInsights) ListProblemsPages(input *ListProblemsInput, fn func(*ListProblemsOutput, bool) bool) error {
	return c.ListProblemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProblemsPagesWithContext same as ListProblemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListProblemsPagesWithContext(ctx aws.Context, input *ListProblemsInput, fn func(*ListProblemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProblemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProblemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProblemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListTagsForResource
func (c *ApplicationInsights) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudWatch Application Insights.
//
// Retrieve a list of the tags (keys and values) that are associated with a
// specified application. A tag is a label that you optionally define and associate
// with an application. Each tag consists of a required tag key and an optional
// associated tag value. A tag key is a general label that acts as a category
// for more specific tag values. A tag value acts as a descriptor within a tag
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListTagsForResource
func (c *ApplicationInsights) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/TagResource
func (c *ApplicationInsights) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudWatch Application Insights.
//
// Add one or more tags (keys and values) to a specified application. A tag
// is a label that you optionally define and associate with an application.
// Tags can help you categorize and manage application in different ways, such
// as by purpose, owner, environment, or other criteria.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for more specific tag values. A tag value acts as a descriptor within a tag
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * TooManyTagsException
//   The number of the provided tags is beyond the limit, or the number of total
//   tags you are trying to attach to the specified resource exceeds the limit.
//
//   * ValidationException
//   The parameter is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/TagResource
func (c *ApplicationInsights) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UntagResource
func (c *ApplicationInsights) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudWatch Application Insights.
//
// Remove one or more tags (keys and values) from a specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UntagResource
func (c *ApplicationInsights) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateApplication
func (c *ApplicationInsights) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for Amazon CloudWatch Application Insights.
//
// Updates the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateApplication
func (c *ApplicationInsights) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComponent = "UpdateComponent"

// UpdateComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComponent for more information on using the UpdateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateComponentRequest method.
//    req, resp := client.UpdateComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponent
func (c *ApplicationInsights) UpdateComponentRequest(input *UpdateComponentInput) (req *request.Request, output *UpdateComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateComponentInput{}
	}

	output = &UpdateComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateComponent API operation for Amazon CloudWatch Application Insights.
//
// Updates the custom component name and/or the list of resources that make
// up the component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation UpdateComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The resource is already created or in use.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponent
func (c *ApplicationInsights) UpdateComponent(input *UpdateComponentInput) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	return out, req.Send()
}

// UpdateComponentWithContext is the same as UpdateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) UpdateComponentWithContext(ctx aws.Context, input *UpdateComponentInput, opts ...request.Option) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComponentConfiguration = "UpdateComponentConfiguration"

// UpdateComponentConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComponentConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComponentConfiguration for more information on using the UpdateComponentConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateComponentConfigurationRequest method.
//    req, resp := client.UpdateComponentConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponentConfiguration
func (c *ApplicationInsights) UpdateComponentConfigurationRequest(input *UpdateComponentConfigurationInput) (req *request.Request, output *UpdateComponentConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateComponentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateComponentConfigurationInput{}
	}

	output = &UpdateComponentConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateComponentConfiguration API operation for Amazon CloudWatch Application Insights.
//
// Updates the monitoring configurations for the component. The configuration
// input parameter is an escaped JSON of the configuration and should match
// the schema of what is returned by DescribeComponentConfigurationRecommendation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation UpdateComponentConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateComponentConfiguration
func (c *ApplicationInsights) UpdateComponentConfiguration(input *UpdateComponentConfigurationInput) (*UpdateComponentConfigurationOutput, error) {
	req, out := c.UpdateComponentConfigurationRequest(input)
	return out, req.Send()
}

// UpdateComponentConfigurationWithContext is the same as UpdateComponentConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComponentConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) UpdateComponentConfigurationWithContext(ctx aws.Context, input *UpdateComponentConfigurationInput, opts ...request.Option) (*UpdateComponentConfigurationOutput, error) {
	req, out := c.UpdateComponentConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLogPattern = "UpdateLogPattern"

// UpdateLogPatternRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLogPattern operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLogPattern for more information on using the UpdateLogPattern
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLogPatternRequest method.
//    req, resp := client.UpdateLogPatternRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateLogPattern
func (c *ApplicationInsights) UpdateLogPatternRequest(input *UpdateLogPatternInput) (req *request.Request, output *UpdateLogPatternOutput) {
	op := &request.Operation{
		Name:       opUpdateLogPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLogPatternInput{}
	}

	output = &UpdateLogPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLogPattern API operation for Amazon CloudWatch Application Insights.
//
// Adds a log pattern to a LogPatternSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Application Insights's
// API operation UpdateLogPattern for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The resource is already created or in use.
//
//   * ResourceNotFoundException
//   The resource does not exist in the customer account.
//
//   * ValidationException
//   The parameter is not valid.
//
//   * InternalServerException
//   The server encountered an internal error and is unable to complete the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/UpdateLogPattern
func (c *ApplicationInsights) UpdateLogPattern(input *UpdateLogPatternInput) (*UpdateLogPatternOutput, error) {
	req, out := c.UpdateLogPatternRequest(input)
	return out, req.Send()
}

// UpdateLogPatternWithContext is the same as UpdateLogPattern with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLogPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationInsights) UpdateLogPatternWithContext(ctx aws.Context, input *UpdateLogPatternInput, opts ...request.Option) (*UpdateLogPatternOutput, error) {
	req, out := c.UpdateLogPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a standalone resource or similarly grouped resources that the application
// is made up of.
type ApplicationComponent struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `min:"1" type:"string"`

	// If logging is supported for the resource type, indicates whether the component
	// has configured logs to be monitored.
	ComponentRemarks *string `type:"string"`

	// Workloads detected in the application component.
	DetectedWorkload map[string]map[string]*string `type:"map"`

	// Indicates whether the application component is monitored.
	Monitor *bool `type:"boolean"`

	// The operating system of the component.
	OsType *string `type:"string" enum:"OsType"`

	// The resource type. Supported resource types include EC2 instances, Auto Scaling
	// group, Classic ELB, Application ELB, and SQS Queue.
	ResourceType *string `min:"1" type:"string"`

	// The stack tier of the application component.
	Tier *string `min:"1" type:"string" enum:"Tier"`
}

// String returns the string representation
func (s ApplicationComponent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationComponent) GoString() string {
	return s.String()
}

// SetComponentName sets the ComponentName field's value.
func (s *ApplicationComponent) SetComponentName(v string) *ApplicationComponent {
	s.ComponentName = &v
	return s
}

// SetComponentRemarks sets the ComponentRemarks field's value.
func (s *ApplicationComponent) SetComponentRemarks(v string) *ApplicationComponent {
	s.ComponentRemarks = &v
	return s
}

// SetDetectedWorkload sets the DetectedWorkload field's value.
func (s *ApplicationComponent) SetDetectedWorkload(v map[string]map[string]*string) *ApplicationComponent {
	s.DetectedWorkload = v
	return s
}

// SetMonitor sets the Monitor field's value.
func (s *ApplicationComponent) SetMonitor(v bool) *ApplicationComponent {
	s.Monitor = &v
	return s
}

// SetOsType sets the OsType field's value.
func (s *ApplicationComponent) SetOsType(v string) *ApplicationComponent {
	s.OsType = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ApplicationComponent) SetResourceType(v string) *ApplicationComponent {
	s.ResourceType = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *ApplicationComponent) SetTier(v string) *ApplicationComponent {
	s.Tier = &v
	return s
}

// Describes the status of the application.
type ApplicationInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether Application Insights can listen to CloudWatch events for
	// the application resources, such as instance terminated, failed deployment,
	// and others.
	CWEMonitorEnabled *bool `type:"boolean"`

	// The lifecycle of the application.
	LifeCycle *string `type:"string"`

	// Indicates whether Application Insights will create opsItems for any problem
	// detected by Application Insights for an application.
	OpsCenterEnabled *bool `type:"boolean"`

	// The SNS topic provided to Application Insights that is associated to the
	// created opsItems to receive SNS notifications for opsItem updates.
	OpsItemSNSTopicArn *string `min:"20" type:"string"`

	// The issues on the user side that block Application Insights from successfully
	// monitoring an application. Example remarks include:
	//
	//    * “Configuring application, detected 1 Errors, 3 Warnings”
	//
	//    * “Configuring application, detected 1 Unconfigured Components”
	Remarks *string `type:"string"`

	// The name of the resource group used for the application.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ApplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationInfo) GoString() string {
	return s.String()
}

// SetCWEMonitorEnabled sets the CWEMonitorEnabled field's value.
func (s *ApplicationInfo) SetCWEMonitorEnabled(v bool) *ApplicationInfo {
	s.CWEMonitorEnabled = &v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *ApplicationInfo) SetLifeCycle(v string) *ApplicationInfo {
	s.LifeCycle = &v
	return s
}

// SetOpsCenterEnabled sets the OpsCenterEnabled field's value.
func (s *ApplicationInfo) SetOpsCenterEnabled(v bool) *ApplicationInfo {
	s.OpsCenterEnabled = &v
	return s
}

// SetOpsItemSNSTopicArn sets the OpsItemSNSTopicArn field's value.
func (s *ApplicationInfo) SetOpsItemSNSTopicArn(v string) *ApplicationInfo {
	s.OpsItemSNSTopicArn = &v
	return s
}

// SetRemarks sets the Remarks field's value.
func (s *ApplicationInfo) SetRemarks(v string) *ApplicationInfo {
	s.Remarks = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ApplicationInfo) SetResourceGroupName(v string) *ApplicationInfo {
	s.ResourceGroupName = &v
	return s
}

// The request is not understood by the server.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The event information.
type ConfigurationEvent struct {
	_ struct{} `type:"structure"`

	// The details of the event in plain text.
	EventDetail *string `type:"string"`

	// The name of the resource Application Insights attempted to configure.
	EventResourceName *string `type:"string"`

	// The resource type that Application Insights attempted to configure, for example,
	// CLOUDWATCH_ALARM.
	EventResourceType *string `type:"string" enum:"ConfigurationEventResourceType"`

	// The status of the configuration update event. Possible values include INFO,
	// WARN, and ERROR.
	EventStatus *string `type:"string" enum:"ConfigurationEventStatus"`

	// The timestamp of the event.
	EventTime *time.Time `type:"timestamp"`

	// The resource monitored by Application Insights.
	MonitoredResourceARN *string `type:"string"`
}

// String returns the string representation
func (s ConfigurationEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationEvent) GoString() string {
	return s.String()
}

// SetEventDetail sets the EventDetail field's value.
func (s *ConfigurationEvent) SetEventDetail(v string) *ConfigurationEvent {
	s.EventDetail = &v
	return s
}

// SetEventResourceName sets the EventResourceName field's value.
func (s *ConfigurationEvent) SetEventResourceName(v string) *ConfigurationEvent {
	s.EventResourceName = &v
	return s
}

// SetEventResourceType sets the EventResourceType field's value.
func (s *ConfigurationEvent) SetEventResourceType(v string) *ConfigurationEvent {
	s.EventResourceType = &v
	return s
}

// SetEventStatus sets the EventStatus field's value.
func (s *ConfigurationEvent) SetEventStatus(v string) *ConfigurationEvent {
	s.EventStatus = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *ConfigurationEvent) SetEventTime(v time.Time) *ConfigurationEvent {
	s.EventTime = &v
	return s
}

// SetMonitoredResourceARN sets the MonitoredResourceARN field's value.
func (s *ConfigurationEvent) SetMonitoredResourceARN(v string) *ConfigurationEvent {
	s.MonitoredResourceARN = &v
	return s
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether Application Insights can listen to CloudWatch events for
	// the application resources, such as instance terminated, failed deployment,
	// and others.
	CWEMonitorEnabled *bool `type:"boolean"`

	// When set to true, creates opsItems for any problems detected on an application.
	OpsCenterEnabled *bool `type:"boolean"`

	// The SNS topic provided to Application Insights that is associated to the
	// created opsItem. Allows you to receive notifications for updates to the opsItem.
	OpsItemSNSTopicArn *string `min:"20" type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`

	// List of tags to add to the application. tag key (Key) and an associated tag
	// value (Value). The maximum length of a tag key is 128 characters. The maximum
	// length of a tag value is 256 characters.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.OpsItemSNSTopicArn != nil && len(*s.OpsItemSNSTopicArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OpsItemSNSTopicArn", 20))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCWEMonitorEnabled sets the CWEMonitorEnabled field's value.
func (s *CreateApplicationInput) SetCWEMonitorEnabled(v bool) *CreateApplicationInput {
	s.CWEMonitorEnabled = &v
	return s
}

// SetOpsCenterEnabled sets the OpsCenterEnabled field's value.
func (s *CreateApplicationInput) SetOpsCenterEnabled(v bool) *CreateApplicationInput {
	s.OpsCenterEnabled = &v
	return s
}

// SetOpsItemSNSTopicArn sets the OpsItemSNSTopicArn field's value.
func (s *CreateApplicationInput) SetOpsItemSNSTopicArn(v string) *CreateApplicationInput {
	s.OpsItemSNSTopicArn = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *CreateApplicationInput) SetResourceGroupName(v string) *CreateApplicationInput {
	s.ResourceGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v []*Tag) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	ApplicationInfo *ApplicationInfo `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationInfo sets the ApplicationInfo field's value.
func (s *CreateApplicationOutput) SetApplicationInfo(v *ApplicationInfo) *CreateApplicationOutput {
	s.ApplicationInfo = v
	return s
}

type CreateComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`

	// The list of resource ARNs that belong to the component.
	//
	// ResourceList is a required field
	ResourceList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}
	if s.ResourceList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *CreateComponentInput) SetComponentName(v string) *CreateComponentInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *CreateComponentInput) SetResourceGroupName(v string) *CreateComponentInput {
	s.ResourceGroupName = &v
	return s
}

// SetResourceList sets the ResourceList field's value.
func (s *CreateComponentInput) SetResourceList(v []*string) *CreateComponentInput {
	s.ResourceList = v
	return s
}

type CreateComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComponentOutput) GoString() string {
	return s.String()
}

type CreateLogPatternInput struct {
	_ struct{} `type:"structure"`

	// The log pattern. The pattern must be DFA compatible. Patterns that utilize
	// forward lookahead or backreference constructions are not supported.
	//
	// Pattern is a required field
	Pattern *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern.
	//
	// PatternName is a required field
	PatternName *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern set.
	//
	// PatternSetName is a required field
	PatternSetName *string `min:"1" type:"string" required:"true"`

	// Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns
	// are sorted by rank, so we recommend that you set your highest priority patterns
	// with the lowest rank. A pattern of rank 1 will be the first to get matched
	// to a log line. A pattern of rank 1,000,000 will be last to get matched. When
	// you configure custom log patterns from the console, a Low severity pattern
	// translates to a 750,000 rank. A Medium severity pattern translates to a 500,000
	// rank. And a High severity pattern translates to a 250,000 rank. Rank values
	// less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
	//
	// Rank is a required field
	Rank *int64 `type:"integer" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLogPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLogPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLogPatternInput"}
	if s.Pattern == nil {
		invalidParams.Add(request.NewErrParamRequired("Pattern"))
	}
	if s.Pattern != nil && len(*s.Pattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Pattern", 1))
	}
	if s.PatternName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternName"))
	}
	if s.PatternName != nil && len(*s.PatternName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternName", 1))
	}
	if s.PatternSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternSetName"))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternSetName", 1))
	}
	if s.Rank == nil {
		invalidParams.Add(request.NewErrParamRequired("Rank"))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPattern sets the Pattern field's value.
func (s *CreateLogPatternInput) SetPattern(v string) *CreateLogPatternInput {
	s.Pattern = &v
	return s
}

// SetPatternName sets the PatternName field's value.
func (s *CreateLogPatternInput) SetPatternName(v string) *CreateLogPatternInput {
	s.PatternName = &v
	return s
}

// SetPatternSetName sets the PatternSetName field's value.
func (s *CreateLogPatternInput) SetPatternSetName(v string) *CreateLogPatternInput {
	s.PatternSetName = &v
	return s
}

// SetRank sets the Rank field's value.
func (s *CreateLogPatternInput) SetRank(v int64) *CreateLogPatternInput {
	s.Rank = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *CreateLogPatternInput) SetResourceGroupName(v string) *CreateLogPatternInput {
	s.ResourceGroupName = &v
	return s
}

type CreateLogPatternOutput struct {
	_ struct{} `type:"structure"`

	// The successfully created log pattern.
	LogPattern *LogPattern `type:"structure"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateLogPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogPatternOutput) GoString() string {
	return s.String()
}

// SetLogPattern sets the LogPattern field's value.
func (s *CreateLogPatternOutput) SetLogPattern(v *LogPattern) *CreateLogPatternOutput {
	s.LogPattern = v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *CreateLogPatternOutput) SetResourceGroupName(v string) *CreateLogPatternOutput {
	s.ResourceGroupName = &v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DeleteApplicationInput) SetResourceGroupName(v string) *DeleteApplicationInput {
	s.ResourceGroupName = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DeleteComponentInput) SetComponentName(v string) *DeleteComponentInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DeleteComponentInput) SetResourceGroupName(v string) *DeleteComponentInput {
	s.ResourceGroupName = &v
	return s
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteComponentOutput) GoString() string {
	return s.String()
}

type DeleteLogPatternInput struct {
	_ struct{} `type:"structure"`

	// The name of the log pattern.
	//
	// PatternName is a required field
	PatternName *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern set.
	//
	// PatternSetName is a required field
	PatternSetName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLogPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLogPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLogPatternInput"}
	if s.PatternName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternName"))
	}
	if s.PatternName != nil && len(*s.PatternName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternName", 1))
	}
	if s.PatternSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternSetName"))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternSetName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatternName sets the PatternName field's value.
func (s *DeleteLogPatternInput) SetPatternName(v string) *DeleteLogPatternInput {
	s.PatternName = &v
	return s
}

// SetPatternSetName sets the PatternSetName field's value.
func (s *DeleteLogPatternInput) SetPatternSetName(v string) *DeleteLogPatternInput {
	s.PatternSetName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DeleteLogPatternInput) SetResourceGroupName(v string) *DeleteLogPatternInput {
	s.ResourceGroupName = &v
	return s
}

type DeleteLogPatternOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLogPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogPatternOutput) GoString() string {
	return s.String()
}

type DescribeApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInput"}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeApplicationInput) SetResourceGroupName(v string) *DescribeApplicationInput {
	s.ResourceGroupName = &v
	return s
}

type DescribeApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	ApplicationInfo *ApplicationInfo `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationInfo sets the ApplicationInfo field's value.
func (s *DescribeApplicationOutput) SetApplicationInfo(v *ApplicationInfo) *DescribeApplicationOutput {
	s.ApplicationInfo = v
	return s
}

type DescribeComponentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeComponentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComponentConfigurationInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DescribeComponentConfigurationInput) SetComponentName(v string) *DescribeComponentConfigurationInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeComponentConfigurationInput) SetResourceGroupName(v string) *DescribeComponentConfigurationInput {
	s.ResourceGroupName = &v
	return s
}

type DescribeComponentConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings of the component. The value is the escaped JSON
	// of the configuration.
	ComponentConfiguration *string `min:"1" type:"string"`

	// Indicates whether the application component is monitored.
	Monitor *bool `type:"boolean"`

	// The tier of the application component. Supported tiers include DOT_NET_CORE,
	// DOT_NET_WORKER, DOT_NET_WEB, SQL_SERVER, and DEFAULT
	Tier *string `min:"1" type:"string" enum:"Tier"`
}

// String returns the string representation
func (s DescribeComponentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationOutput) GoString() string {
	return s.String()
}

// SetComponentConfiguration sets the ComponentConfiguration field's value.
func (s *DescribeComponentConfigurationOutput) SetComponentConfiguration(v string) *DescribeComponentConfigurationOutput {
	s.ComponentConfiguration = &v
	return s
}

// SetMonitor sets the Monitor field's value.
func (s *DescribeComponentConfigurationOutput) SetMonitor(v bool) *DescribeComponentConfigurationOutput {
	s.Monitor = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *DescribeComponentConfigurationOutput) SetTier(v string) *DescribeComponentConfigurationOutput {
	s.Tier = &v
	return s
}

type DescribeComponentConfigurationRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`

	// The tier of the application component. Supported tiers include DOT_NET_CORE,
	// DOT_NET_WORKER, DOT_NET_WEB, SQL_SERVER, and DEFAULT.
	//
	// Tier is a required field
	Tier *string `min:"1" type:"string" required:"true" enum:"Tier"`
}

// String returns the string representation
func (s DescribeComponentConfigurationRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentConfigurationRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComponentConfigurationRecommendationInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}
	if s.Tier == nil {
		invalidParams.Add(request.NewErrParamRequired("Tier"))
	}
	if s.Tier != nil && len(*s.Tier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DescribeComponentConfigurationRecommendationInput) SetComponentName(v string) *DescribeComponentConfigurationRecommendationInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeComponentConfigurationRecommendationInput) SetResourceGroupName(v string) *DescribeComponentConfigurationRecommendationInput {
	s.ResourceGroupName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *DescribeComponentConfigurationRecommendationInput) SetTier(v string) *DescribeComponentConfigurationRecommendationInput {
	s.Tier = &v
	return s
}

type DescribeComponentConfigurationRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The recommended configuration settings of the component. The value is the
	// escaped JSON of the configuration.
	ComponentConfiguration *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeComponentConfigurationRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentConfigurationRecommendationOutput) GoString() string {
	return s.String()
}

// SetComponentConfiguration sets the ComponentConfiguration field's value.
func (s *DescribeComponentConfigurationRecommendationOutput) SetComponentConfiguration(v string) *DescribeComponentConfigurationRecommendationOutput {
	s.ComponentConfiguration = &v
	return s
}

type DescribeComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *DescribeComponentInput) SetComponentName(v string) *DescribeComponentInput {
	s.ComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeComponentInput) SetResourceGroupName(v string) *DescribeComponentInput {
	s.ResourceGroupName = &v
	return s
}

type DescribeComponentOutput struct {
	_ struct{} `type:"structure"`

	// Describes a standalone resource or similarly grouped resources that the application
	// is made up of.
	ApplicationComponent *ApplicationComponent `type:"structure"`

	// The list of resource ARNs that belong to the component.
	ResourceList []*string `type:"list"`
}

// String returns the string representation
func (s DescribeComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComponentOutput) GoString() string {
	return s.String()
}

// SetApplicationComponent sets the ApplicationComponent field's value.
func (s *DescribeComponentOutput) SetApplicationComponent(v *ApplicationComponent) *DescribeComponentOutput {
	s.ApplicationComponent = v
	return s
}

// SetResourceList sets the ResourceList field's value.
func (s *DescribeComponentOutput) SetResourceList(v []*string) *DescribeComponentOutput {
	s.ResourceList = v
	return s
}

type DescribeLogPatternInput struct {
	_ struct{} `type:"structure"`

	// The name of the log pattern.
	//
	// PatternName is a required field
	PatternName *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern set.
	//
	// PatternSetName is a required field
	PatternSetName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLogPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLogPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLogPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLogPatternInput"}
	if s.PatternName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternName"))
	}
	if s.PatternName != nil && len(*s.PatternName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternName", 1))
	}
	if s.PatternSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternSetName"))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternSetName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatternName sets the PatternName field's value.
func (s *DescribeLogPatternInput) SetPatternName(v string) *DescribeLogPatternInput {
	s.PatternName = &v
	return s
}

// SetPatternSetName sets the PatternSetName field's value.
func (s *DescribeLogPatternInput) SetPatternSetName(v string) *DescribeLogPatternInput {
	s.PatternSetName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeLogPatternInput) SetResourceGroupName(v string) *DescribeLogPatternInput {
	s.ResourceGroupName = &v
	return s
}

type DescribeLogPatternOutput struct {
	_ struct{} `type:"structure"`

	// The successfully created log pattern.
	LogPattern *LogPattern `type:"structure"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeLogPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLogPatternOutput) GoString() string {
	return s.String()
}

// SetLogPattern sets the LogPattern field's value.
func (s *DescribeLogPatternOutput) SetLogPattern(v *LogPattern) *DescribeLogPatternOutput {
	s.LogPattern = v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *DescribeLogPatternOutput) SetResourceGroupName(v string) *DescribeLogPatternOutput {
	s.ResourceGroupName = &v
	return s
}

type DescribeObservationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the observation.
	//
	// ObservationId is a required field
	ObservationId *string `min:"38" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeObservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeObservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeObservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeObservationInput"}
	if s.ObservationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ObservationId"))
	}
	if s.ObservationId != nil && len(*s.ObservationId) < 38 {
		invalidParams.Add(request.NewErrParamMinLen("ObservationId", 38))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObservationId sets the ObservationId field's value.
func (s *DescribeObservationInput) SetObservationId(v string) *DescribeObservationInput {
	s.ObservationId = &v
	return s
}

type DescribeObservationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the observation.
	Observation *Observation `type:"structure"`
}

// String returns the string representation
func (s DescribeObservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeObservationOutput) GoString() string {
	return s.String()
}

// SetObservation sets the Observation field's value.
func (s *DescribeObservationOutput) SetObservation(v *Observation) *DescribeObservationOutput {
	s.Observation = v
	return s
}

type DescribeProblemInput struct {
	_ struct{} `type:"structure"`

	// The ID of the problem.
	//
	// ProblemId is a required field
	ProblemId *string `min:"38" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProblemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProblemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProblemInput"}
	if s.ProblemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProblemId"))
	}
	if s.ProblemId != nil && len(*s.ProblemId) < 38 {
		invalidParams.Add(request.NewErrParamMinLen("ProblemId", 38))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProblemId sets the ProblemId field's value.
func (s *DescribeProblemInput) SetProblemId(v string) *DescribeProblemInput {
	s.ProblemId = &v
	return s
}

type DescribeProblemObservationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the problem.
	//
	// ProblemId is a required field
	ProblemId *string `min:"38" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProblemObservationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemObservationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProblemObservationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProblemObservationsInput"}
	if s.ProblemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProblemId"))
	}
	if s.ProblemId != nil && len(*s.ProblemId) < 38 {
		invalidParams.Add(request.NewErrParamMinLen("ProblemId", 38))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProblemId sets the ProblemId field's value.
func (s *DescribeProblemObservationsInput) SetProblemId(v string) *DescribeProblemObservationsInput {
	s.ProblemId = &v
	return s
}

type DescribeProblemObservationsOutput struct {
	_ struct{} `type:"structure"`

	// Observations related to the problem.
	RelatedObservations *RelatedObservations `type:"structure"`
}

// String returns the string representation
func (s DescribeProblemObservationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemObservationsOutput) GoString() string {
	return s.String()
}

// SetRelatedObservations sets the RelatedObservations field's value.
func (s *DescribeProblemObservationsOutput) SetRelatedObservations(v *RelatedObservations) *DescribeProblemObservationsOutput {
	s.RelatedObservations = v
	return s
}

type DescribeProblemOutput struct {
	_ struct{} `type:"structure"`

	// Information about the problem.
	Problem *Problem `type:"structure"`
}

// String returns the string representation
func (s DescribeProblemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProblemOutput) GoString() string {
	return s.String()
}

// SetProblem sets the Problem field's value.
func (s *DescribeProblemOutput) SetProblem(v *Problem) *DescribeProblemOutput {
	s.Problem = v
	return s
}

// The server encountered an internal error and is unable to complete the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of applications.
	ApplicationInfoList []*ApplicationInfo `type:"list"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationInfoList sets the ApplicationInfoList field's value.
func (s *ListApplicationsOutput) SetApplicationInfoList(v []*ApplicationInfo) *ListApplicationsOutput {
	s.ApplicationInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListComponentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsInput) SetMaxResults(v int64) *ListComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsInput) SetNextToken(v string) *ListComponentsInput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListComponentsInput) SetResourceGroupName(v string) *ListComponentsInput {
	s.ResourceGroupName = &v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of application components.
	ApplicationComponentList []*ApplicationComponent `type:"list"`

	// The token to request the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetApplicationComponentList sets the ApplicationComponentList field's value.
func (s *ListComponentsOutput) SetApplicationComponentList(v []*ApplicationComponent) *ListComponentsOutput {
	s.ApplicationComponentList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

type ListConfigurationHistoryInput struct {
	_ struct{} `type:"structure"`

	// The end time of the event.
	EndTime *time.Time `type:"timestamp"`

	// The status of the configuration update event. Possible values include INFO,
	// WARN, and ERROR.
	EventStatus *string `type:"string" enum:"ConfigurationEventStatus"`

	// The maximum number of results returned by ListConfigurationHistory in paginated
	// output. When this parameter is used, ListConfigurationHistory returns only
	// MaxResults in a single page along with a NextToken response element. The
	// remaining results of the initial request can be seen by sending another ListConfigurationHistory
	// request with the returned NextToken value. If this parameter is not used,
	// then ListConfigurationHistory returns all results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value returned from a previous paginated ListConfigurationHistory
	// request where MaxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the NextToken value. This value is null when there are no more results
	// to return.
	NextToken *string `min:"1" type:"string"`

	// Resource group to which the application belongs.
	ResourceGroupName *string `min:"1" type:"string"`

	// The start time of the event.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ListConfigurationHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationHistoryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListConfigurationHistoryInput) SetEndTime(v time.Time) *ListConfigurationHistoryInput {
	s.EndTime = &v
	return s
}

// SetEventStatus sets the EventStatus field's value.
func (s *ListConfigurationHistoryInput) SetEventStatus(v string) *ListConfigurationHistoryInput {
	s.EventStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationHistoryInput) SetMaxResults(v int64) *ListConfigurationHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationHistoryInput) SetNextToken(v string) *ListConfigurationHistoryInput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListConfigurationHistoryInput) SetResourceGroupName(v string) *ListConfigurationHistoryInput {
	s.ResourceGroupName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListConfigurationHistoryInput) SetStartTime(v time.Time) *ListConfigurationHistoryInput {
	s.StartTime = &v
	return s
}

type ListConfigurationHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of configuration events and their corresponding details.
	EventList []*ConfigurationEvent `type:"list"`

	// The NextToken value to include in a future ListConfigurationHistory request.
	// When the results of a ListConfigurationHistory request exceed MaxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListConfigurationHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationHistoryOutput) GoString() string {
	return s.String()
}

// SetEventList sets the EventList field's value.
func (s *ListConfigurationHistoryOutput) SetEventList(v []*ConfigurationEvent) *ListConfigurationHistoryOutput {
	s.EventList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationHistoryOutput) SetNextToken(v string) *ListConfigurationHistoryOutput {
	s.NextToken = &v
	return s
}

type ListLogPatternSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLogPatternSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLogPatternSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLogPatternSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLogPatternSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLogPatternSetsInput) SetMaxResults(v int64) *ListLogPatternSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogPatternSetsInput) SetNextToken(v string) *ListLogPatternSetsInput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListLogPatternSetsInput) SetResourceGroupName(v string) *ListLogPatternSetsInput {
	s.ResourceGroupName = &v
	return s
}

type ListLogPatternSetsOutput struct {
	_ struct{} `type:"structure"`

	// The list of log pattern sets.
	LogPatternSets []*string `type:"list"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListLogPatternSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLogPatternSetsOutput) GoString() string {
	return s.String()
}

// SetLogPatternSets sets the LogPatternSets field's value.
func (s *ListLogPatternSetsOutput) SetLogPatternSets(v []*string) *ListLogPatternSetsOutput {
	s.LogPatternSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogPatternSetsOutput) SetNextToken(v string) *ListLogPatternSetsOutput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListLogPatternSetsOutput) SetResourceGroupName(v string) *ListLogPatternSetsOutput {
	s.ResourceGroupName = &v
	return s
}

type ListLogPatternsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the log pattern set.
	PatternSetName *string `min:"1" type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLogPatternsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLogPatternsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLogPatternsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLogPatternsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternSetName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLogPatternsInput) SetMaxResults(v int64) *ListLogPatternsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogPatternsInput) SetNextToken(v string) *ListLogPatternsInput {
	s.NextToken = &v
	return s
}

// SetPatternSetName sets the PatternSetName field's value.
func (s *ListLogPatternsInput) SetPatternSetName(v string) *ListLogPatternsInput {
	s.PatternSetName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListLogPatternsInput) SetResourceGroupName(v string) *ListLogPatternsInput {
	s.ResourceGroupName = &v
	return s
}

type ListLogPatternsOutput struct {
	_ struct{} `type:"structure"`

	// The list of log patterns.
	LogPatterns []*LogPattern `type:"list"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListLogPatternsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLogPatternsOutput) GoString() string {
	return s.String()
}

// SetLogPatterns sets the LogPatterns field's value.
func (s *ListLogPatternsOutput) SetLogPatterns(v []*LogPattern) *ListLogPatternsOutput {
	s.LogPatterns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogPatternsOutput) SetNextToken(v string) *ListLogPatternsOutput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListLogPatternsOutput) SetResourceGroupName(v string) *ListLogPatternsOutput {
	s.ResourceGroupName = &v
	return s
}

type ListProblemsInput struct {
	_ struct{} `type:"structure"`

	// The time when the problem ended, in epoch seconds. If not specified, problems
	// within the past seven days are returned.
	EndTime *time.Time `type:"timestamp"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`

	// The time when the problem was detected, in epoch seconds. If you don't specify
	// a time frame for the request, problems within the past seven days are returned.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ListProblemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProblemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProblemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProblemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListProblemsInput) SetEndTime(v time.Time) *ListProblemsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProblemsInput) SetMaxResults(v int64) *ListProblemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProblemsInput) SetNextToken(v string) *ListProblemsInput {
	s.NextToken = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *ListProblemsInput) SetResourceGroupName(v string) *ListProblemsInput {
	s.ResourceGroupName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListProblemsInput) SetStartTime(v time.Time) *ListProblemsInput {
	s.StartTime = &v
	return s
}

type ListProblemsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// The list of problems.
	ProblemList []*Problem `type:"list"`
}

// String returns the string representation
func (s ListProblemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProblemsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProblemsOutput) SetNextToken(v string) *ListProblemsOutput {
	s.NextToken = &v
	return s
}

// SetProblemList sets the ProblemList field's value.
func (s *ListProblemsOutput) SetProblemList(v []*Problem) *ListProblemsOutput {
	s.ProblemList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application that you want to retrieve
	// tag information for.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array that lists all the tags that are associated with the application.
	// Each tag consists of a required tag key (Key) and an associated tag value
	// (Value).
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// An object that defines the log patterns that belongs to a LogPatternSet.
type LogPattern struct {
	_ struct{} `type:"structure"`

	// A regular expression that defines the log pattern. A log pattern can contain
	// as many as 50 characters, and it cannot be empty. The pattern must be DFA
	// compatible. Patterns that utilize forward lookahead or backreference constructions
	// are not supported.
	Pattern *string `min:"1" type:"string"`

	// The name of the log pattern. A log pattern name can contain as many as 50
	// characters, and it cannot be empty. The characters can be Unicode letters,
	// digits, or one of the following symbols: period, dash, underscore.
	PatternName *string `min:"1" type:"string"`

	// The name of the log pattern. A log pattern name can contain as many as 30
	// characters, and it cannot be empty. The characters can be Unicode letters,
	// digits, or one of the following symbols: period, dash, underscore.
	PatternSetName *string `min:"1" type:"string"`

	// Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns
	// are sorted by rank, so we recommend that you set your highest priority patterns
	// with the lowest rank. A pattern of rank 1 will be the first to get matched
	// to a log line. A pattern of rank 1,000,000 will be last to get matched. When
	// you configure custom log patterns from the console, a Low severity pattern
	// translates to a 750,000 rank. A Medium severity pattern translates to a 500,000
	// rank. And a High severity pattern translates to a 250,000 rank. Rank values
	// less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
	Rank *int64 `type:"integer"`
}

// String returns the string representation
func (s LogPattern) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogPattern) GoString() string {
	return s.String()
}

// SetPattern sets the Pattern field's value.
func (s *LogPattern) SetPattern(v string) *LogPattern {
	s.Pattern = &v
	return s
}

// SetPatternName sets the PatternName field's value.
func (s *LogPattern) SetPatternName(v string) *LogPattern {
	s.PatternName = &v
	return s
}

// SetPatternSetName sets the PatternSetName field's value.
func (s *LogPattern) SetPatternSetName(v string) *LogPattern {
	s.PatternSetName = &v
	return s
}

// SetRank sets the Rank field's value.
func (s *LogPattern) SetRank(v int64) *LogPattern {
	s.Rank = &v
	return s
}

// Describes an anomaly or error with the application.
type Observation struct {
	_ struct{} `type:"structure"`

	// The detail type of the CloudWatch Event-based observation, for example, EC2
	// Instance State-change Notification.
	CloudWatchEventDetailType *string `type:"string"`

	// The ID of the CloudWatch Event-based observation related to the detected
	// problem.
	CloudWatchEventId *string `type:"string"`

	// The source of the CloudWatch Event.
	CloudWatchEventSource *string `type:"string" enum:"CloudWatchEventSource"`

	// The CodeDeploy application to which the deployment belongs.
	CodeDeployApplication *string `type:"string"`

	// The deployment group to which the CodeDeploy deployment belongs.
	CodeDeployDeploymentGroup *string `type:"string"`

	// The deployment ID of the CodeDeploy-based observation related to the detected
	// problem.
	CodeDeployDeploymentId *string `type:"string"`

	// The instance group to which the CodeDeploy instance belongs.
	CodeDeployInstanceGroupId *string `type:"string"`

	// The status of the CodeDeploy deployment, for example SUCCESS or FAILURE.
	CodeDeployState *string `type:"string"`

	// The cause of an EBS CloudWatch event.
	EbsCause *string `type:"string"`

	// The type of EBS CloudWatch event, such as createVolume, deleteVolume or attachVolume.
	EbsEvent *string `type:"string"`

	// The request ID of an EBS CloudWatch event.
	EbsRequestId *string `type:"string"`

	// The result of an EBS CloudWatch event, such as failed or succeeded.
	EbsResult *string `type:"string"`

	// The state of the instance, such as STOPPING or TERMINATING.
	Ec2State *string `type:"string"`

	// The time when the observation ended, in epoch seconds.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the AWS Health Event-based observation.
	HealthEventArn *string `type:"string"`

	// The description of the AWS Health event provided by the service, such as
	// Amazon EC2.
	HealthEventDescription *string `type:"string"`

	// The category of the AWS Health event, such as issue.
	HealthEventTypeCategory *string `type:"string"`

	// The type of the AWS Health event, for example, AWS_EC2_POWER_CONNECTIVITY_ISSUE.
	HealthEventTypeCode *string `type:"string"`

	// The service to which the AWS Health Event belongs, such as EC2.
	HealthService *string `type:"string"`

	// The ID of the observation type.
	Id *string `min:"38" type:"string"`

	// The timestamp in the CloudWatch Logs that specifies when the matched line
	// occurred.
	LineTime *time.Time `type:"timestamp"`

	// The log filter of the observation.
	LogFilter *string `type:"string" enum:"LogFilter"`

	// The log group name.
	LogGroup *string `type:"string"`

	// The log text of the observation.
	LogText *string `type:"string"`

	// The name of the observation metric.
	MetricName *string `type:"string"`

	// The namespace of the observation metric.
	MetricNamespace *string `type:"string"`

	// The category of an RDS event.
	RdsEventCategories *string `type:"string"`

	// The message of an RDS event.
	RdsEventMessage *string `type:"string"`

	// The name of the S3 CloudWatch Event-based observation.
	S3EventName *string `type:"string"`

	// The source resource ARN of the observation.
	SourceARN *string `type:"string"`

	// The source type of the observation.
	SourceType *string `type:"string"`

	// The time when the observation was first detected, in epoch seconds.
	StartTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the step function-based observation.
	StatesArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the step function execution-based observation.
	StatesExecutionArn *string `type:"string"`

	// The input to the step function-based observation.
	StatesInput *string `type:"string"`

	// The status of the step function-related observation.
	StatesStatus *string `type:"string"`

	// The unit of the source observation metric.
	Unit *string `type:"string"`

	// The value of the source observation metric.
	Value *float64 `type:"double"`

	// The X-Ray request error percentage for this node.
	XRayErrorPercent *int64 `type:"integer"`

	// The X-Ray request fault percentage for this node.
	XRayFaultPercent *int64 `type:"integer"`

	// The name of the X-Ray node.
	XRayNodeName *string `type:"string"`

	// The type of the X-Ray node.
	XRayNodeType *string `type:"string"`

	// The X-Ray node request average latency for this node.
	XRayRequestAverageLatency *int64 `type:"long"`

	// The X-Ray request count for this node.
	XRayRequestCount *int64 `type:"integer"`

	// The X-Ray request throttle percentage for this node.
	XRayThrottlePercent *int64 `type:"integer"`
}

// String returns the string representation
func (s Observation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Observation) GoString() string {
	return s.String()
}

// SetCloudWatchEventDetailType sets the CloudWatchEventDetailType field's value.
func (s *Observation) SetCloudWatchEventDetailType(v string) *Observation {
	s.CloudWatchEventDetailType = &v
	return s
}

// SetCloudWatchEventId sets the CloudWatchEventId field's value.
func (s *Observation) SetCloudWatchEventId(v string) *Observation {
	s.CloudWatchEventId = &v
	return s
}

// SetCloudWatchEventSource sets the CloudWatchEventSource field's value.
func (s *Observation) SetCloudWatchEventSource(v string) *Observation {
	s.CloudWatchEventSource = &v
	return s
}

// SetCodeDeployApplication sets the CodeDeployApplication field's value.
func (s *Observation) SetCodeDeployApplication(v string) *Observation {
	s.CodeDeployApplication = &v
	return s
}

// SetCodeDeployDeploymentGroup sets the CodeDeployDeploymentGroup field's value.
func (s *Observation) SetCodeDeployDeploymentGroup(v string) *Observation {
	s.CodeDeployDeploymentGroup = &v
	return s
}

// SetCodeDeployDeploymentId sets the CodeDeployDeploymentId field's value.
func (s *Observation) SetCodeDeployDeploymentId(v string) *Observation {
	s.CodeDeployDeploymentId = &v
	return s
}

// SetCodeDeployInstanceGroupId sets the CodeDeployInstanceGroupId field's value.
func (s *Observation) SetCodeDeployInstanceGroupId(v string) *Observation {
	s.CodeDeployInstanceGroupId = &v
	return s
}

// SetCodeDeployState sets the CodeDeployState field's value.
func (s *Observation) SetCodeDeployState(v string) *Observation {
	s.CodeDeployState = &v
	return s
}

// SetEbsCause sets the EbsCause field's value.
func (s *Observation) SetEbsCause(v string) *Observation {
	s.EbsCause = &v
	return s
}

// SetEbsEvent sets the EbsEvent field's value.
func (s *Observation) SetEbsEvent(v string) *Observation {
	s.EbsEvent = &v
	return s
}

// SetEbsRequestId sets the EbsRequestId field's value.
func (s *Observation) SetEbsRequestId(v string) *Observation {
	s.EbsRequestId = &v
	return s
}

// SetEbsResult sets the EbsResult field's value.
func (s *Observation) SetEbsResult(v string) *Observation {
	s.EbsResult = &v
	return s
}

// SetEc2State sets the Ec2State field's value.
func (s *Observation) SetEc2State(v string) *Observation {
	s.Ec2State = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Observation) SetEndTime(v time.Time) *Observation {
	s.EndTime = &v
	return s
}

// SetHealthEventArn sets the HealthEventArn field's value.
func (s *Observation) SetHealthEventArn(v string) *Observation {
	s.HealthEventArn = &v
	return s
}

// SetHealthEventDescription sets the HealthEventDescription field's value.
func (s *Observation) SetHealthEventDescription(v string) *Observation {
	s.HealthEventDescription = &v
	return s
}

// SetHealthEventTypeCategory sets the HealthEventTypeCategory field's value.
func (s *Observation) SetHealthEventTypeCategory(v string) *Observation {
	s.HealthEventTypeCategory = &v
	return s
}

// SetHealthEventTypeCode sets the HealthEventTypeCode field's value.
func (s *Observation) SetHealthEventTypeCode(v string) *Observation {
	s.HealthEventTypeCode = &v
	return s
}

// SetHealthService sets the HealthService field's value.
func (s *Observation) SetHealthService(v string) *Observation {
	s.HealthService = &v
	return s
}

// SetId sets the Id field's value.
func (s *Observation) SetId(v string) *Observation {
	s.Id = &v
	return s
}

// SetLineTime sets the LineTime field's value.
func (s *Observation) SetLineTime(v time.Time) *Observation {
	s.LineTime = &v
	return s
}

// SetLogFilter sets the LogFilter field's value.
func (s *Observation) SetLogFilter(v string) *Observation {
	s.LogFilter = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *Observation) SetLogGroup(v string) *Observation {
	s.LogGroup = &v
	return s
}

// SetLogText sets the LogText field's value.
func (s *Observation) SetLogText(v string) *Observation {
	s.LogText = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Observation) SetMetricName(v string) *Observation {
	s.MetricName = &v
	return s
}

// SetMetricNamespace sets the MetricNamespace field's value.
func (s *Observation) SetMetricNamespace(v string) *Observation {
	s.MetricNamespace = &v
	return s
}

// SetRdsEventCategories sets the RdsEventCategories field's value.
func (s *Observation) SetRdsEventCategories(v string) *Observation {
	s.RdsEventCategories = &v
	return s
}

// SetRdsEventMessage sets the RdsEventMessage field's value.
func (s *Observation) SetRdsEventMessage(v string) *Observation {
	s.RdsEventMessage = &v
	return s
}

// SetS3EventName sets the S3EventName field's value.
func (s *Observation) SetS3EventName(v string) *Observation {
	s.S3EventName = &v
	return s
}

// SetSourceARN sets the SourceARN field's value.
func (s *Observation) SetSourceARN(v string) *Observation {
	s.SourceARN = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Observation) SetSourceType(v string) *Observation {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Observation) SetStartTime(v time.Time) *Observation {
	s.StartTime = &v
	return s
}

// SetStatesArn sets the StatesArn field's value.
func (s *Observation) SetStatesArn(v string) *Observation {
	s.StatesArn = &v
	return s
}

// SetStatesExecutionArn sets the StatesExecutionArn field's value.
func (s *Observation) SetStatesExecutionArn(v string) *Observation {
	s.StatesExecutionArn = &v
	return s
}

// SetStatesInput sets the StatesInput field's value.
func (s *Observation) SetStatesInput(v string) *Observation {
	s.StatesInput = &v
	return s
}

// SetStatesStatus sets the StatesStatus field's value.
func (s *Observation) SetStatesStatus(v string) *Observation {
	s.StatesStatus = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Observation) SetUnit(v string) *Observation {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Observation) SetValue(v float64) *Observation {
	s.Value = &v
	return s
}

// SetXRayErrorPercent sets the XRayErrorPercent field's value.
func (s *Observation) SetXRayErrorPercent(v int64) *Observation {
	s.XRayErrorPercent = &v
	return s
}

// SetXRayFaultPercent sets the XRayFaultPercent field's value.
func (s *Observation) SetXRayFaultPercent(v int64) *Observation {
	s.XRayFaultPercent = &v
	return s
}

// SetXRayNodeName sets the XRayNodeName field's value.
func (s *Observation) SetXRayNodeName(v string) *Observation {
	s.XRayNodeName = &v
	return s
}

// SetXRayNodeType sets the XRayNodeType field's value.
func (s *Observation) SetXRayNodeType(v string) *Observation {
	s.XRayNodeType = &v
	return s
}

// SetXRayRequestAverageLatency sets the XRayRequestAverageLatency field's value.
func (s *Observation) SetXRayRequestAverageLatency(v int64) *Observation {
	s.XRayRequestAverageLatency = &v
	return s
}

// SetXRayRequestCount sets the XRayRequestCount field's value.
func (s *Observation) SetXRayRequestCount(v int64) *Observation {
	s.XRayRequestCount = &v
	return s
}

// SetXRayThrottlePercent sets the XRayThrottlePercent field's value.
func (s *Observation) SetXRayThrottlePercent(v int64) *Observation {
	s.XRayThrottlePercent = &v
	return s
}

// Describes a problem that is detected by correlating observations.
type Problem struct {
	_ struct{} `type:"structure"`

	// The resource affected by the problem.
	AffectedResource *string `type:"string"`

	// The time when the problem ended, in epoch seconds.
	EndTime *time.Time `type:"timestamp"`

	// Feedback provided by the user about the problem.
	Feedback map[string]*string `type:"map"`

	// The ID of the problem.
	Id *string `min:"38" type:"string"`

	// A detailed analysis of the problem using machine learning.
	Insights *string `type:"string"`

	// The name of the resource group affected by the problem.
	ResourceGroupName *string `min:"1" type:"string"`

	// A measure of the level of impact of the problem.
	SeverityLevel *string `type:"string" enum:"SeverityLevel"`

	// The time when the problem started, in epoch seconds.
	StartTime *time.Time `type:"timestamp"`

	// The status of the problem.
	Status *string `type:"string" enum:"Status"`

	// The name of the problem.
	Title *string `type:"string"`
}

// String returns the string representation
func (s Problem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Problem) GoString() string {
	return s.String()
}

// SetAffectedResource sets the AffectedResource field's value.
func (s *Problem) SetAffectedResource(v string) *Problem {
	s.AffectedResource = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Problem) SetEndTime(v time.Time) *Problem {
	s.EndTime = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *Problem) SetFeedback(v map[string]*string) *Problem {
	s.Feedback = v
	return s
}

// SetId sets the Id field's value.
func (s *Problem) SetId(v string) *Problem {
	s.Id = &v
	return s
}

// SetInsights sets the Insights field's value.
func (s *Problem) SetInsights(v string) *Problem {
	s.Insights = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *Problem) SetResourceGroupName(v string) *Problem {
	s.ResourceGroupName = &v
	return s
}

// SetSeverityLevel sets the SeverityLevel field's value.
func (s *Problem) SetSeverityLevel(v string) *Problem {
	s.SeverityLevel = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Problem) SetStartTime(v time.Time) *Problem {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Problem) SetStatus(v string) *Problem {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Problem) SetTitle(v string) *Problem {
	s.Title = &v
	return s
}

// Describes observations related to the problem.
type RelatedObservations struct {
	_ struct{} `type:"structure"`

	// The list of observations related to the problem.
	ObservationList []*Observation `type:"list"`
}

// String returns the string representation
func (s RelatedObservations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelatedObservations) GoString() string {
	return s.String()
}

// SetObservationList sets the ObservationList field's value.
func (s *RelatedObservations) SetObservationList(v []*Observation) *RelatedObservations {
	s.ObservationList = v
	return s
}

// The resource is already created or in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource does not exist in the customer account.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines the tags associated with an application. A tag is
// a label that you optionally define and associate with an application. Tags
// can help you categorize and manage resources in different ways, such as by
// purpose, owner, environment, or other criteria.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for a more specific tag value. A tag value acts as a descriptor within a
// tag key. A tag key can contain as many as 128 characters. A tag value can
// contain as many as 256 characters. The characters can be Unicode letters,
// digits, white space, or one of the following symbols: _ . : / = + -. The
// following additional restrictions apply to tags:
//
//    * Tag keys and values are case sensitive.
//
//    * For each associated resource, each tag key must be unique and it can
//    have only one value.
//
//    * The aws: prefix is reserved for use by AWS; you can’t use it in any
//    tag keys or values that you define. In addition, you can't edit or remove
//    tag keys or values that use this prefix.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that defines a tag. The maximum length of a
	// tag key is 128 characters. The minimum length is 1 character.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that defines a tag. The maximum length
	// of a tag value is 256 characters. The minimum length is 0 characters. If
	// you don't want an application to have a specific tag value, don't specify
	// a value for this parameter.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application that you want to add one
	// or more tags to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tags that to add to the application. A tag consists of a required
	// tag key (Key) and an associated tag value (Value). The maximum length of
	// a tag key is 128 characters. The maximum length of a tag value is 256 characters.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Tags are already registered for the specified application ARN.
type TagsAlreadyExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TagsAlreadyExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagsAlreadyExistException) GoString() string {
	return s.String()
}

func newErrorTagsAlreadyExistException(v protocol.ResponseMetadata) error {
	return &TagsAlreadyExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagsAlreadyExistException) Code() string {
	return "TagsAlreadyExistException"
}

// Message returns the exception's message.
func (s *TagsAlreadyExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagsAlreadyExistException) OrigErr() error {
	return nil
}

func (s *TagsAlreadyExistException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagsAlreadyExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagsAlreadyExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The number of the provided tags is beyond the limit, or the number of total
// tags you are trying to attach to the specified resource exceeds the limit.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the resource with too many tags.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application that you want to remove
	// one or more tags from.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags (tag keys) that you want to remove from the resource. When you specify
	// a tag key, the action removes both that key and its associated tag value.
	//
	// To remove more than one tag from the application, append the TagKeys parameter
	// and argument for each additional tag to remove, separated by an ampersand.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether Application Insights can listen to CloudWatch events for
	// the application resources, such as instance terminated, failed deployment,
	// and others.
	CWEMonitorEnabled *bool `type:"boolean"`

	// When set to true, creates opsItems for any problems detected on an application.
	OpsCenterEnabled *bool `type:"boolean"`

	// The SNS topic provided to Application Insights that is associated to the
	// created opsItem. Allows you to receive notifications for updates to the opsItem.
	OpsItemSNSTopicArn *string `min:"20" type:"string"`

	// Disassociates the SNS topic from the opsItem created for detected problems.
	RemoveSNSTopic *bool `type:"boolean"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.OpsItemSNSTopicArn != nil && len(*s.OpsItemSNSTopicArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OpsItemSNSTopicArn", 20))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCWEMonitorEnabled sets the CWEMonitorEnabled field's value.
func (s *UpdateApplicationInput) SetCWEMonitorEnabled(v bool) *UpdateApplicationInput {
	s.CWEMonitorEnabled = &v
	return s
}

// SetOpsCenterEnabled sets the OpsCenterEnabled field's value.
func (s *UpdateApplicationInput) SetOpsCenterEnabled(v bool) *UpdateApplicationInput {
	s.OpsCenterEnabled = &v
	return s
}

// SetOpsItemSNSTopicArn sets the OpsItemSNSTopicArn field's value.
func (s *UpdateApplicationInput) SetOpsItemSNSTopicArn(v string) *UpdateApplicationInput {
	s.OpsItemSNSTopicArn = &v
	return s
}

// SetRemoveSNSTopic sets the RemoveSNSTopic field's value.
func (s *UpdateApplicationInput) SetRemoveSNSTopic(v bool) *UpdateApplicationInput {
	s.RemoveSNSTopic = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *UpdateApplicationInput) SetResourceGroupName(v string) *UpdateApplicationInput {
	s.ResourceGroupName = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	ApplicationInfo *ApplicationInfo `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationInfo sets the ApplicationInfo field's value.
func (s *UpdateApplicationOutput) SetApplicationInfo(v *ApplicationInfo) *UpdateApplicationOutput {
	s.ApplicationInfo = v
	return s
}

type UpdateComponentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The configuration settings of the component. The value is the escaped JSON
	// of the configuration. For more information about the JSON format, see Working
	// with JSON (https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html).
	// You can send a request to DescribeComponentConfigurationRecommendation to
	// see the recommended configuration for a component. For the complete format
	// of the component configuration file, see Component Configuration (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html).
	ComponentConfiguration *string `min:"1" type:"string"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the application component is monitored.
	Monitor *bool `type:"boolean"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`

	// The tier of the application component. Supported tiers include DOT_NET_WORKER,
	// DOT_NET_WEB, DOT_NET_CORE, SQL_SERVER, and DEFAULT.
	Tier *string `min:"1" type:"string" enum:"Tier"`
}

// String returns the string representation
func (s UpdateComponentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentConfigurationInput"}
	if s.ComponentConfiguration != nil && len(*s.ComponentConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentConfiguration", 1))
	}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}
	if s.Tier != nil && len(*s.Tier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentConfiguration sets the ComponentConfiguration field's value.
func (s *UpdateComponentConfigurationInput) SetComponentConfiguration(v string) *UpdateComponentConfigurationInput {
	s.ComponentConfiguration = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *UpdateComponentConfigurationInput) SetComponentName(v string) *UpdateComponentConfigurationInput {
	s.ComponentName = &v
	return s
}

// SetMonitor sets the Monitor field's value.
func (s *UpdateComponentConfigurationInput) SetMonitor(v bool) *UpdateComponentConfigurationInput {
	s.Monitor = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *UpdateComponentConfigurationInput) SetResourceGroupName(v string) *UpdateComponentConfigurationInput {
	s.ResourceGroupName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *UpdateComponentConfigurationInput) SetTier(v string) *UpdateComponentConfigurationInput {
	s.Tier = &v
	return s
}

type UpdateComponentConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateComponentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `min:"1" type:"string" required:"true"`

	// The new name of the component.
	NewComponentName *string `min:"1" type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`

	// The list of resource ARNs that belong to the component.
	ResourceList []*string `type:"list"`
}

// String returns the string representation
func (s UpdateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.NewComponentName != nil && len(*s.NewComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewComponentName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *UpdateComponentInput) SetComponentName(v string) *UpdateComponentInput {
	s.ComponentName = &v
	return s
}

// SetNewComponentName sets the NewComponentName field's value.
func (s *UpdateComponentInput) SetNewComponentName(v string) *UpdateComponentInput {
	s.NewComponentName = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *UpdateComponentInput) SetResourceGroupName(v string) *UpdateComponentInput {
	s.ResourceGroupName = &v
	return s
}

// SetResourceList sets the ResourceList field's value.
func (s *UpdateComponentInput) SetResourceList(v []*string) *UpdateComponentInput {
	s.ResourceList = v
	return s
}

type UpdateComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComponentOutput) GoString() string {
	return s.String()
}

type UpdateLogPatternInput struct {
	_ struct{} `type:"structure"`

	// The log pattern. The pattern must be DFA compatible. Patterns that utilize
	// forward lookahead or backreference constructions are not supported.
	Pattern *string `min:"1" type:"string"`

	// The name of the log pattern.
	//
	// PatternName is a required field
	PatternName *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern set.
	//
	// PatternSetName is a required field
	PatternSetName *string `min:"1" type:"string" required:"true"`

	// Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns
	// are sorted by rank, so we recommend that you set your highest priority patterns
	// with the lowest rank. A pattern of rank 1 will be the first to get matched
	// to a log line. A pattern of rank 1,000,000 will be last to get matched. When
	// you configure custom log patterns from the console, a Low severity pattern
	// translates to a 750,000 rank. A Medium severity pattern translates to a 500,000
	// rank. And a High severity pattern translates to a 250,000 rank. Rank values
	// less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
	Rank *int64 `type:"integer"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateLogPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLogPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLogPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLogPatternInput"}
	if s.Pattern != nil && len(*s.Pattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Pattern", 1))
	}
	if s.PatternName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternName"))
	}
	if s.PatternName != nil && len(*s.PatternName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternName", 1))
	}
	if s.PatternSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("PatternSetName"))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatternSetName", 1))
	}
	if s.ResourceGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPattern sets the Pattern field's value.
func (s *UpdateLogPatternInput) SetPattern(v string) *UpdateLogPatternInput {
	s.Pattern = &v
	return s
}

// SetPatternName sets the PatternName field's value.
func (s *UpdateLogPatternInput) SetPatternName(v string) *UpdateLogPatternInput {
	s.PatternName = &v
	return s
}

// SetPatternSetName sets the PatternSetName field's value.
func (s *UpdateLogPatternInput) SetPatternSetName(v string) *UpdateLogPatternInput {
	s.PatternSetName = &v
	return s
}

// SetRank sets the Rank field's value.
func (s *UpdateLogPatternInput) SetRank(v int64) *UpdateLogPatternInput {
	s.Rank = &v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *UpdateLogPatternInput) SetResourceGroupName(v string) *UpdateLogPatternInput {
	s.ResourceGroupName = &v
	return s
}

type UpdateLogPatternOutput struct {
	_ struct{} `type:"structure"`

	// The successfully created log pattern.
	LogPattern *LogPattern `type:"structure"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateLogPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLogPatternOutput) GoString() string {
	return s.String()
}

// SetLogPattern sets the LogPattern field's value.
func (s *UpdateLogPatternOutput) SetLogPattern(v *LogPattern) *UpdateLogPatternOutput {
	s.LogPattern = v
	return s
}

// SetResourceGroupName sets the ResourceGroupName field's value.
func (s *UpdateLogPatternOutput) SetResourceGroupName(v string) *UpdateLogPatternOutput {
	s.ResourceGroupName = &v
	return s
}

// The parameter is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// CloudWatchEventSourceEc2 is a CloudWatchEventSource enum value
	CloudWatchEventSourceEc2 = "EC2"

	// CloudWatchEventSourceCodeDeploy is a CloudWatchEventSource enum value
	CloudWatchEventSourceCodeDeploy = "CODE_DEPLOY"

	// CloudWatchEventSourceHealth is a CloudWatchEventSource enum value
	CloudWatchEventSourceHealth = "HEALTH"

	// CloudWatchEventSourceRds is a CloudWatchEventSource enum value
	CloudWatchEventSourceRds = "RDS"
)

// CloudWatchEventSource_Values returns all elements of the CloudWatchEventSource enum
func CloudWatchEventSource_Values() []string {
	return []string{
		CloudWatchEventSourceEc2,
		CloudWatchEventSourceCodeDeploy,
		CloudWatchEventSourceHealth,
		CloudWatchEventSourceRds,
	}
}

const (
	// ConfigurationEventResourceTypeCloudwatchAlarm is a ConfigurationEventResourceType enum value
	ConfigurationEventResourceTypeCloudwatchAlarm = "CLOUDWATCH_ALARM"

	// ConfigurationEventResourceTypeCloudwatchLog is a ConfigurationEventResourceType enum value
	ConfigurationEventResourceTypeCloudwatchLog = "CLOUDWATCH_LOG"

	// ConfigurationEventResourceTypeCloudformation is a ConfigurationEventResourceType enum value
	ConfigurationEventResourceTypeCloudformation = "CLOUDFORMATION"

	// ConfigurationEventResourceTypeSsmAssociation is a ConfigurationEventResourceType enum value
	ConfigurationEventResourceTypeSsmAssociation = "SSM_ASSOCIATION"
)

// ConfigurationEventResourceType_Values returns all elements of the ConfigurationEventResourceType enum
func ConfigurationEventResourceType_Values() []string {
	return []string{
		ConfigurationEventResourceTypeCloudwatchAlarm,
		ConfigurationEventResourceTypeCloudwatchLog,
		ConfigurationEventResourceTypeCloudformation,
		ConfigurationEventResourceTypeSsmAssociation,
	}
}

const (
	// ConfigurationEventStatusInfo is a ConfigurationEventStatus enum value
	ConfigurationEventStatusInfo = "INFO"

	// ConfigurationEventStatusWarn is a ConfigurationEventStatus enum value
	ConfigurationEventStatusWarn = "WARN"

	// ConfigurationEventStatusError is a ConfigurationEventStatus enum value
	ConfigurationEventStatusError = "ERROR"
)

// ConfigurationEventStatus_Values returns all elements of the ConfigurationEventStatus enum
func ConfigurationEventStatus_Values() []string {
	return []string{
		ConfigurationEventStatusInfo,
		ConfigurationEventStatusWarn,
		ConfigurationEventStatusError,
	}
}

const (
	// FeedbackKeyInsightsFeedback is a FeedbackKey enum value
	FeedbackKeyInsightsFeedback = "INSIGHTS_FEEDBACK"
)

// FeedbackKey_Values returns all elements of the FeedbackKey enum
func FeedbackKey_Values() []string {
	return []string{
		FeedbackKeyInsightsFeedback,
	}
}

const (
	// FeedbackValueNotSpecified is a FeedbackValue enum value
	FeedbackValueNotSpecified = "NOT_SPECIFIED"

	// FeedbackValueUseful is a FeedbackValue enum value
	FeedbackValueUseful = "USEFUL"

	// FeedbackValueNotUseful is a FeedbackValue enum value
	FeedbackValueNotUseful = "NOT_USEFUL"
)

// FeedbackValue_Values returns all elements of the FeedbackValue enum
func FeedbackValue_Values() []string {
	return []string{
		FeedbackValueNotSpecified,
		FeedbackValueUseful,
		FeedbackValueNotUseful,
	}
}

const (
	// LogFilterError is a LogFilter enum value
	LogFilterError = "ERROR"

	// LogFilterWarn is a LogFilter enum value
	LogFilterWarn = "WARN"

	// LogFilterInfo is a LogFilter enum value
	LogFilterInfo = "INFO"
)

// LogFilter_Values returns all elements of the LogFilter enum
func LogFilter_Values() []string {
	return []string{
		LogFilterError,
		LogFilterWarn,
		LogFilterInfo,
	}
}

const (
	// OsTypeWindows is a OsType enum value
	OsTypeWindows = "WINDOWS"

	// OsTypeLinux is a OsType enum value
	OsTypeLinux = "LINUX"
)

// OsType_Values returns all elements of the OsType enum
func OsType_Values() []string {
	return []string{
		OsTypeWindows,
		OsTypeLinux,
	}
}

const (
	// SeverityLevelLow is a SeverityLevel enum value
	SeverityLevelLow = "Low"

	// SeverityLevelMedium is a SeverityLevel enum value
	SeverityLevelMedium = "Medium"

	// SeverityLevelHigh is a SeverityLevel enum value
	SeverityLevelHigh = "High"
)

// SeverityLevel_Values returns all elements of the SeverityLevel enum
func SeverityLevel_Values() []string {
	return []string{
		SeverityLevelLow,
		SeverityLevelMedium,
		SeverityLevelHigh,
	}
}

const (
	// StatusIgnore is a Status enum value
	StatusIgnore = "IGNORE"

	// StatusResolved is a Status enum value
	StatusResolved = "RESOLVED"

	// StatusPending is a Status enum value
	StatusPending = "PENDING"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusIgnore,
		StatusResolved,
		StatusPending,
	}
}

const (
	// TierCustom is a Tier enum value
	TierCustom = "CUSTOM"

	// TierDefault is a Tier enum value
	TierDefault = "DEFAULT"

	// TierDotNetCore is a Tier enum value
	TierDotNetCore = "DOT_NET_CORE"

	// TierDotNetWorker is a Tier enum value
	TierDotNetWorker = "DOT_NET_WORKER"

	// TierDotNetWebTier is a Tier enum value
	TierDotNetWebTier = "DOT_NET_WEB_TIER"

	// TierDotNetWeb is a Tier enum value
	TierDotNetWeb = "DOT_NET_WEB"

	// TierSqlServer is a Tier enum value
	TierSqlServer = "SQL_SERVER"

	// TierSqlServerAlwaysonAvailabilityGroup is a Tier enum value
	TierSqlServerAlwaysonAvailabilityGroup = "SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP"

	// TierMysql is a Tier enum value
	TierMysql = "MYSQL"

	// TierPostgresql is a Tier enum value
	TierPostgresql = "POSTGRESQL"

	// TierJavaJmx is a Tier enum value
	TierJavaJmx = "JAVA_JMX"

	// TierOracle is a Tier enum value
	TierOracle = "ORACLE"
)

// Tier_Values returns all elements of the Tier enum
func Tier_Values() []string {
	return []string{
		TierCustom,
		TierDefault,
		TierDotNetCore,
		TierDotNetWorker,
		TierDotNetWebTier,
		TierDotNetWeb,
		TierSqlServer,
		TierSqlServerAlwaysonAvailabilityGroup,
		TierMysql,
		TierPostgresql,
		TierJavaJmx,
		TierOracle,
	}
}
