// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Action required for a broker.
type ActionRequired struct {

	// The code you can use to find instructions on the action required to resolve
	// your broker issue.
	ActionRequiredCode *string

	// Information about the action required to resolve your broker issue.
	ActionRequiredInfo *string

	noSmithyDocumentSerde
}

// Name of the availability zone.
type AvailabilityZone struct {

	// Id for the availability zone.
	Name *string

	noSmithyDocumentSerde
}

// Types of broker engines.
type BrokerEngineType struct {

	// The broker's engine type.
	EngineType EngineType

	// The list of engine versions.
	EngineVersions []EngineVersion

	noSmithyDocumentSerde
}

// Returns information about all brokers.
type BrokerInstance struct {

	// The brokers web console URL.
	ConsoleURL *string

	// The broker's wire-level protocol endpoints.
	Endpoints []string

	// The IP address of the Elastic Network Interface (ENI) attached to the broker.
	// Does not apply to RabbitMQ brokers.
	IpAddress *string

	noSmithyDocumentSerde
}

// Option for host instance type.
type BrokerInstanceOption struct {

	// The list of available az.
	AvailabilityZones []AvailabilityZone

	// The broker's engine type.
	EngineType EngineType

	// The broker's instance type.
	HostInstanceType *string

	// The broker's storage type.
	StorageType BrokerStorageType

	// The list of supported deployment modes.
	SupportedDeploymentModes []DeploymentMode

	// The list of supported engine versions.
	SupportedEngineVersions []string

	noSmithyDocumentSerde
}

// Returns information about all brokers.
type BrokerSummary struct {

	// The broker's deployment mode.
	//
	// This member is required.
	DeploymentMode DeploymentMode

	// The type of broker engine.
	//
	// This member is required.
	EngineType EngineType

	// The broker's Amazon Resource Name (ARN).
	BrokerArn *string

	// The unique ID that Amazon MQ generates for the broker.
	BrokerId *string

	// The broker's name. This value is unique in your Amazon Web Services account,
	// 1-50 characters long, and containing only letters, numbers, dashes, and
	// underscores, and must not contain white spaces, brackets, wildcard characters,
	// or special characters.
	BrokerName *string

	// The broker's status.
	BrokerState BrokerState

	// The time when the broker was created.
	Created *time.Time

	// The broker's instance type.
	HostInstanceType *string

	noSmithyDocumentSerde
}

// Returns information about all configurations.
type Configuration struct {

	// Required. The ARN of the configuration.
	//
	// This member is required.
	Arn *string

	// Optional. The authentication strategy associated with the configuration. The
	// default is SIMPLE.
	//
	// This member is required.
	AuthenticationStrategy AuthenticationStrategy

	// Required. The date and time of the configuration revision.
	//
	// This member is required.
	Created *time.Time

	// Required. The description of the configuration.
	//
	// This member is required.
	Description *string

	// Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and
	// RABBITMQ.
	//
	// This member is required.
	EngineType EngineType

	// Required. The broker engine's version. For a list of supported engine versions,
	// see, Supported engines (https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html)
	// .
	//
	// This member is required.
	EngineVersion *string

	// Required. The unique ID that Amazon MQ generates for the configuration.
	//
	// This member is required.
	Id *string

	// Required. The latest revision of the configuration.
	//
	// This member is required.
	LatestRevision *ConfigurationRevision

	// Required. The name of the configuration. This value can contain only
	// alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~).
	// This value must be 1-150 characters long.
	//
	// This member is required.
	Name *string

	// The list of all tags associated with this configuration.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A list of information about the configuration.
type ConfigurationId struct {

	// Required. The unique ID that Amazon MQ generates for the configuration.
	//
	// This member is required.
	Id *string

	// The revision number of the configuration.
	Revision *int32

	noSmithyDocumentSerde
}

// Returns information about the specified configuration revision.
type ConfigurationRevision struct {

	// Required. The date and time of the configuration revision.
	//
	// This member is required.
	Created *time.Time

	// Required. The revision number of the configuration.
	//
	// This member is required.
	Revision *int32

	// The description of the configuration revision.
	Description *string

	noSmithyDocumentSerde
}

// Broker configuration information
type Configurations struct {

	// The broker's current configuration.
	Current *ConfigurationId

	// The history of configurations applied to the broker.
	History []ConfigurationId

	// The broker's pending configuration.
	Pending *ConfigurationId

	noSmithyDocumentSerde
}

// Specifies a broker in a data replication pair.
type DataReplicationCounterpart struct {

	// Required. The unique broker id generated by Amazon MQ.
	//
	// This member is required.
	BrokerId *string

	// Required. The region of the broker.
	//
	// This member is required.
	Region *string

	noSmithyDocumentSerde
}

// The replication details of the data replication-enabled broker. Only returned
// if dataReplicationMode or pendingDataReplicationMode is set to CRDR.
type DataReplicationMetadataOutput struct {

	// Defines the role of this broker in a data replication pair. When a replica
	// broker is promoted to primary, this role is interchanged.
	//
	// This member is required.
	DataReplicationRole *string

	// Describes the replica/primary broker. Only returned if this broker is currently
	// set as a primary or replica in the broker's dataReplicationRole property.
	DataReplicationCounterpart *DataReplicationCounterpart

	noSmithyDocumentSerde
}

// Encryption options for the broker.
type EncryptionOptions struct {

	// Enables the use of an Amazon Web Services owned CMK using KMS (KMS). Set to
	// true by default, if no value is provided, for example, for RabbitMQ brokers.
	//
	// This member is required.
	UseAwsOwnedKey *bool

	// The customer master key (CMK) to use for the A KMS (KMS). This key is used to
	// encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to
	// encrypt your data.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Id of the engine version.
type EngineVersion struct {

	// Id for the version.
	Name *string

	noSmithyDocumentSerde
}

// Optional. The metadata of the LDAP server used to authenticate and authorize
// connections to the broker. Does not apply to RabbitMQ brokers.
type LdapServerMetadataInput struct {

	// Specifies the location of the LDAP server such as Directory Service for
	// Microsoft Active Directory. Optional failover server.
	//
	// This member is required.
	Hosts []string

	// The distinguished name of the node in the directory information tree (DIT) to
	// search for roles or groups. For example, ou=group, ou=corp, dc=corp, dc=example,
	// dc=com.
	//
	// This member is required.
	RoleBase *string

	// The LDAP search filter used to find roles within the roleBase. The
	// distinguished name of the user matched by userSearchMatching is substituted into
	// the {0} placeholder in the search filter. The client's username is substituted
	// into the {1} placeholder. For example, if you set this option to
	// (member=uid={1})for the user janedoe, the search filter becomes
	// (member=uid=janedoe) after string substitution. It matches all role entries that
	// have a member attribute equal to uid=janedoe under the subtree selected by the
	// roleBase.
	//
	// This member is required.
	RoleSearchMatching *string

	// Service account password. A service account is an account in your LDAP server
	// that has access to initiate a connection. For example, cn=admin,dc=corp,
	// dc=example, dc=com.
	//
	// This member is required.
	ServiceAccountPassword *string

	// Service account username. A service account is an account in your LDAP server
	// that has access to initiate a connection. For example, cn=admin,dc=corp,
	// dc=example, dc=com.
	//
	// This member is required.
	ServiceAccountUsername *string

	// Select a particular subtree of the directory information tree (DIT) to search
	// for user entries. The subtree is specified by a DN, which specifies the base
	// node of the subtree. For example, by setting this option to ou=Users,ou=corp,
	// dc=corp, dc=example, dc=com, the search for user entries is restricted to the
	// subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
	//
	// This member is required.
	UserBase *string

	// The LDAP search filter used to find users within the userBase. The client's
	// username is substituted into the {0} placeholder in the search filter. For
	// example, if this option is set to (uid={0}) and the received username is
	// janedoe, the search filter becomes (uid=janedoe) after string substitution. It
	// will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp,
	// dc=example, dc=com.
	//
	// This member is required.
	UserSearchMatching *string

	// Specifies the LDAP attribute that identifies the group name attribute in the
	// object returned from the group membership query.
	RoleName *string

	// The directory search scope for the role. If set to true, scope is to search the
	// entire subtree.
	RoleSearchSubtree *bool

	// Specifies the name of the LDAP attribute for the user group membership.
	UserRoleName *string

	// The directory search scope for the user. If set to true, scope is to search the
	// entire subtree.
	UserSearchSubtree *bool

	noSmithyDocumentSerde
}

// Optional. The metadata of the LDAP server used to authenticate and authorize
// connections to the broker.
type LdapServerMetadataOutput struct {

	// Specifies the location of the LDAP server such as Directory Service for
	// Microsoft Active Directory. Optional failover server.
	//
	// This member is required.
	Hosts []string

	// The distinguished name of the node in the directory information tree (DIT) to
	// search for roles or groups. For example, ou=group, ou=corp, dc=corp, dc=example,
	// dc=com.
	//
	// This member is required.
	RoleBase *string

	// The LDAP search filter used to find roles within the roleBase. The
	// distinguished name of the user matched by userSearchMatching is substituted into
	// the {0} placeholder in the search filter. The client's username is substituted
	// into the {1} placeholder. For example, if you set this option to
	// (member=uid={1})for the user janedoe, the search filter becomes
	// (member=uid=janedoe) after string substitution. It matches all role entries that
	// have a member attribute equal to uid=janedoe under the subtree selected by the
	// roleBase.
	//
	// This member is required.
	RoleSearchMatching *string

	// Service account username. A service account is an account in your LDAP server
	// that has access to initiate a connection. For example, cn=admin,dc=corp,
	// dc=example, dc=com.
	//
	// This member is required.
	ServiceAccountUsername *string

	// Select a particular subtree of the directory information tree (DIT) to search
	// for user entries. The subtree is specified by a DN, which specifies the base
	// node of the subtree. For example, by setting this option to ou=Users,ou=corp,
	// dc=corp, dc=example, dc=com, the search for user entries is restricted to the
	// subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
	//
	// This member is required.
	UserBase *string

	// The LDAP search filter used to find users within the userBase. The client's
	// username is substituted into the {0} placeholder in the search filter. For
	// example, if this option is set to (uid={0}) and the received username is
	// janedoe, the search filter becomes (uid=janedoe) after string substitution. It
	// will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp,
	// dc=example, dc=com.
	//
	// This member is required.
	UserSearchMatching *string

	// Specifies the LDAP attribute that identifies the group name attribute in the
	// object returned from the group membership query.
	RoleName *string

	// The directory search scope for the role. If set to true, scope is to search the
	// entire subtree.
	RoleSearchSubtree *bool

	// Specifies the name of the LDAP attribute for the user group membership.
	UserRoleName *string

	// The directory search scope for the user. If set to true, scope is to search the
	// entire subtree.
	UserSearchSubtree *bool

	noSmithyDocumentSerde
}

// The list of information about logs to be enabled for the specified broker.
type Logs struct {

	// Enables audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.
	Audit *bool

	// Enables general logging.
	General *bool

	noSmithyDocumentSerde
}

// The list of information about logs currently enabled and pending to be deployed
// for the specified broker.
type LogsSummary struct {

	// Enables general logging.
	//
	// This member is required.
	General *bool

	// The location of the CloudWatch Logs log group where general logs are sent.
	//
	// This member is required.
	GeneralLogGroup *string

	// Enables audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged.
	Audit *bool

	// The location of the CloudWatch Logs log group where audit logs are sent.
	AuditLogGroup *string

	// The list of information about logs pending to be deployed for the specified
	// broker.
	Pending *PendingLogs

	noSmithyDocumentSerde
}

// The list of information about logs to be enabled for the specified broker.
type PendingLogs struct {

	// Enables audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged.
	Audit *bool

	// Enables general logging.
	General *bool

	noSmithyDocumentSerde
}

// Returns information about the configuration element or attribute that was
// sanitized in the configuration.
type SanitizationWarning struct {

	// The reason for which the configuration elements or attributes were sanitized.
	//
	// This member is required.
	Reason SanitizationWarningReason

	// The name of the configuration attribute that has been sanitized.
	AttributeName *string

	// The name of the configuration element that has been sanitized.
	ElementName *string

	noSmithyDocumentSerde
}

// A user associated with the broker. For Amazon MQ for RabbitMQ brokers, one and
// only one administrative user is accepted and created when a broker is first
// provisioned. All subsequent broker users are created by making RabbitMQ API
// calls directly to brokers or via the RabbitMQ web console.
type User struct {

	// Required. The password of the user. This value must be at least 12 characters
	// long, must contain at least 4 unique characters, and must not contain commas,
	// colons, or equal signs (,:=).
	//
	// This member is required.
	Password *string

	// The username of the broker user. The following restrictions apply to broker
	// usernames:
	//   - For Amazon MQ for ActiveMQ brokers, this value can contain only
	//   alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~).
	//   This value must be 2-100 characters long.
	//   - para>For Amazon MQ for RabbitMQ brokers, this value can contain only
	//   alphanumeric characters, dashes, periods, underscores (- . _). This value must
	//   not contain a tilde (~) character. Amazon MQ prohibts using guest as a valid
	//   usename. This value must be 2-100 characters long.
	// Do not add personally identifiable information (PII) or other confidential or
	// sensitive information in broker usernames. Broker usernames are accessible to
	// other Amazon Web Services services, including CloudWatch Logs. Broker usernames
	// are not intended to be used for private or sensitive data.
	//
	// This member is required.
	Username *string

	// Enables access to the ActiveMQ Web Console for the ActiveMQ user. Does not
	// apply to RabbitMQ brokers.
	ConsoleAccess *bool

	// The list of groups (20 maximum) to which the ActiveMQ user belongs. This value
	// can contain only alphanumeric characters, dashes, periods, underscores, and
	// tildes (- . _ ~). This value must be 2-100 characters long. Does not apply to
	// RabbitMQ brokers.
	Groups []string

	// Defines if this user is intended for CRDR replication purposes.
	ReplicationUser *bool

	noSmithyDocumentSerde
}

// Returns information about the status of the changes pending for the ActiveMQ
// user.
type UserPendingChanges struct {

	// Required. The type of change pending for the ActiveMQ user.
	//
	// This member is required.
	PendingChange ChangeType

	// Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
	ConsoleAccess *bool

	// The list of groups (20 maximum) to which the ActiveMQ user belongs. This value
	// can contain only alphanumeric characters, dashes, periods, underscores, and
	// tildes (- . _ ~). This value must be 2-100 characters long.
	Groups []string

	noSmithyDocumentSerde
}

// Returns a list of all broker users. Does not apply to RabbitMQ brokers.
type UserSummary struct {

	// Required. The username of the broker user. This value can contain only
	// alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~).
	// This value must be 2-100 characters long.
	//
	// This member is required.
	Username *string

	// The type of change pending for the broker user.
	PendingChange ChangeType

	noSmithyDocumentSerde
}

// The scheduled time period relative to UTC during which Amazon MQ begins to
// apply pending updates or patches to the broker.
type WeeklyStartTime struct {

	// Required. The day of the week.
	//
	// This member is required.
	DayOfWeek DayOfWeek

	// Required. The time, in 24-hour format.
	//
	// This member is required.
	TimeOfDay *string

	// The time zone, UTC by default, in either the Country/City format, or the UTC
	// offset format.
	TimeZone *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
