#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

int multicast2d(set_of_dest, numdest, msgtag, data, nrows, ncols, offset)
     int *set_of_dest;
     int numdest;
     int msgtag;
     void *data;
     int nrows;
     int ncols;
     int offset;
{
  int i;
  int bufid;
  int inithow = PvmDataDefault;  /* To be implemented later */
  int *tid = (int *)malloc(numdest * sizeof(*tid));

  for (i=0; i<numdest; i++) {
    int dest = set_of_dest[i];
    if (dest == HOSTID) {
      tid[i] = HOSTID;
    }
    else if (dest >= 0 && dest < NUMNODES) {
      tid[i] = NODEID[dest];
    }
    else {
      fprintf(stderr,"multicast(@%d): No such destination %d (C-index=%d)\n",
	      ME,dest,i);
      killproc(ME);
    }
  } /* for i */

#ifdef PICL
  if (logfp) SETIDLETIME();
#endif /* PICL */

  bufid = pvm_initsend(inithow);

  if (ncols == 1) {
    packdata("multicast",data,nrows);
  }
  else {
    int col;
    int oldstrd = setstride(1); /* Otherwise unexpected results */
    char *p = data;

    for (col=0; col<ncols; col++) {
      p += offset * packdata("multicast2d",p,nrows);
    }

    setstride(oldstrd);
  }

  pvm_mcast(tid,numdest,msgtag);

#ifdef PICL
  if (logfp) {
    int nbytes = getdatasize() * ncols * nrows; /* Approximation */
    TRACETIME();
    for (i=0; i<numdest; i++) {
      int dest = set_of_dest[i];
      TRACEF(4,dest==HOSTID ? PICLHOST : dest,msgtag,nbytes);
    }
    UPDATEIDLETIME();
  }
#endif /* PICL */

  free(tid);

  if (ME == HOSTID) check_printfmsg_arrival();

  return bufid;
}

int multicast(set_of_dest, numdest, msgtag, data, ndata)
     int *set_of_dest;
     int numdest;
     int msgtag;
     void *data;
     int ndata;
{
  return multicast2d(set_of_dest,numdest,msgtag,data,ndata,1,ndata);
}
