/* gcolx.h - macro */

#if defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK)

#ifndef MULTIP
#define MULTIP
#endif

static int FUNC(data, nlens, result)
     TYPE *data;
     int *nlens;
     TYPE *result;
{
  int ncnt = 0;
  int ndata;

  if (ME > 0) { /* Nodes with # > 0  */
    pvm_initsend(INITHOW_node);
    ndata = nlens[ME];
    PACK(data, ndata, 1);         /* Send my contribution */
    pvm_send(NODEID[0], MSG_COLX);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(4,0,MSG_COLX,MULTIP sizeof(*data)*ndata);
      TRACEF(7,MSG_COLX);
    }
#endif    

    pvm_recv(NODEID[0], MSG_COLX);
    pvm_upkint(&ncnt,1,1);
    UNPACK(result, ncnt, 1);      /* No array bound checking, thus unsafe, but... */

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(8,0,MSG_COLX,MULTIP sizeof(*data)*ncnt);
    }
#endif

  }
  else { /* Node == 0 */
    int i, j;
    TYPE **start_address = (TYPE **)malloc(NUMNODES * sizeof(TYPE *));

    ndata = nlens[0];

    if (result != data) {
      for (i=0; i<MULTIP ndata; i++) {
	result[i] = data[i];
      }
    }

    start_address[0] = &result[0];
    for (i=1; i<NUMNODES; i++)
      start_address[i] = start_address[i-1] + (MULTIP nlens[i-1]);

    ncnt = ndata;

    for (j=1; j<NUMNODES; j++) {
      int source, bufid;

#ifdef PICL
      if (logfp) {
	TRACETIME();
	TRACEF(7,MSG_COLX);
      }
#endif

      bufid = pvm_recv(ANYBODY, MSG_COLX);    /* Receive in any order  */
      recvinfo(bufid,&source,NULL,NULL);

      ndata = nlens[source];

      UNPACK(start_address[source], 
	     ndata, 1);                   /* Recv #source's contribution */

#ifdef PICL
      if (logfp) {
	TRACETIME();
	TRACEF(8,source,MSG_COLX,MULTIP sizeof(*data)*ndata);
      }
#endif

      ncnt += ndata;
    }

    free(start_address);					  
      
    pvm_initsend(INITHOW_node);
    pvm_pkint(&ncnt,1,1);
    PACK(result, ncnt, 1);
    pvm_mcast(&NODEID[1], NUMNODES-1, MSG_COLX);
  }

  return ncnt;
}


#undef MULTIP
#undef FUNC
#undef TYPE
#undef PACK
#undef UNPACK

#endif  /* defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK) */
