#include "easy.h"
#include "easydefs.h"

int broadcast2d(msgtag, data, nrows, ncols, offset)
     int msgtag;
     void *data; 
     int nrows;
     int ncols;
     int offset;
{
  int bufid;
  int numdest = (ME==HOSTID) ? NUMNODES : NUMNODES-1;

#ifdef PICL
  if (logfp) {
    tracemsg("broadcast()");
    SETIDLETIME();
    TRACEF(20,-2,msgtag,0,picl_me);
  }
#endif /* PICL */

  bufid = pvm_initsend(PvmDataDefault);

  if (ncols == 1) {
    packdata("broadcast",data,nrows);
  }
  else {
    int col;
    int oldstrd = setstride(1); /* Otherwise unexpected results */
    char *p = data;

    for (col=0; col<ncols; col++) {
      p += offset * packdata("broadcast2d",p,nrows);
    }

    setstride(oldstrd);
  }

  pvm_mcast(BCASTNODEID,numdest,msgtag);

#ifdef PICL
  if (logfp) {
    int i; 
    int nbytes = getdatasize() * ncols * nrows; /* Approximation */
    TRACETIME();
    for (i=0; i<NUMNODES; i++) {
      if (i != ME) TRACEF(4,i,msgtag,nbytes);
    } /* Hmm... ParaGraph understands "-1", but still creates potential tachyon */
    TRACEF(21,-2,msgtag,picl_me);
    UPDATEIDLETIME();
  }
#endif /* PICL */

  if (ME == HOSTID) check_printfmsg_arrival();

  return bufid;
}


int broadcast(msgtag, data, ndata)
     int msgtag;
     void *data;
     int ndata;
{
  return broadcast2d(msgtag,data,ndata,1,ndata);
}
