#include "easy.h"
#include <stdlib.h>

#define MATVEC1 matvec1_
#define MATVEC2 matvec2_

#if defined(IMA_CRAY) || defined(IMA_CRAY2)
#undef MATVEC1
#undef MATVEC2
#endif

#if defined(IMA_RS6K) || defined(IMA_HPPA)
#undef MATVEC1
#undef MATVEC2
#define MATVEC1 matvec1
#define MATVEC2 matvec2
#endif

extern void MATVEC1 __ProtoGlarp__((double *MY_A, double *MY_V, 
				    double *V, double *MY_X, double *X,
				    int *ncols, int *M, int *N, int *nproc, double *t));

extern void MATVEC2 __ProtoGlarp__((double *MY_A, double *MY_V, 
				    double *V, double *MY_X, double *X,
				    int *ncols, int *M, int *N, int *nproc, double *t));


void init(x, n)
     double *x;
     int n;
{
  int i;
  for (i=0; i<n; i++) {
    x[i] = (double) rand() / (double) RAND_MAX;
  }
}


#define Usage "usage: matvec method M\n"


main(argc, argv)
     int argc;
     char **argv;
{
  int me;
  int nproc;
  double *MY_A, *MY_X, *MY_V, *X, *V;
  int *ncols;
  int method, N,M;
  double t[2];
  void (*matvec_func) __ProtoGlarp__((double *MY_A, double *MY_V, 
				      double *V, double *MY_X, double *X,
				      int *ncols, int *M, int *N, int *nproc,
				      double *t)) = NULL;

  attachproc();

  me = mynode();
  nproc = numnodes();

  gsingle();

  if (argc != 3) {
    fprintf(stderr,Usage);
    exit(1);
  }

  method = atoi(argv[1]);
  M = atoi(argv[2]);

  if (method != 1 && method != 2) {
    fprintf(stderr,"matvec: Method must be 1 or 2\n");
    exit(1);
  }

  if (M <= 0) {
    fprintf(stderr,"matvec: M must be > 0\n");
    exit(1); 
  }

  gmulti();

  N = M * nproc;

  MY_A = (double *)malloc(M*N*sizeof(double));
  MY_X = (double *)malloc(M*sizeof(double));
  MY_V = (double *)malloc(M*sizeof(double));
  X = (double *)malloc(N*sizeof(double));
  V = (double *)malloc(N*sizeof(double));
  ncols = (int *)malloc(nproc*sizeof(int));

  if (!MY_A || !MY_X || !MY_V || !X || !V || !ncols) {
    fprintf(stderr,"matvec: malloc() failed at node %d\n",me);
    exit(1);
  }

  init(MY_A,M*N);
  init(MY_V,M);
  
  if (method == 1) matvec_func = MATVEC1;
  if (method == 2) matvec_func = MATVEC2;

  matvec_func(MY_A, MY_V,
	      V, MY_X, X,
	      ncols,&M,&N,&nproc,t);

  if (me == 0) {
    printf("matvec: Method#%d, N=%d, nproc=%d, times: %.6lf   %.6lf\n",
	   method,N,nproc,t[0],t[1]);
  }

  exit(0);
}
