#include <stdio.h>

#include "easy.h"

#define DEF_NUMSYNC 10

main(int argc, char *argv[])
{
  int i;
  int iam, nnodes;
  int numsyncs = DEF_NUMSYNC;
  double t1, t2, tdiff;
  double tmin, tmax;
  int wheremin, wheremax;

  iam = mynode();
  nnodes = numnodes();
  if (argc > 1) numsyncs = atoi(argv[1]);
  if (numsyncs <= 0) numsyncs = DEF_NUMSYNC;

  if (iam == 0) {
    printf("Syncronization Performance Test with PVM v%s\n",pvm_version());
    printf("               Number of procs %d,  syncs %d.\n",
	   nnodes,numsyncs);
  }

  gsync();
  gsync();

  t1 = dclock();
  for (i=0; i<numsyncs; i++) gsync();
  t2 = dclock();
  tdiff = (t2 - t1)/numsyncs;

  setdatatype(REAL8);
  gmax(&tdiff,1,&tmax,&wheremax);
  gmin(&tdiff,1,&tmin,&wheremin);
  
  tdiff = tmax - tmin;

  if (iam == 0) { 
    printf("Sync times (%d/%d): max=%.3fms (@%d), min=%.3fms (@%d), diff=%.3fms\n",
	   nnodes,numsyncs,tmax*1000.0,wheremax,
	   tmin*1000.0,wheremin,tdiff*1000.0); 
  }
  
  exit(0);
}
