#! /bin/sh

##
## restore a whois_rip database from a backup
##

GZIP=/usr/local/bin/gzip

DATABASE=RIPE
TARFILE=${DATABASE}.tar.gz
DATADIR=/var/mysql/data
TMPDIR=/export/dbase/tmp

MYSQLUSER=user
MYSQLPASS=password
MYSQL="/usr/local/mysql/bin/mysql -u$MYSQLUSER -p$MYSQLPASS"
MYISAMCHK="/usr/local/mysql/bin/myisamchk --tmpdir=$TMPDIR"

# extract the *.frm and *.MYD files
$GZIP -dc $TARFILE | (cd $DATADIR && tar xf -)

# go to the data directory
cd $DATADIR

# get our table names
TABLES=`(cd ${DATABASE}_snapshot && ls -1 *.MYD) | sed 's/.MYD$//'`

# copy these tables into another database
mkdir ${DATABASE}_repair
for table in $TABLES; do
  cp ${DATABASE}_snapshot/$table.frm ${DATABASE}_repair/$table.frm
  touch ${DATABASE}_repair/$table.MYD
done

# destroy these tables, to give us the indexes
for table in $TABLES; do
  $MYSQL --execute="set autocommit=1; truncate table $table;" ${DATABASE}_repair
done

# copy the new index into our snapshot
for table in $TABLES; do
  cp ${DATABASE}_repair/$table.MYI ${DATABASE}_snapshot/$table.MYI
done

# remove the index repair directory
rm -r ${DATABASE}_repair

# now fix our tables
cd ${DATABASE}_snapshot
$MYISAMCHK -r *.MYI

