//
// $Id: FileSet.hh 1.2 Fri, 15 Oct 1999 15:26:40 -0700 yuri $
//
// FileSet.hh
// Author(s): Ramesh Govindan

#ifndef _FileSet_hh
#define _FileSet_hh

extern "C" {
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/time.h>
}
#include "sys/File.hh"
#include "util/List.hh"

// Classes defined elsewhere
class TimeShort;

// A "select"-able collection of file descriptors forms a
// FileSet. This class basically hides the details of the
// file descriptor set implementation, and the details of the
// select operation.
//

class FileSet : public List<File> {
    
public:
    // Create an empty file set
    FileSet();
    
    // Destroy the file set
    ~FileSet();
    
    // Add a new file to the set
    void
    inset(File* file);
    
    // Remove a file from the set
    void
    outset(File* file);
    
    // Is this file readable?
    Boolean
    issetRead(File* file);
    
    // Is this file writable
    Boolean
    issetWrite(File* file);

    // Wait until one or more descriptors becomes readable
    int
    select(TimeShort&);			// In: time to wait

private:
    fd_set readDescriptors;
    fd_set lastRead;
    fd_set writeDescriptors;
    fd_set lastWrite;
    int fdWidth;
};

// 
//  Copyright (c) 1994 by the University of Southern California.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California and/or Information Sciences Institute.
//  The name of the University of Southern California may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY REPRESENTATIONS
//  ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Ramesh Govindan <govindan@isi.edu>

#endif // _FileSet_hh
