/***********************************************************
        Copyright 1991 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _COLLECTION_STRUCT_H
#define _COLLECTION_STRUCT_H

static char CollectionStruct_rcs_idH[]= "$Header: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/CollectionStruct.h,v 4.2 1992/02/12 18:05:04 ww0r Exp $";


/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#ifdef USE_FSINFO
typedef struct collectionfsinfo
{
  char		*path;		/* path to mountpoint */
  long		fs_id;		/* volume no. */
  u_long	fs_modtime;	/* volume mod time */
} COLLECTIONFSINFO;
#endif USE_FSINFO

typedef struct collection
{
  char		*name;	/* name of the collection */
  char		*path;	/* location of the collection in the file system */
  DEPOTDB	*info;	/* db tree containing info on files in collection */
#ifdef USE_FSINFO
  COLLECTIONFSINFO	**fslist;	/* NULL-terminated array of file system mount points */
  COLLECTIONFSINFO	*confinfo;
#endif USE_FSINFO
} COLLECTION;

typedef struct collectionlist
{
  struct collectionlist	*next;
  COLLECTION		collection;	/* item in collectionlist */
} COLLECTIONLIST;

#define COLLECTION_next(x) ((x)->next)

/*
 * $Log: CollectionStruct.h,v $
 * Revision 4.2  1992/02/12  18:05:04  ww0r
 * make RCS headers visibile
 * added protection against double includes
 *
 * Revision 4.1  1991/10/08  21:48:33  dl2n
 * add CMU copyright
 *
 * Revision 4.0  1991/09/25  17:36:21  sohan
 * Release 4
 *
 * Revision 4.0  1991/09/25  16:08:52  sohan
 * Version 4.0
 *
 */
#endif /* _COLLECTION_STRUCT_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/CollectionStruct.h,v $ */
