/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia/Australian Wool Corporation 
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		vtest.c - Interactive program to test image processing 
*			functions.
* REVISION:             3.2
* AUTHOR:               PK
* CREATION DATE:        Sept 1991
* REVISION DATE:	3/24/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.2
* REVISION DATE:	24 March 1994
* COMMENT:		Fixed up for DEC build
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)vtest.c	3.2 3/24/94";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vip.h"
#include "misc.h"
#ifndef DEC_ALPHA
#include <floatingpoint.h>
#endif

main()
{

    char    line[80], *param[10];
    int     nparam;
    IMAGE  *image1 = NULL, *image2 = NULL, *image3 = NULL;
    INT_MASK *mask = NULL;

BEGIN:

    (void) printf("vtest> ");
    getline(line, 80);
    if (strlen(line) == 0 || strncmp(line, "\n", 1) == 0)
	goto BEGIN;

    param[0] = strtok(line, " ,");	/* get all the parameters entered */
    nparam = 0;
    while (param[nparam] != NULL) {
	nparam++;
	param[nparam] = strtok(( char * ) NULL, " ,");
    }

    /* exit */

    if (strncasecmp(param[0], "ex", 2) == 0)
	return;

    /* threshold */

    else if (strncasecmp(param[0], "thresh", 6) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    image2 = ( IMAGE * ) Thresh_Image(image1, atoi(param[2]));
	    if (!image2)
		goto BEGIN;
	    Write_Image(image2, param[3]);
            Free_Image(image1);
            Free_Image(image2);
	}
	else
	    (void) printf("Thresh: in_image threshold out_image\n");
    }
    /* convolve */

    else if (strncasecmp(param[0], "convolve", 8) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    mask = ( INT_MASK * ) Read_Int_Mask(param[2]);
	    image2 = ( IMAGE * ) Convolve_Image(image1, mask);
	    if (!image2)
		goto BEGIN;
	    Write_Image(image2, param[3]);
	}
	else
	    (void) printf("convolve: in_image mask_file out_image\n");
    }
    /* erode */

    else if (strncasecmp(param[0], "erode", 5) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    mask = ( INT_MASK * ) Read_Int_Mask(param[2]);
	    image2 = ( IMAGE * ) Erode_Image(image1, mask);
	    if (!image2)
		goto BEGIN;
	    Write_Image(image2, param[3]);
            Free_Image(image1);
    	    Free_Image(image2);
	}
	else
	    (void) printf("erode: in_image masmk_file out_image\n");
    }
    /* dilate */

    else if (strncasecmp(param[0], "dilate", 7) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    mask = ( INT_MASK * ) Read_Int_Mask(param[2]);
	    if (!mask)
		goto BEGIN;
	    image2 = ( IMAGE * ) Dilate_Image(image1, mask);
	    if (!image2)
		goto BEGIN;
	    Write_Image(image2, param[3]);
	}
	else
	    (void) printf("dilate: in_image mask_file out_image\n");
    }
    /* deresolve */

    else if (strncasecmp(param[0], "deres", 5) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    image2 = ( IMAGE * ) DeRes_Image(image1, atoi(param[2]));
	    if (!image2)
		goto BEGIN;
	    Write_Image(image2, param[3]);
	}
	else
	    (void) printf("deres: in_image deresolution_factor\n");
    }
    /* subtract */

    else if (strncasecmp(param[0], "subtract", 8) == 0) {
	if (nparam == 6) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    image2 = ( IMAGE * ) Read_Image(param[2]);
	    if (!image2)
		goto BEGIN;
	    image3 = ( IMAGE * ) Subtract_Image(image1, image2, atoi(param[3]), atoi(param[4]));
	    if (!image3)
		goto BEGIN;
	    Write_Image(image3, param[5]);
	}
	else
	    (void) printf("subtract: in_image1 in_image2 offset gain out_image\n");
    }
    /* difference */

    else if (strncasecmp(param[0], "difference", 8) == 0) {
	if (nparam == 5) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    image2 = ( IMAGE * ) Read_Image(param[2]);
	    if (!image2)
		goto BEGIN;
	    image3 = ( IMAGE * ) Diff_Image(image1, image2, atoi(param[3]));
	    if (!image3)
		goto BEGIN;
	    Write_Image(image3, param[4]);
	}
	else
	    (void) printf("difference: in_image1 in_image2 gain out_image\n");
    }
    /* closopen */

    else if (strncasecmp(param[0], "closopen", 8) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    mask = ( INT_MASK * ) Read_Int_Mask(param[2]);
	    if (!mask)
		goto BEGIN;
	    image2 = ( IMAGE * ) Dilate_Image(image1, mask);
	    if (!image2)
		goto BEGIN;
	    image3 = ( IMAGE * ) Erode_Image(image2, mask);
	    if (!image3)
		goto BEGIN;
	    Write_Image(image3, param[3]);
	}
	else
	    (void) printf("closopen: in_image mask_file out_image\n");
    }
    /* comoc */

    else if (strncasecmp(param[0], "comoc", 5) == 0) {
	if (nparam == 4) {
	    (void) printf("please wait !...\n");
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    mask = ( INT_MASK * ) Read_Int_Mask(param[2]);
	    if (!mask)
		goto BEGIN;
	    image2 = ( IMAGE * ) Dilate_Image(image1, mask);
	    if (!image2)
		goto BEGIN;
	    image3 = ( IMAGE * ) Erode_Image(image2, mask);
	    if (!image3)
		goto BEGIN;

	    Free_Image(image2);
	    image2 = ( IMAGE * ) Erode_Image(image1, mask);
	    if (!image2)
		goto BEGIN;
	    Free_Image(image1);
	    image1 = ( IMAGE * ) Dilate_Image(image2, mask);
	    if (!image1)
		goto BEGIN;
	    Free_Image(image2);
	    image2 = ( IMAGE * ) Average_Image(image1, image3);
	    if (!image2)
		goto BEGIN;

	    Write_Image(image2, param[3]);
	}
	else
	    (void) printf("comoc: in_image mask_file out_image\n");
    }

    else if (strncasecmp(param[0], "scale", 5) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    image2 = ( IMAGE * ) Scale_Image(image1, (float) atof(param[2]));
	    if (!image2)
		goto BEGIN;
	    Write_Image(image2, param[3]);
	}
	else
	    (void) printf("scale: in_image scale_factor out_image\n");
    }

    else if (strncasecmp(param[0], "offset", 6) == 0) {
	if (nparam == 4) {
	    image1 = ( IMAGE * ) Read_Image(param[1]);
	    if (!image1)
		goto BEGIN;
	    image2 = ( IMAGE * ) Offset_Image(image1, (float) atof(param[2]));
	    if (!image2)
		goto BEGIN;
	    Write_Image(image2, param[3]);
	}
	else
	    (void) printf("offset: in_image scale_factor out_image\n");
    }

    /* help */

    else {
	(void) printf("Commands available:\n");
	(void) printf("ex                                      - exit\n");
	(void) printf("thresh in_image threshold out_image     - threshold an image\n");
	(void) printf("colvolve in_image mask_file out_image   - colvolve an image\n");
	(void) printf("erode in_image mask_file out_image      - erode an image\n");
	(void) printf("dilate in_image mask_file out_image     - dilate an image\n");
	(void) printf("deres in_image deresolution_factor out_image       - de-resolve an image\n");
	(void) printf("subtract in_image1 in_image2 offset gain out_image - subtract two images\n");
	(void) printf("difference in_image1 in_image2 gain out_image      - absolute difference in two images\n");
	(void) printf("closopen in_image mask_file out_image   - close-open morphological smoothing\n");
	(void) printf("comoc in_image mask_file out_image   - comoc morphological smoothing\n");
    }

/*
    Free_Image(image1);
    Free_Image(image2);
    Free_Image(image3);
*/

    if (mask) {
        Free_Int_Mask(mask);
    }
    goto BEGIN;

}
