/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		vip2raster - Map a VIP image to raster image (whose 
*				     format is consistent with those created by
*				     'touchup').  
* REVISION:             3.1
* AUTHOR:		DH               
* CREATION DATE:        29 Nov 1988
* REVISION DATE:	7/17/92
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	16 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	14 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)vip2raster.c	3.1 7/17/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vip.h"
#include "misc.h"
#include "rast.h"


/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: vip2raster [vip_image_file] [-o raster_image_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "vip2raster: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(in_arg))) {
	VIP_Error_Msg("Error return from Read_Image");
	exit(1);
    }

    VIP_To_Raster_File(im, out_arg);

    exit(0);
}
