/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		scale.c - Pixel-wisely multiply an image by a
*				  scaling factor.
* REVISION:             3.1
* AUTHOR:               CA/DH
* CREATION DATE:        04 Aug 1987
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	20 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)scale.c	3.1 7/10/92";
#endif



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"


/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: scale [filename] [-s scale] [-o out_file]\n");
    (void) fprintf(stderr, "default: scale <stdin> -s 1 -o <stdout>\n");
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *file_arg = NULL;
    char   *scale_arg = NULL;
    IMAGE  *im, *outim;
    double  scale = 1;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 's':
		if (++argn < argc)
		    scale = atof(argv[argn]);
		else
		    Usage();
		break;
	    case 'o':
		if (++argn < argc)
		    scale_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!file_arg)
	    file_arg = argv[argn];
	else
	    Usage();


    if (!(im = ( IMAGE * ) Read_Image(file_arg))) {
	VIP_Error_Msg("Error return from Read_Image");
	exit(1);
    }

    if (outim = ( IMAGE * ) Scale_Image(im, scale))
	Write_Image(outim, scale_arg);
    else {
	VIP_Error_Msg("Scale_Image returns NULL");
	exit(1);
    }

    exit(0);
}
