/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		res.c -	Increase/decrease resolution of an image.
* REVISION:             3.1
* AUTHOR:               CA/DH
* CREATION DATE:        01 Dec 1986
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	11 Dec 1991
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)res.c	3.1 7/10/92";
#endif



#include <stdio.h>
#include <stdlib.h>
#include "vip.h"


/*- Usage -----------------------------------------------------------

Print message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: res [filename] [-r res | -d deres] [-a] [-o out_file]\n");
    (void) fprintf(stderr, "       -r factor to increase image resolution,\n");
    (void) fprintf(stderr, "       -d factor to decrease image resolution,\n");
    (void) fprintf(stderr, "       -a apply Gaussian smoothing (relevant only if -r is used),\n");
    (void) fprintf(stderr, "Note that -d and -r should be both be used.\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "res: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn, average = 0;
    char   *infile = NULL;
    char   *outfile = NULL;
    IMAGE  *im, *dim;
    int     resolve = -1, deresolve = -1;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'a':
		average = 1;
		break;
	    case 'r':
		if (++argn < argc)
		    resolve = atoi(argv[argn]);
		else
		    Usage();
		break;
	    case 'd':
		if (++argn < argc)
		    deresolve = atoi(argv[argn]);
		else
		    Usage();
		break;
	    case 'o':
		outfile = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!infile)
	    infile = argv[argn];
	else
	    Usage();

    if (resolve > 0 && deresolve > 0)
	Pperror("Only one of the -d and -r flags can be used");
    else if (resolve < 0 && deresolve < 0)
	/* default is to increase image resolution */
	resolve = 2;

    /* Read in image */
    if (!(im = ( IMAGE * ) Read_Image(infile)))
	exit(1);
    if (resolve > 0)
	dim = ( IMAGE * ) Res_Image(im, resolve, average);
    else			/* deresolve must be > 0 */
	dim = ( IMAGE * ) DeRes_Image(im, deresolve);

    if (dim != NULL)
	Write_Image(dim, outfile);

    exit(0);
}
