/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM:               VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		pm2vip.c - Convert a portable image map, such as 
*			 	   ppm, pgm or pbm to a mono V.I.P. image.
* REVISION:             3.1
* AUTHOR:               CFF
* CREATION DATE:        05 August 1992
* REVISION DATE:	8/5/92
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* CREATION DATE:        05 August 1992
* COMMENT:		A new utility.
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)pm2vip.c	3.1 8/5/92";
#endif

#include <stdio.h>
#include <stdlib.h>
#include "vip.h"
#include "misc.h"
#include "pm.h"

void		Usage();
void		Pperror( char * );

/*- Usage -----------------------------------------------------------

Print 'usage' message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: pm2vip [ppm, pgm or pbm image_file] [-o vip_image_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "pm2vip: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn, a, b, c, i;
    char   *image_arg = NULL, *out_arg = NULL, temp1[10];
    IMAGE  *im;
    PPM	   *ppm;
    FILE   *outfile;

    for (argn = 1; argn < argc; argn++) {
	if (argv[argn][0] == '-') {
	    switch (argv[argn][1]) {
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
        }
	else if (!image_arg) {
	    image_arg = argv[argn];
	}
	else {
	    Usage();
	}
    }

    if (ppm = ( PPM *) Read_PPM_Image(image_arg)) {
        if (im = ( IMAGE * ) PPM_To_VIP(ppm)) {

            if (Not_An_Image(im)) {
                VIP_Error_Msg("Write_Image: Attempt to write a non-IMAGE structure");
                return (ERROR);
            }
            if (out_arg) {
                outfile = fopen(out_arg, "wb");
                    if (outfile == NULL) {
                        VIP_Error_Msg("Write_Image could not open file");
                        return (ERROR);
                    }
            }
            else {
                outfile = stdout;
	    }

    /* Write the header, but not the pointer to the image data */

	    Write_Image(im, out_arg);

            return (OK);

       }
    }

    exit(0);
}
