/**pgm2vip.c    Version 2.0********************************************
 *      Copyright (c) 1991
 *      University Of Western Australia
 *      Date Created    :       22 June 1992
 *      Author          :       Rajiv  Ellepola
 *      Description     :       Convert a PGM image to an image of the
 *				V.I.P format.
 *
 *      Modification    :	26 June 1992  Rajiv  to handle rawbit
 *				option in PGM format.
 *
 **********************************************************************/


#include <stdio.h>
#include <misc.h>
#include <string.h>
#include <stdlib.h>
#include "vip.h"

int     PGM2VIP_Image();


/*- Usage -----------------------------------------------------------

Print 'usage' message and exit program.

--------------------------------------------------------------------*/

Usage()
{
    fprintf(stderr, "usage: pgm2vip  [pgm_image_file]  [vip_image_file]\n");
    exit(1);
}




/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{

    if (argc < 3) {
	Usage();
    }

    PGM2VIP_Image(argv[1], argv[2]);

}




/*-  PGM2VIP_Image  --------------------------------------------------

Converts a PGM image to a V.I.P image.  The output VIP image will be
stored to "outfile".
The function returns ERROR if any error is encountered
in the function body and returns OK otherwise.

--------------------------------------------------------------------*/

int     PGM2VIP_Image(inputfile, outputfile)
char   *inputfile;
char  *outputfile;
{
    FILE   *fp;
    int     row = 0, col = 0;	/* no. of rows and cols   */
    int     grey_scale = 0;	/* max. grey value 	  */
    float   grey;		/* current grey value	  */
    int     value;		/* magic number value     */
    char    buf[1];		/* current character read */
    char   *temp, c;		/* - do -		  */
    int     i, j;		/* loop counters 	  */
    IMAGE  *outimage;		/* output file IMAGE TYPE */
    char    line[80], *param[10];
    int     nparam;
    int     p[10];
    char    *token, *magic;


    if ((fp = fopen(inputfile, "r")) == NULL) {
	VIP_Error_Msg("read_input: fail to open input file");
	return (NULL);
    }


    nparam = 0;

    fgets(line, 80, fp);
    token = strtok(line, " \t\n\f");	/* get all the parameters
						 * entered */
    magic = strdup(token);

GETLINE:
    fgets(line, 80, fp);
    token = strtok(line, " \t\n\f");	/* get all the parameters
						 * entered */

    if (token[0] == '#')
	goto GETLINE;
    else {
        p[nparam] = atoi(token);
        nparam++;
      }

    while ((token = strtok(NULL, " \t\n\f")) != NULL) {
        p[nparam] = atoi(token);
	nparam++;
    }
    if (nparam < 3)
	goto GETLINE;


    col = p[0];
    row = p[1];
    grey_scale = p[2];


    printf("magic %s row %d col %d \n", magic, row, col);

    if (strncmp(magic, "P2", 2) == 0) {	/* input file in ASCII format */

	/* allocate an image for writing to */
	outimage = Allocate_Image(0, 0, row, col, BYTETYPE);

	if (!outimage) {
	    VIP_Error_Msg("PGM_2_VIP: out of memory in allocating outputimage");
	    fclose(fp);
	    return (NULL);
	}


	for (i = 0; i < row; i++) {
	    for (j = 0; j < col; j++) {
		grey = 0.0;	/* initialise grey value */
		fscanf(fp, "%c", buf);
		while ((*buf == '\n') || (*buf == ' ')) {
		    fscanf(fp, "%c", buf);
		}
		while ((*buf >= '0') && (*buf <= '9')) {
		    grey = (float) atoi(buf) + (grey * 10.0);
		    fscanf(fp, "%c", buf);
		}

		grey *= (255 / grey_scale);	/* range of scale 0-255  */
		/* store the value as a CHARTYPE image in VIP format */
		outimage->i.c[i][j] = (int) grey;

	    }
	}
    }

    else if (strncmp(magic, "P5", 2) == 0) {	/* input file in RAW bit
						 * format */

	/* allocate an image for writing to */
	outimage = Allocate_Image(0, 0, row, col, BYTETYPE);

	if (!outimage) {
	    VIP_Error_Msg("PGM_2_VIP: out of memory in allocating outputimage");
	    fclose(fp);
	    return (NULL);
	}


	for (i = 0; i < outimage->rows; i++)
	    fread((char *) (outimage->i.c[i]), sizeof(unsigned char),
		outimage->cols, fp);


    }


    else {			/* not in recognised type of portable grey
				 * map format */
	VIP_Error_Msg("PGM_2_VIP: input file not in PGM format.");
	fclose(fp);
	return (NULL);
    }

    fclose(fp);
    Write_Image(outimage, outputfile);
    Free_Image(outimage);
    return (OK);
}

/*------------------------------------------------------------------------*/
