/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		negim.c - Negate an image.
* REVISION:             3.1
* AUTHOR:               CA/DH
* CREATION DATE:        01 Dec 1986
* REVISION DATE:	3/16/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	16 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	07 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)negim.c	3.1 3/16/94";
#endif


#include <stdio.h>
#include <stdlib.h>
#include "vip.h"



/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: negim [in_file] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "negim: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *input_arg = NULL;
    char   *neg_arg = NULL;
    IMAGE  *im;
    register int r, c, i;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		neg_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!input_arg)
	    input_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(input_arg)))
	Pperror("vision system error in read_image");

    switch (im->type) {
    case BYTETYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		im->i.c[r][c] = ~im->i.c[r][c];
	break;
    case SHORTTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		im->i.s[r][c] = -im->i.s[r][c];
	break;
    case LONGTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		im->i.l[r][c] = -im->i.l[r][c];
	break;
    case FLOATTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		im->i.f[r][c] = -im->i.f[r][c];
	break;
    case DOUBLETYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		im->i.d[r][c] = -im->i.d[r][c];
	break;
    case COMPLEXTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--) {
		im->i.cx[r][c].r = -im->i.cx[r][c].r;
		im->i.cx[r][c].i = -im->i.cx[r][c].i;
	    }
	break;
    case RGBTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		for (i = 2; i >= 0; i--)
		    im->i.rgb[r][c][i] = ~im->i.rgb[r][c][i];
	break;
    case HSITYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		for (i = 2; i >= 0; i--)
		    im->i.hsi[r][c][i] = ~im->i.hsi[r][c][i];
	break;
    default:
	Pperror("Invalid image type");
    }

    Write_Image(im, neg_arg);
    exit(0);
}
