/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		lapgaussian.c - Produces a Laplacian of Gaussian mask
* REVISION:             3.1
* AUTHOR:               CA/DH
* CREATION DATE:        01 Jul 1986
* REVISION DATE:	3/14/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	17 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)lapgaussian.c	3.1 3/14/94";
#endif



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: lapgaussian omega [-m] [-o out_file]\n");
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *mask_arg = NULL;
    int     two_dim_arg = 0;
    int     omega_arg = 0;
    IMAGE  *f;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'm':
		two_dim_arg = argn;
		break;
	    case 'o':
		mask_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!omega_arg)
	    omega_arg = atoi(argv[argn]);
	else
	    Usage();


    if (!omega_arg)
	Usage();

    if (two_dim_arg)
	f = ( IMAGE * ) Laplacian_Gaussian_2D(omega_arg);
    else
	f = ( IMAGE * ) Laplacian_Gaussian_1D(omega_arg);
    if (!f) {
	VIP_Error_Msg("vision system error in lapgaussian");
	exit(1);
    }

    if (!Write_Image(f, mask_arg))
	VIP_Error_Msg("Image saving process failed.");

    exit(0);
}
