/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		imageinfo.c - Returns information on an image
* REVISION:             3.1
* AUTHOR:               PK 
* CREATION DATE:        October 1993        
* REVISION DATE:	3/3/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	03 Mar 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* "@(#)imageinfo.c	3.1 3/3/94"
*
*******************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include "vip.h"
#include "vipiofn.h"
#include "vipspatfn.h"

int     main(int argc, char *argv[])
{
    IMAGE  *image;
    double  mn1, mn2, mn3, mx1, mx2, mx3;
    double  mean, StdDev;

    if (argc != 2) {
	printf("usage: imageinfo imagename\n");
	return (0);
    }

    image = Read_Image(argv[1]);
    if(!image) return(0);

    Image_Min_Max(image, &mn1, &mx1, &mn2, &mx2, &mn3, &mx3);
    Image_Mean_StdDev(image,&mean,&StdDev);    
    printf("\n");
    printf("\n");
    printf("------------------- VIP Image Data --------------------\n");
    printf("\n");
    printf("Image Name : %s      ", argv[1]);
    
    if (image->type == 1) {
        (void) printf ("Image Type : BYTETYPE \n");
    }

    if (image->type == 2) {
        (void) printf ("Image Type : SHORTTYPE \n");
    }

    if (image->type == 3) {
        (void) printf ("Image Type : LONGTYPE \n");
    }

    if (image->type == 4) {
        (void) printf ("Image Type : FLOATTYPE \n");
    }

    if (image->type == 5) {
        (void) printf ("Image Type : DOUBLETYPE \n");
    }

    if (image->type == 6) {
        (void) printf ("Image Type : COMPLEXTYPE \n");
    }

    if (image->type == 7) {
        (void) printf ("Image Type : RGBTYPE \n");
    }

    if (image->type == 8) {
        (void) printf ("Image Type : HSITYPE \n");
    }

    printf("No. of rows = %d    No. of cols = %d \n",image->rows, image->cols);
    printf("Image min, = %f    max = %f \n", mn1, mx1);
    printf("Image mean = %f    Standard Deviation = %f\n",mean,StdDev);

    Free_Image(image);
    return (0);
}

