/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		genimage.c - Create a VIP image by reading content
*				     of the image (in text format) from disk
*				     or the standard input stream.
* REVISION:             3.1
* AUTHOR:		DH               
* CREATION DATE:        4 Sep 1989
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	29 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)genimage.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );
static          IMAGE *Read_Input( FILE * );




/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: genimage [input_file] [-o output_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(s)
char   *s;
{
    (void) fprintf(stderr, "genimage: %s.\n", s);
    exit(1);
}


/*- Read_Input ------------------------------------------------------

Read content of the image from stdin or disk.

--------------------------------------------------------------------*/

static IMAGE *Read_Input(fp)
FILE   *fp;
{
    static char *type[9] = {
	"NULLTYPE", "BYTETYPE", "SHORTTYPE", "LONGTYPE", "FLOATTYPE",
	"DOUBLETYPE", "COMPLEXTYPE", "RGBTYPE", "HSITYPE"
    };
    register int i, j, k;
    char    str[81], buf[256];
    IMAGE  *im = NULL;
    int     indx, d, nr, nc;
    long    ld;
    float   f, ff;
    double  db;

    (void) fgets(str, 80, fp);
    if (strlen(str) < 80 && str[strlen(str) - 1] == '\n')
	str[strlen(str) - 1] = '\0';

    for (indx = 1; indx <= 8; indx++)
	if (!strcmp(str, type[indx]))
	    break;
    if (indx <= 8) {
	/* a valid image type has been read */
	if (fscanf(fp, "%d%d", &nr, &nc) != 2) {
	    VIP_Error_Msg("Read_Input: short read");
	    return (NULL);
	}
	else if (!(im = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, indx))) {
	    VIP_Error_Msg("Read_Input: out of memory");
	    return (NULL);
	}
	switch (im->type) {
	case BYTETYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++) {
		    if (fscanf(fp, "%d", &d) != 1) {
			VIP_Error_Msg("Read_Input: short read");
			Free_Image(im);
			return (NULL);
		    }
		    im->i.c[i][j] = (unsigned char) d;
		}
	    break;
	case SHORTTYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++) {
		    if (fscanf(fp, "%d", &d) != 1) {
			VIP_Error_Msg("Read_Input: short read");
			Free_Image(im);
			return (NULL);
		    }
		    im->i.s[i][j] = (short) d;
		}
	    break;
	case LONGTYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++) {
		    if (fscanf(fp, "%ld", &ld) != 1) {
			VIP_Error_Msg("Read_Input: short read");
			Free_Image(im);
			return (NULL);
		    }
		    im->i.l[i][j] = (long) ld;
		}
	    break;
	case FLOATTYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++) {
		    if (fscanf(fp, "%f", &f) != 1) {
			VIP_Error_Msg("Read_Input: short read");
			Free_Image(im);
			return (NULL);
		    }
		    im->i.f[i][j] = (float) f;
		}
	    break;
	case DOUBLETYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++) {
		    if (fscanf(fp, "%lf", &db) != 1) {
			VIP_Error_Msg("Read_Input: short read");
			Free_Image(im);
			return (NULL);
		    }
		    im->i.d[i][j] = (double) db;
		}
	    break;
	case COMPLEXTYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++) {
		    if (fscanf(fp, "%f%f", &f, &ff) != 2) {
			VIP_Error_Msg("Read_Input: short read");
			Free_Image(im);
			return (NULL);
		    }
		    im->i.cx[i][j].r = (float) f;
		    im->i.cx[i][j].i = (float) f;
		}
	    break;
	case RGBTYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++)
		    for (k = 0; k < 3; k++) {
			if (fscanf(fp, "%d", &d) != 1) {
			    VIP_Error_Msg("Read_Input: short read");
			    Free_Image(im);
			    return (NULL);
			}
			im->i.rgb[i][j][k] = (unsigned char) d;
		    }
	    break;
	case HSITYPE:
	    for (i = 0; i < nr; i++)
		for (j = 0; j < nc; j++)
		    for (k = 0; k < 3; k++) {
			if (fscanf(fp, "%d", &d) != 1) {
			    VIP_Error_Msg("Read_Input: short read");
			    Free_Image(im);
			    return (NULL);
			}
			im->i.hsi[i][j][k] = (unsigned char) d;
		    }
	    break;
	default:
	    VIP_Error_Msg("Read_Input: invalid image type");
	    Free_Image(im);
	    return (NULL);
	}
	return (im);
    }
    else {
	(void) sprintf(buf, "Read_Input: image type read is %s.", str);
	VIP_Error_Msg(buf);
	VIP_Error_Msg("           valid image types are:");
	VIP_Error_Msg("             BYTETYPE, SHORTTYPE, LONGTYPE, FLOATTYPE,");
	VIP_Error_Msg("             DOUBLETYPE, COMPLEXTYPE, RGBTYPE, HSITYPE.");
	return (NULL);
    }
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char  **argv;

{
    int     arg;
    char   *in_arg = NULL, *out_arg = NULL;
    FILE   *fp = stdin;
    IMAGE  *im;

    for (arg = 1; arg < argc; arg++)
	if (argv[arg][0] == '-')
	    switch (argv[arg][1]) {
	    case 'o':
		if (++arg < argc)
		    out_arg = argv[arg];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[arg];
	else
	    Usage();

    if (in_arg) {
	if ((fp = fopen(in_arg, "r")) == NULL)
	    Pperror("Fail to open input file");
    }

    if ((im = ( IMAGE * ) Read_Input(fp)))
	Write_Image(im, out_arg);

    exit(0);
}
