/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		fft.c - Fast Fourier Transform of a complex image.
*                                (imported from an older version of V.I.P.
*				  written by Du in September 1988.)
* REVISION:             3.2
* AUTHOR:		DH
* CREATION DATE:        14 March 1994
* REVISION DATE:	3/15/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	14 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	15 March 1994
* COMMENT:		Fixed call to PadImage
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)fft.c	3.2 3/15/94";

#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <memory.h>
#include "vip.h"


void    Usage();

/*- Usage -----------------------------------------------------------

Print usage message and exit program.

--------------------------------------------------------------------*/

void    Usage()
{
    (void) fprintf(stderr, "Usage: fft [-s] [complex_image_file] [-o output_complex_file]\n");
    (void) fprintf(stderr, "       -s origin shift (default=no shift)\n");
    exit(1);
}



/*- Main Program ----------------------------------------------------

Output the Fast Fourier Transform of a given image.  When the -s
flag is used, the image origin is shifted to the center of the image.
If an input filename is not given on the command line, standard input
is assumed and if no output filename is given, standard output is
assumed.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];

{
    int     argn, sh = 0;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im = NULL, *outim = NULL;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    out_arg = argv[argn];
		else
		    Usage();
		break;
	    case 's':
		sh = 1;
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();


    if (!(im = (IMAGE *) Read_Image(in_arg)))
	exit(1);

    if (!(outim = (IMAGE *) FT_Image(im, sh,"forward")))
	exit(1);

    Write_Image(outim, out_arg);

    Free_Image(im);

    exit(0);
}


/*-------------------------------------------------------------------------*/
