/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		eqnim.c - Produce an image whose pixel values are
*				  determined by an equation stored in
 *				  a file or typed from keyboard.
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        30 Jan 1992
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	03 Feb 1992
* COMMENT:
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)eqnim.c	3.1 7/10/92";
#endif



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>
#include <sys/types.h>
#include "vip.h"


void            Usage();
void            Pperror( char * );
static          Start_Child_Process();
/*
static IMAGE    *Read_Equation( struct _iobuf * );
*/
static IMAGE    *Read_Equation( FILE * );
static          Pipe_Writer( char * );
static          Pipe_Reader( char * );


static FILE *fp_tochild, *fp_fromchild;
static int childpid;
static int tochild, fromchild;


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: eqnim [equation_file] [-o output_file]\n");
    (void) fprintf(stderr, "default: eqnim <stdin> <stdout>\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "eqnim: %s\n", e);
    exit(1);
}


/*- Start_Child_Process ---------------------------------------------

Read equation from stdin or a file and output an image whose pixel
values are determined by the equation supplied by the user.

--------------------------------------------------------------------*/

static Start_Child_Process()
{
    int     i, nums;
    int     pipeto[2], pipefrom[2];

    if (pipe(pipeto) < 0 || pipe(pipefrom) < 0)
	Pperror("error returned from 'pipe'\n");

    switch (childpid = fork()) {
    case -1:
	Pperror("Fail to create child process.");
    case 0:
	dup2(pipeto[0], 0);
	dup2(pipefrom[1], 1);
	nums = getdtablesize();
	for (i = 3; i < nums; i++)
	    close(i);
	execl("/usr/bin/bc", "bc", "-l", 0);
	exit(1);
    default:
	close(pipeto[0]);
	close(pipefrom[1]);
	tochild = pipeto[1];
	fp_tochild = fdopen(tochild, "w");
	fromchild = pipefrom[0];
	fp_fromchild = fdopen(fromchild, "r");
	setbuf(fp_tochild, ( char * ) NULL);
	break;
    }
}


/*- Read_Equation ---------------------------------------------------

Read equation from stdin or a file and output an image whose pixel
values are determined by the equation supplied by the user.

--------------------------------------------------------------------*/

static IMAGE *Read_Equation(fp)
FILE   *fp;
{
    register int i, r, c;
    int     nr, nc, constant, vali;
    long    vall;
    double  valf;
    char    buf[512], result[512];
    static char *ImType[9] = {
	"NULL", "BYTETYPE", "SHORTTYPE", "LONGTYPE", "FLOATTYPE",
	"DOUBLETYPE", "COMPLEXTYPE", "RGBTYPE", "HSITYPE"
    };
    IMAGE  *im;

    fd_set  readmask;
    struct timeval timeout;

    if (fgets(buf, 512, fp) == NULL) {
	/* read the image type */
	VIP_Error_Msg("Read_Equation: short read.");
	return (NULL);
    }
    if (strlen(buf) < 512 && buf[strlen(buf) - 1] == '\n')
	buf[strlen(buf) - 1] = '\0';

    for (i = 1; i <= 8; i++)
	if (!strcmp(buf, ImType[i]))
	    break;
    if (i <= 8) {
	/* get image dimension */
	if (fgets(buf, 512, fp) == NULL) {
	    VIP_Error_Msg("Read_Equation: short read.");
	    return (NULL);
	}
	if (sscanf(buf, "%d%d", &nr, &nc) != 2) {
	    VIP_Error_Msg("Read_Equation: short read.");
	    return (NULL);
	}
	if (nr <= 0 || nc <= 0) {
	    VIP_Error_Msg("Read_Equation: invalid image dimensions.");
	    return (NULL);
	}
	im = ( IMAGE * ) Allocate_Image(0, 0, nr, nc, i);
	if (im == NULL) {
	    VIP_Error_Msg("Read_Equation: out of memory");
	    return (NULL);
	}
	if (fgets(buf, 512, fp) == NULL) {
	    VIP_Error_Msg("Read_Equation: short read.");
	    return (NULL);
	}
	if (buf[strlen(buf) - 1] != '\n')
	    buf[strlen(buf) - 1] = '\n';

	timeout.tv_sec = 10;
	timeout.tv_usec = 5;
	FD_ZERO(&readmask);
	FD_SET(fromchild, &readmask);
	if (strstr(buf, "r") == NULL && strstr(buf, "c") == NULL)
	    /* all pixel values are of a constant value */
	    constant = 1;
	else
	    constant = 0;
	if (constant) {
	    Pipe_Writer(buf);
	    if (select(FD_SETSIZE, &readmask, (fd_set *) 0, (fd_set *) 0,
		       &timeout) <= 0) {
		VIP_Error_Msg("Read_Equation: no input from program 'bl'\n");
		Free_Image(im);
		return (NULL);
	    }
	    else
		Pipe_Reader(result);
	}
	else {
	    (void) sprintf(result, "for (r = %d; r >= 0; r--) ", nr - 1);
	    Pipe_Writer(result);
	    (void) sprintf(result, "for (c = %d; c >= 0; c--) ", nc - 1);
	    Pipe_Writer(result);
	    Pipe_Writer(buf);
	}

	switch (im->type) {
	case BYTETYPE:
	    vali = atoi(result);
	    if (constant)
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--)
			im->i.c[r][c] = (unsigned char) vali;
	    else
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--) {
			if (select(FD_SETSIZE, &readmask, (fd_set *) 0,
				   (fd_set *) 0, &timeout) <= 0) {
			    VIP_Error_Msg("Read_Equation: no input from program 'bl'\n");
			    Free_Image(im);
			    return (NULL);
			}
			else
			    Pipe_Reader(result);
			im->i.c[r][c] = (unsigned char) atoi(result);
		    }
	    break;
	case SHORTTYPE:
	    vali = atoi(result);
	    if (constant)
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--)
			im->i.s[r][c] = (short) vali;
	    else
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--) {
			if (select(FD_SETSIZE, &readmask, (fd_set *) 0,
				   (fd_set *) 0, &timeout) <= 0) {
			    VIP_Error_Msg("Read_Equation: no input from program 'bl'\n");
			    Free_Image(im);
			    return (NULL);
			}
			else
			    Pipe_Reader(result);
			im->i.s[r][c] = (short) atoi(result);
		    }
	    break;
	case LONGTYPE:
	    vall = atol(result);
	    if (constant)
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--)
			im->i.l[r][c] = vall;
	    else
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--) {
			if (select(FD_SETSIZE, &readmask, (fd_set *) 0,
				   (fd_set *) 0, &timeout) <= 0) {
			    VIP_Error_Msg("Read_Equation: no input from program 'bl'\n");
			    Free_Image(im);
			    return (NULL);
			}
			else
			    Pipe_Reader(result);
			im->i.l[r][c] = atol(result);
		    }
	    break;
	case FLOATTYPE:
	    valf = atof(result);
	    if (constant)
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--)
			im->i.f[r][c] = (float) valf;
	    else
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--) {
			if (select(FD_SETSIZE, &readmask, (fd_set *) 0,
				   (fd_set *) 0, &timeout) <= 0) {
			    VIP_Error_Msg("Read_Equation: no input from program 'bl'\n");
			    Free_Image(im);
			    return (NULL);
			}
			else
			    Pipe_Reader(result);
			im->i.f[r][c] = atof(result);
		    }
	    break;
	case DOUBLETYPE:
	    valf = atof(result);
	    if (constant)
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--)
			im->i.d[r][c] = valf;
	    else
		for (r = nr - 1; r >= 0; r--)
		    for (c = nc - 1; c >= 0; c--) {
			if (select(FD_SETSIZE, &readmask, (fd_set *) 0,
				   (fd_set *) 0, &timeout) <= 0) {
			    VIP_Error_Msg("Read_Equation: no input from program 'bl'\n");
			    Free_Image(im);
			    return (NULL);
			}
			else
			    Pipe_Reader(result);
			im->i.d[r][c] = atof(result);
		    }
	    break;
	default:
	    VIP_Error_Msg("Read_Equation: only able to process images of BYTETYPE, SHORTTYPE, LONGTYPE, FLOATTYPE, DOUBLETYPE");
	    Free_Image(im);
	    im = NULL;
	}
    }
    else {
	VIP_Error_Msg("Read_Equation: Invalid image type");
	return (NULL);
    }
    return (im);
}


/*- Pipe_Writer -----------------------------------------------------

Read the value evaluated by "bc -l" from the pipe.

--------------------------------------------------------------------*/

static  Pipe_Writer(buf)
char   *buf;

{
    (void) fputs(buf, fp_tochild);
}


/*- Pipe_Reader -----------------------------------------------------

Read the value evaluated by "bc -l" from the pipe.

--------------------------------------------------------------------*/

static  Pipe_Reader(buf)
char   *buf;

{
    (void) fgets(buf, 512, fp_fromchild);
    buf[strlen(buf) - 1] = '\0';
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];

{
    register int argn;
    char   *in_arg = NULL, *out_arg = NULL;
    FILE   *ifp = stdin;
    IMAGE  *im;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc) {
		    if (!out_arg)
			out_arg = argv[argn];
		    else
			Usage();
		    break;
		}
		else
		    Usage();
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();


    if (in_arg) {
	if (!(ifp = fopen(in_arg, "r")))
	    Pperror("fail to open input file");
    }

    Start_Child_Process();

    im = ( IMAGE * ) Read_Equation(ifp);
    if (im)
	Write_Image(im, out_arg);

    exit(0);
}
