/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		rast.h - Header file for raster images.		
* REVISION:             3.2
* AUTHOR:               DH/GH
* CREATION DATE:        29 Nov 1988
* REVISION DATE:	9/15/93        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.2
* REVISION DATE:	13 Aug 1993
* COMMENT:		Fixed up for DEC build
* BY:			CFF
*
* REVISION:             3.1
* REVISION DATE:	10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:
* REVISION DATE:	09 Jan 1992             
* COMMENT:		NEWVIP
* BY:			DH
*
* @(#)rast.h	3.2 9/15/93
*
*******************************************************************************/





#include <stdio.h>
#include "rastfn.h"

#ifdef XVIEW
#include <pixrect/pixrect_hs.h>
#endif

#define R 0
#define W 1

typedef struct STRUCT_RASTER {
    int     height;		/* number of rows */
    int     width;		/* number of columns */
    int     depth;		/* bits per pixel */
    int     length;		/* bytes of data following header */
    int     type;		/* rasterfile type */
    int     maptype;		/* type of lookup table	 */
    int     maplength;		/* length of lookup table */
    char   *map;		/* lookup table	 */
    int     linelen;		/* bytes in a row (padded to even 16 bits) */
    FILE   *fp;			/* file pointer	 */
    int     mode;		/* read (R) or write (W) mode flag */
    char   *cache;		/* cache of 1 row */
    int     c_pixel;		/* current pixel in row cache */
    struct pixrect *c_pr;	/* make cache look like a pixrect */
}       RASTER;


/* Functions in rast.c */
/* ANSI fn. prototypes in rastfn.h - CFF /*

/*
RASTER *Ropen();
RASTER *Rdopen();
RASTER *Ropen_read();
RASTER *Rdopen_stdin();
RASTER *Ropen_write();
RASTER *Rdopen_stdout();
void    Rinitheader();
int     Rgetheader();
int     Rputheader();
int     Rgetpix();
void    Rputpix();
void    Rclose();
void    Rinfo();
void    Rinitmap();
void    Rputmap();
void    Rgetmap();
void    Rgetmappedpix();

int     Is_Colour_Raster();
RASTER *Read_Raster_Image();
IMAGE  *Raster_To_VIP();
int     VIP_Raster_Colour_Map();
int     Raster_Colour_Index();
*/

