/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		oldvip.h - Header files for the old V.I.P. images.
*				   All the old V.I.P. image types have been
*				   modified to be prefixed by the string
*				   "old_" to avoid name collision with
*			    	   those new V.I.P. image types.
* REVISION:             3.1
* AUTHOR:               CA/DH
* CREATION DATE:        24 Sep 1991
* REVISION DATE:	7/14/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.1
* REVISION DATE:	10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:             
* REVISION DATE:	25 Sept 1991
* COMMENT:	     	modified from various programs written by Chris Avis.
* BY:
*			
* @(#)oldvip.h	3.1 7/14/92
*
*******************************************************************************/

/*-  Magic numbers for the old V.I.P. images -----------------------*/

#define OLD_IMAGE_ID   1001
#define OLD_MATRIX_ID  2001
#define OLD_COMPLEX_ID 3001


/*-  Old V.I.P. image header ---------------------------------------*/

struct old_image_struct {
    int             nr, nc;	/* Number of rows and columns */
    int             res;	/* Resolution */
    double          den;	/* Density */
    int             omega;	/* Filter constant */
    int             fnr;	/* Filter nr */
    int             fnc;	/* Filter nc */
    int             sint;	/* Spare int */
    double          sfloat;	/* Spare float */
    unsigned char **i;		/* Pointer to image data */
};

typedef struct old_image_struct *old_image;


/*-  Old V.I.P. float image (matrix) header ------------------------*/

struct old_matrix_struct {
    int             nr, nc;	/* Number of rows and columns */
    int             res;	/* Resolution */
    double          den;	/* Density */
    int             omega;	/* Filter constant */
    int             fnr;	/* Filter nr */
    int             fnc;	/* Filter nc */
    int             sint;	/* Spare int */
    double          sfloat;	/* Spare float */
    float         **m;		/* Pointer to matrix data */
};

typedef struct old_matrix_struct *old_matrix;


/*-  Old V.I.P. complex image header -------------------------------*/

struct old_complex {
    float           r, i;	/* real and imaginary part */
};

struct old_cp_image_struct {
    int             nr, nc;	/* Number of rows and columns */
    int             res;	/* Resolution */
    double          den;	/* Density */
    int             omega;	/* Filter constant */
    int             fnr;	/* Filter nr */
    int             fnc;	/* Filter nc */
    int             sint;	/* Spare int */
    double          sfloat;	/* Spare float */
    struct old_complex **c;	/* Pointer to the complex image data  */
};

typedef struct old_cp_image_struct *old_cp_image;


/*-  Old V.I.P. image handling routines ----------------------------*/

/* New ANSI prototypes in oldvipfn.h - CFF */

/*
int      old_read_id();
old_image old_init_image();
old_image old_new_image();
int      old_free_image();
old_image old_read_image();

old_matrix old_new_matrix();
old_matrix old_init_matrix();
int      old_free_matrix();
old_matrix old_read_matrix();

old_cp_image old_init_cpimage();
old_cp_image old_new_cpimage();
int      old_free_cpimage();
old_cp_image old_read_cpimage();
*/


