: # use perl
        eval 'exec perl -S $0 ${1+"$@"}'
                if $runnning_under_some_shell;

#========================================================================
#
# Program Name: kgplot - plot 1D-kdf files using gnuplot
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# -khoros_perl_init

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   push(@files, $toolbox_file);
   push(@lineno, 0);
}
die "The HOME environment variable must be set.\n" if ( !defined $ENV{'HOME'});
$HOME = $ENV{'HOME'};
if ( @files == 0 )
{
   push(@files, "$HOME/.Toolboxes");
   push(@lineno, 0);
}
while (@files > 0)
{
   $toolbox_file = pop @files;
   $start_char   = pop @lineno;
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "referenced Toolboxes file(s) exist.\n";
   };
   seek(TBS, $start_char, 0);

   while (<TBS>)
   {
      chop($_);
      if (/^#include\s+([^\s]*)/)
      {
	 push(@files, "$toolbox_file", "$1");
	 push(@lineno, tell TBS, 0);
	 last;
      }
      next if /^\s*#/;
      @line = m/^([^:]+):([^\;]+)\;?(.*)$/;

      if ($line[1] =~ /kfile:/ || $tbpath =~ /kexec:/)
      {
         print "$line[0] is a remote toolbox.  It is not added to list\n";
         print "because remote toolboxes not supported at this time.\n";
      }
      else
      {
         push(@INC, "$line[1]/repos/perl") if $line[0] eq "SRCMACH";

         if ($line[0] eq "SUPPORT")
         {
            if ( $notfound )
            {
               $support_path = $line[1];
               undef $notfound;
            }
            else
            {
               warn "The SUPPORT toolbox is defined twice.  Please check\n";
	       warn "your environment toolboxes file(s) and make sure that\n";
	       warn "all toolboxes are only defined once.\n";
	       $support_path = $line[1];
            }
         }
      }
   }
   close TBS;
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment toolboxes file(s).\n";
}

# -khoros_perl_init_end

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis = 'plot 1D-kdf files using gnuplot';
@ksrcconf_args  = (
        '[i]',      'Input',             'Input 1D data',
	'[style]' , 'Plot Style',        'Plot Style',
	'[title]' , 'Plot Title',        'Plot Title',
        '[i1]',     'Input',             'Input 1D data',
	'[style1]', 'Plot Style',        'Plot Style',
	'[title1]', 'Plot Title',        'Plot Title',
        '[i2]',     'Input',             'Input 1D data',
	'[style2]', 'Plot Style',        'Plot Style',
	'[title2]', 'Plot Title',        'Plot Title',
        '[labelx]', 'Label for x',       'Label for x coordinate',
        '[labely]', 'Label for y',       'Label for y coordinate',
	'[format]', 'Output Format',     'Output File Format',
        '[set1]',   'set',               'string for additional setting',
        '[set2]',   'set',               'string for additional setting',
	'[sizex]' , 'Width Plot Frame',  'width of plot frame',
	'[sizey]' , 'Height Plot Frame', 'height of plot frame',
        '[border]', 'With Border',       'indicate Border or not',
        '[color]' , 'Color Plot',        'indicate which color option to plot',
        '[o]',      'Output image',      'Image with plot'
);

@style_list  = ( 'lines', 'points', 'linespoints', 'impulses', 'dots', 'boxes');
@format_list = ( 'kdf', 'pbm', 'gif',  'postscript');
@color_list  = ( 'color', 'gray', 'monochrome');

# initialize Khoros perl lib
&khoros'initialize("DIP",$whatis,@ksrcconf_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

# ------------------------------------------------------------------------
# Put your code here
# ------------------------------------------------------------------------

$TMPDIR = $ENV{'TMPDIR'} || '/usr/tmp';
$opt_i      = $khoros'seenswitch{"i"};
$opt_style  = $khoros'seenswitch{"style"};
$opt_title  = $khoros'seenswitch{"title"};
$opt_i1     = $khoros'seenswitch{"i1"};
$opt_style1 = $khoros'seenswitch{"style1"};
$opt_title1 = $khoros'seenswitch{"title1"};
$opt_i2     = $khoros'seenswitch{"i2"};
$opt_style2 = $khoros'seenswitch{"style2"};
$opt_title2 = $khoros'seenswitch{"title2"};
$opt_format = $khoros'seenswitch{"format"};
$opt_border = $khoros'seenswitch{"border"};
$opt_sizex  = $khoros'seenswitch{"sizex"};
$opt_sizey  = $khoros'seenswitch{"sizey"};
$opt_set1   = $khoros'seenswitch{"set1"};
$opt_set2   = $khoros'seenswitch{"set2"};
$opt_labelx = $khoros'seenswitch{"labelx"};
$opt_labely = $khoros'seenswitch{"labely"};
$opt_color  = $khoros'seenswitch{"color"};
$opt_o = $khoros'seenswitch{"o"};

if ( ! $opt_i || ! $opt_o )
{
   print "\t>>> i and o are required arguments\n";
   print "\t>>> use -U for detail\n";
   exit(1);
}

if ( ! $opt_style){   $style = 0;}
else              {   $style = $khoros'argval{"style"} - 1; };

if ( ! $opt_title){   $title = ""; }
else              {   $title = $khoros'argval{"title"}; };

$color = $khoros'argval{"color"} - 1;

if (! $opt_format){   $format = 0;}
else              {   $format = $khoros'argval{"format"} - 1; };

if (! $opt_set1)   { $set1 = "";}
else               { $set1 = "set ".$khoros'argval{"set1"};}
if (! $opt_set2)   { $set2 = "";}
else               { $set2 = "set ".$khoros'argval{"set2"};}

if (! $opt_labelx) { $labelx = "";}
else               { $labelx = $khoros'argval{"labelx"};}
if (! $opt_labely) { $labely = "";}
else               { $labely = $khoros'argval{"labely"};}

if (! $opt_sizex)  { $sizex = 0.5;}
else               { $sizex = $khoros'argval{"sizex"};}
if (! $opt_sizey)  { $sizey = 0.5;}
else               { $sizey = $khoros'argval{"sizey"};}
if (! $opt_border) {    $border = 'border';}
else               {
    if ( $khoros'argval{"border"} == 1) {$border = 'border';}
    else                                {$border = 'noborder';}
}

$file_1 = "";
if ( $opt_i1) {
  $i1 = $khoros'argval{"i1"};
  if ( ! $opt_title1) { $title1 = "i1";}
  else                { $title1 = $khoros'argval{"title1"}; };
  if ( ! $opt_style1) { $style1 = 0;}
  else                { $style1 = $khoros'argval{"style1"} - 1; };
	$file_1 = ",\"$TMPDIR/kgplot_i1.$$\" title \"$title1\" with $style_list[$style1]";
}

$file_2 = "";
if ( $opt_i2) {
  $i2 = $khoros'argval{"i2"};
  if ( ! $opt_title2) { $title2 = "i2";}
  else                { $title2 = $khoros'argval{"title2"}; };
  if ( ! $opt_style2) { $style2 = 0;}
  else                { $style2 = $khoros'argval{"style2"} - 1; };
	$file_2 = ",\"$TMPDIR/kgplot_i2.$$\" title \"$title2\" with $style_list[$style2]";
}

$i = $khoros'argval{"i"};
$o = $khoros'argval{"o"};
$ro = $o;

open(GNUFILE, ">$TMPDIR/kgplot.gnu$$") || do
{
  print "\t>>> couldn't create file $TMPDIR/kgplot.gnu$$\n";
  exit(1);
};

if    ($format == 3) {  $rformat = 'postscript eps';}
elsif ($format == 2) {
  $ro = "$TMPDIR/kgplot.pbm$$";
  $rformat = 'pbm ' . $color_list[$color] . ' small';
} else {
  $rformat = 'pbm ' . $color_list[$color] . ' small';
};

print GNUFILE <<EndOfGnufile;
set output "$ro"
set terminal $rformat
set xlabel "$labelx"
set ylabel "$labely"
set size $sizex,$sizey
set $border
$set1
$set2
plot "$TMPDIR/kgplot.$$" title "$title" with $style_list[$style] $file_1 $file_2
EndOfGnufile
close (GNUFILE);

system("kprdata -i $i -val -ind -f $TMPDIR/kgplot.$$");
if ($opt_i1) {
  system("kprdata -i $i1 -val -ind -f $TMPDIR/kgplot_i1.$$");
}
if ($opt_i2) {
  system("kprdata -i $i2 -val -ind -f $TMPDIR/kgplot_i2.$$");
}
system("gnuplot $TMPDIR/kgplot.gnu$$");

#kdf output
if ($format == 0)
{
  system("kformats -i $o -o $o -kdf");
};

#gif output
if ($format == 2)
{
  system("ppmtogif 2> /dev/null $ro >$o");
  system("giftrans -t '#ffffff' $o > $TMPDIR/kgplot.gif$$");
  system("mv $TMPDIR/kgplot.gif$$ $o");
#  system("giftrans -B '#bfbfbf' $TMPDIR/kgplot.gif$$ > $o");
};

system("/bin/rm -f $TMPDIR/kgplot.$$ $TMPDIr/kgplot.gif$$ $TMPDIR/kgplot.gnu$$ $TMPDIR/kgplot.pbm$$");
if ($opt_i1) {
 system("/bin/rm -f $TMPDIR/kgplot_i1.$$");
}
if ($opt_i2) {
 system("/bin/rm -f $TMPDIR/kgplot_i2.$$");
}




