%{
#include <stdio.h>
#include <ctype.h>
#include <math.h>
double regs[26];
static double rval;
static int degflag=0;
#define rd (180/(2*M_PI))
#define dr ((2*M_PI)/180)
#define c_rd ((degflag) ? rd : 1 )
#define c_dr ((degflag) ? dr : 1 )
#ifdef BSD_4.3
#define gmma lgamma
#else
#define gmma gamma
#endif
int base;
double atof();
%}
%start lists

%union { int ival; double dval; }
%token <ival> DIGIT LETTER 
%token <dval> NUMBER COS
%type <dval> expr 
%left '\n'
%right ASSIGN
%left LETVAL
%right '?' ':' IF ','
%left '|'
%left '&'
%left EQUALITY EQUALS 
%left INEQUALITY
%left '=' '>' '<' '!'
%left '+' '-'
%left '*' '/' '%'
%left COS SIN TAN EXP LOG LOG10 ATAN2 ASIN ACOS ATAN SINH COSH TANH ASINH
%left ACOSH ATANH CEIL FLOOR FABS HYPOT J0 J1 JN Y0 Y1 YN SQRT GAMMA LGAMMA LERP
%left DEG RAD
%right '^'
%left UNARY



%%
lists	:	
	|	lists list %prec '\n'
	|	'\n' 
	;
list	:	expr  %prec '\n' { rval=$1; }
	|	error  '\n' {yyerrok; }
	|	'\n'
	;
expr	:	TAN expr  	{$$ = tan(c_dr*$2);}
	|	COS expr  	{$$ = cos(c_dr*$2);}
	|	SIN expr 	{$$ = sin(c_dr*$2);}
	|	CEIL expr	{$$ = ceil($2); }
	|	FLOOR expr	{$$ = floor($2); }
	|	FABS expr	{$$ = fabs($2); }
	|	SQRT expr	{$$ = sqrt($2); }
	|	LERP '(' expr ',' expr ',' expr ')' %prec LERP {$$= $3+($5-$3)*$7;}
	|	HYPOT '(' expr ',' expr ')' %prec HYPOT	{$$ = hypot($3,$5); }
	|	J0 expr		{$$ = j0($2); }
	| 	J1 expr		{$$ = j1($2); }
	| 	JN '(' expr ',' expr ')' %prec JN {$$ = jn((int)$3,$5); }
	|	Y0 expr		{$$ = y0($2); }
	| 	Y1 expr		{$$ = y1($2); }
	| 	YN '(' expr ',' expr ')' %prec YN {$$ = yn((int)$3,$5); }
	|	ASIN expr	{$$ = c_rd* asin($2);}
	|	ACOS expr	{$$ = c_rd* acos($2);}
	|	ATAN expr	{$$ = c_rd* atan($2);}
	|	ATAN2 '(' expr ',' expr ')' %prec ATAN2 {$$ = c_rd* atan2($3,$5); }
	|	COSH expr  	{$$ = cosh(c_dr*$2);}
	|	TANH expr  	{$$ = tanh(c_dr*$2);}
	|	SINH expr 	{$$ = sinh(c_dr*$2);}
	|	ASINH expr	{$$ = c_rd* asinh($2);}
	|	ACOSH expr	{$$ = c_rd* acosh($2);}
	|	ATANH expr	{$$ = c_rd* atanh($2);}
	|	LGAMMA expr	{$$ = gmma($2); }
	|	GAMMA expr	{$$ = gmma($2);  
				$$ = signgam*exp($$); }
	|	DEG expr	{$$ = (rd*$2); }
	|	RAD expr	{$$ = (dr*$2); }
	|	EXP expr  	{$$ = exp($2);}
 	|	LOG expr  	{$$ = log($2);}
	|	LOG10 expr	{$$ = log10($2);}
	|	expr '%' expr	{$$ = $1-(int)($1/$3)*$3;}
	|	expr '>' expr  %prec INEQUALITY	{$$ = ($1>$3); }
	|	expr '<' expr  %prec INEQUALITY	{$$ = ($1<$3); }
	|	expr '>' '=' expr %prec INEQUALITY {$$ = ($1>=$4); }
	|	expr '<' '=' expr %prec INEQUALITY {$$ = ($1<=$4); }
	|	expr EQUALS expr %prec EQUALITY {$$ = ($1==$3);}
	|	expr '!' '=' expr %prec EQUALITY {$$ = ($1!=$4);}
	|	expr '?' expr ':' expr { $$=(($1) ? $3 : $5 ); }
	|	IF '(' expr ',' expr ',' expr ')' %prec IF {$$=(($3) ? $5 : $7); }
	|	expr '&' '&' expr {$$ = ($1 && $4); }
	| 	expr '|' '|' expr {$$ = ($1 || $4); }
	|	'(' expr ')' { $$= $2;}
 	|	expr '^' expr { $$ = pow($1,$3); }
	|	expr '+' expr 	{ $$ = $1 + $3; }
	|	'+' expr	%prec UNARY  { $$ = $2; }
	|	expr '-' expr  { $$ = $1 - $3; }
	|	expr '*' expr  { $$ = $1 * $3; }
 	|	expr '/' expr  { $$ = $1 / $3; }
	|	'-' expr	%prec UNARY  { $$ = - $2;}
	|	NUMBER		{ $$=$1;}
	|	LETTER %prec LETVAL 	{ $$=regs[$1]; }
	|	LETTER '=' expr %prec ASSIGN	 {regs[$1] = $3; $$=$3; }
	;
%%
#include "lex.yy.c"
#include <math.h>

yyerror(s)
char *s;
{ fprintf(stderr,"***%s***\n",s);
}
double expr_tof(s)
  char *s;
{ int i=0;
  rval=0.0;
  strin=s;
  yyparse(); 
  return(rval);
}

