/* $Id: bothpipe.h,v 2.4 90/07/11 13:11:06 mbp Exp Locker: mbp $
 *
 * bothpipe.h: header file for bothpipe.c; modules which use bothpipe.o
 *  should include this
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* This file assumes that the following preprocessor macros have been
 * defined to give the location of system header files:
 * 
 * 	Macro				Header file
 * 
 * 	SYS_TYPES_H			<sys/types.h>
 * 	SYS_SOCKET_H			<sys/socket.h>
 * 	NETINET_IN_N			<netinet/in.h>
 * 	NETDB_H				<netdb.h>
 * 
 * We do this via macros because on some systems, in particular the IRIS,
 * these files have pathnames other than those given here.  (On the IRIS
 * they are <bsd/sys/types.h>, <bsd/sys/socket.h>, <bsd/netinet/in.h>,
 * and <bsd/netdb.h>).
 */

#include <stdio.h>

#include SYS_TYPES_H
#include SYS_SOCKET_H
#include NETINET_IN_H
#include NETDB_H

#define BUFSIZE			120
#define ELBOWPORT		(IPPORT_RESERVED+91)

typedef struct sockaddr_in	Sockaddr;

Sockaddr 			*resolve_host();

char				*fgetline();
