/* $Id$
 *
 * util.c
 */

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

#include <stdio.h>

/*-----------------------------------------------------------------------
 * Function:	wSmallestSquare
 * Description:	find the smallest square (with sides parallel to the axes)
 *		  containing an array of points
 * Args  IN:	xarray: x coords of points
 *		yarray: y coords of points
 *		n: number of points in array
 *      OUT:	(*x,*y): lower left corner of square
 *		*s: side length of square
 * Returns:	success
 * Author:	mbp
 * Date:	Sun Apr  8 15:06:41 1990
 * Notes:	
 */
int
  wSmallestSquare(x,y,s, xarray, yarray, n)
double *x,*y,*s, xarray[], yarray[];
int n;
{
  double xmin, xmax, xlen, ymin, ymax, ylen;

  ArrayExtremes(&xmin, &xmax, xarray, n);
  ArrayExtremes(&ymin, &ymax, yarray, n);

  xlen = xmax - xmin;
  ylen = ymax - ymin;

  if (ylen < xlen) {
    AdjustRangeToLength(&ymin, &ymax, xlen);
    *s = xlen;
  }
  else if (xlen < ylen) {
    AdjustRangeToLength(&xmin, &xmax, ylen);
    *s = ylen;
  }
  else
    *s = xlen;

  *x = xmin;
  *y = ymin;

  return(0);
}

static int
  ArrayExtremes(min, max, array, n)
double *min, *max, array[];
int n;
{
  if (n <= 0) {
    *min = *max = 0;
    return;
  }

  *min = *max = array[--n];
  while (n--) {
    if (array[n] < *min)
      *min = array[n];
    if (array[n] > *max)
      *max = array[n];
  }
}

static int
  AdjustRangeToLength(min, max, len)
double *min, *max, len;
{
  double cen = (*min + *max)/2;

  *min = cen - len/2;
  *max = cen + len/2;
}

/*-----------------------------------------------------------------------
 * Function:	wFileOpenable
 * Description:	check to see if a file can be opened
 * Args  IN:	name: name of file to test
 *		mode: mode to test for
 * Returns:	1 if it can be opened, 0 if not.
 * Author:	mbp
 * Date:	Mon May 28 15:51:06 1990
 * Notes:	
 */
int
  wFileOpenable(name, mode)
char *name, *mode;
{
  FILE *fp;
  int val;

  val = ((fp=fopen(name, mode)) != NULL);
  close(fp);
  return(val);
}
