/*-
 * gdb.h: Include file for geometry database module gdb.c
 *        $Id: gdb.h,v 1.2 90/07/11 13:10:26 mbp Exp Locker: mbp $
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/*
   Changes made since $Revision: 1.2 $:
 */ 


#ifndef GDB_INCLUDED
#define GDB_INCLUDED

/* Typedef for flag to indicate an entity's type */

typedef unsigned long gdb_Entity_type;

/* Values which gdb_Entity_type flags can take on: */

#define	GDB_ENTITY_TYPE_1	((gdb_Entity_type)0000001)
#define	GDB_ENTITY_TYPE_2	((gdb_Entity_type)0000002)
#define	GDB_ENTITY_TYPE_3	((gdb_Entity_type)0000004)
#define	GDB_ENTITY_TYPE_4	((gdb_Entity_type)0000010)
#define	GDB_ENTITY_TYPE_5	((gdb_Entity_type)0000020)
#define	GDB_ENTITY_TYPE_6	((gdb_Entity_type)0000040)
#define	GDB_ENTITY_TYPE_7	((gdb_Entity_type)0000100)
#define	GDB_ENTITY_TYPE_8	((gdb_Entity_type)0000200)
#define	GDB_ENTITY_TYPE_9	((gdb_Entity_type)0000400)
#define	GDB_ENTITY_TYPE_10	((gdb_Entity_type)0001000)
#define	GDB_ENTITY_TYPE_11	((gdb_Entity_type)0002000)
#define	GDB_ENTITY_TYPE_12	((gdb_Entity_type)0004000)
#define	GDB_ENTITY_TYPE_13	((gdb_Entity_type)0010000)
#define	GDB_ENTITY_TYPE_14	((gdb_Entity_type)0020000)
#define	GDB_ENTITY_TYPE_15	((gdb_Entity_type)0040000)
#define	GDB_ENTITY_TYPE_16	((gdb_Entity_type)0100000)
#define	GDB_ALL_ENTITIES	((gdb_Entity_type)0177777)

/* Typedefs for handles of entities and blocks; these handles are
 * actually pointers to nodes linked lists (one list for entities,
 * one list for blocks), but we define the type here to be char* so
 * that the definition of the data structures used in these lists
 * is not accessible by the application program. */

typedef char   *gdb_Entity;
typedef char   *gdb_Block;

/* Types used by retrieval/search procedures: */

/* First, the search type flags; these tell what kind
 * of search to do: */

typedef int     gdb_Search_type;
#define	GDB_SEQUENTIAL		1
#define GDB_NAME		2
#define GDB_DISTANCE		3

/* And specification type for sequential searches: 	 */

typedef int     gdb_Sequence_spec;
#define GDB_FIRST	1
#define GDB_NEXT	2

/* And specification type for distance searches: 	 */

typedef struct gdb_Distance_spec_s {
  char			 *seek_data;
  gdb_Entity_type	 seek_type;
  float                  tolerance;
  gdb_Sequence_spec sequence_spec;
  gdb_Entity		 found_entity;
} gdb_Distance_spec;

/* Constant to be returned by distance procedure to indicate
 * infinite distance */

#define GDB_INFINITY	-1

/* Functions declarations for function which return something
 * other than an int: */

char             *gdb_entity_name();
char             *gdb_entity_data();
char		 *gdb_block_name();
char		 *gdb_generate_unique_name();
gdb_Entity_type   gdb_entity_type();

#endif
