
/*
  $Header: /usr4/Geom_utilities/Tsum/RCS/parse_command.c,v 1.1 91/03/12 16:44:21 meuer Exp $

  Parse the command line, print usage message if necessary.

  Mark Meuer
  #1267045

  */


#include	<malloc.h>
#include	<strings.h>
#include	"tsum.h"


void
parse_command_line( argc, argv, in_file, out_file, chunk_size )
     int	argc;
     char	**argv;
     char	**in_file;
     char	**out_file;
     int	*chunk_size;		/* Number of chunk_size in the polygons */
{
    int	cur_arg = 1;		/* Current argument being processed */
    int	more_options = TRUE;

    /* PROCESS THE OPTIONS */
    *chunk_size = 0;		/* By default, add up all the numbers */
    for( cur_arg = 1; (cur_arg < argc) && (more_options); cur_arg++ )
    {
	if ( strcmp("-chunk", argv[cur_arg]) == 0 )
	{
	    cur_arg++;
	    if ( cur_arg > argc )
	    {
		usage( argv[0] );
	    }
	    else
	    {
		*chunk_size = atoi(argv[cur_arg]);
		if ( *chunk_size < 0 )
		{
		    fprintf(stderr, "-chunk_size %d option in effect.\n", *chunk_size );
		    fprintf(stderr, "Whoa!  You have to specify a chunk of at least 0!\n");
		    fprintf(stderr, "(A chunk of 0 means to sum all the numbers in the file.)\n");
		    exit(-1);
		}
		
	    }

	} 
	else	/* no options were found */
	{
	    more_options = FALSE;
	    cur_arg--;	/* This is to remove the effect of cur_arg++ at end of loop */
	}
    }
    if ( *chunk_size == 0 )
    {
	fprintf(stderr, "Adding all the input numbers into one sum.\n");
    }
    else
    {
	fprintf(stderr, "Summing all groups of %d numbers.\n", *chunk_size);
    }
    fflush(stderr);

    
    /* GET THE FILE NAMES */
    /* Check for 2 arguements left */
    if ( argc - cur_arg != 2 )
    {
	usage( argv[0] );
    }
    else
    {
	*in_file = malloc(sizeof(char) * strlen(argv[cur_arg]));
	strcpy(*in_file, argv[cur_arg++]);
	*out_file = malloc(sizeof(char) * strlen(argv[cur_arg]));
	strcpy(*out_file, argv[cur_arg++]);
    }
}



/*
  PRINT A USAGE MESSAGE, COUGH UP A HAIRBALL, AND DIE.
  */
void
usage( prog_name )
     char	*prog_name;     
{
    fprintf(stderr, "Usage: %s [-chunk_size <n>] <input file> <output file>\n", prog_name );
    fprintf(stderr, "  Computes the sum of a list of numbers.\n\n");
    fprintf(stderr, "  -chunk_size <n> - Compute the sum each group of <n> numbers.\n");
    fprintf(stderr, "               If <n> is 0, all the input is added into one sum.\n");
    fprintf(stderr, "               <n> defaults to 0.\n\n");
    fprintf(stderr, "  Use \"-\" for the file names to read and write\n" );
    fprintf(stderr, "  to standard input and output, repectively.\n\n" );
    fprintf(stderr, "  Program by Mark Meuer.  (C) 1991 by Geomtry Supercomputer Project.\n\n");
                       
    exit(-1);
}
