
/*
  $Header: /usr4/Geom_utilities/Poly2xy/RCS/main.c,v 1.2 91/03/12 16:43:49 meuer Exp $

  Main routine for the poly2xy.

  The program reads in a list of polygons and transforms them so they line in the xy plane.
  Each polygon must be planer and non-self-intersecting.  Other than that there is no retriction
  on their shapes.

  Mark Meuer
  #1267045

  */

#include	<strings.h>
#include	"poly2xy.h"

main( argc, argv )
     int	argc;
     char	**argv;
{
    char	*in_file_name, *out_file_name;
    FILE	*in_file, *out_file;
    int		input_polygon_size;
    Point	tri1, tri2, tri3, test_point;

    fprintf(stderr, "\n%s - transform polygons to the XY plane\n", argv[0]);
    fprintf(stderr, "Geometry Supercomputer Project\n\n", argv[0]);
    fflush(stderr);
    /* PARSE THE COMMAND ARGUMENTS */
    parse_command_line( argc, argv, &in_file_name, &out_file_name, &input_polygon_size );

    /* OPEN THE FILES */
    fprintf( stderr, "Reading from %s, writing to %s.\n",
	   ( strcmp(in_file_name, "-") == 0 ) ? "standard input" : in_file_name,
	   ( strcmp(out_file_name, "-") == 0 ) ? "standard output" : out_file_name );
    if ( strcmp(in_file_name, "-") ==  0 )
    {
	in_file = stdin;
    }
    else
    {
	in_file = open_file( in_file_name, "r" );
    }
    
    if ( strcmp(out_file_name, "-") ==  0 )
    {
	out_file = stdout;
    }
    else
    {
	out_file = open_file( out_file_name, "w" );
    }

    /* PROCESS THE POLYGONS */
    process_polygons( in_file, out_file, input_polygon_size );
    
    /* CLOSE THE FILES */
    if ( in_file != stdin )
    {
	fclose( in_file );
    }

    if ( out_file != stdout )
    {
	fclose( out_file );
    }

    fprintf(stderr, "%s ended normally.\n", argv[0]);
    exit(0);
}
