
/* $Header: /usr2/meuer/Geom_utilities/Matrix_util/RCS/z_rotation.c,v 1.2 91/02/19 16:17:43 meuer Exp $ */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/z_rotation.c,v $ */

/*
 * Routine to create a transormation that will rotate points around the z
 * axis.
 *
 * Mark Meuer
 */

#include	"matrix.h"


void
z_rotation_matrix(z_matrix, theta)
Matrix          z_matrix;
Angle           theta;
{
	/* DECLARE VARIABLES */

	/* SET EACH POINT IN THE MATRIX */
	z_matrix[0][0] = cos((double) theta);
	z_matrix[0][1] = sin((double) theta);
	z_matrix[0][2] = 0.0;
	z_matrix[0][3] = 0.0;

	z_matrix[1][0] = -sin((double) theta);
	z_matrix[1][1] = cos((double) theta);
	z_matrix[1][2] = 0.0;
	z_matrix[1][3] = 0.0;

	z_matrix[2][0] = 0.0;
	z_matrix[2][1] = 0.0;
	z_matrix[2][2] = 1.0;
	z_matrix[2][3] = 0.0;

	z_matrix[3][0] = 0.0;
	z_matrix[3][1] = 0.0;
	z_matrix[3][2] = 0.0;
	z_matrix[3][3] = 1.0;
}
