
/*
 * $Header: /n/poincare/usr5/meuer/5117/RCS/general_rot.c,v 1.7 89/05/02
 * 20:06:13 meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/general_rot.c,v $ */

/*
 * Routine to create a general rotation matrix
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
general_rotation_matrix(result_matrix, user_vector, vector_point, user_angle)
Matrix          result_matrix;
Vector          user_vector;
Point           vector_point;
Angle           user_angle;
{
	/* DECLARE VARIABLES */
	Angle           phi;
	Angle           theta;
	Matrix          rotate_phi;
	Matrix          rotate_phi_inv;
	Matrix          rotate_theta;
	Matrix          rotate_theta_inv;
	Matrix          temp_matrix1;
	Matrix          temp_matrix2;
	Matrix          temp_matrix3;
	Matrix          to_origin;
	Matrix          to_origin_inv;
	Matrix          user_rotate;
	Vector          temp_vector;
	char            debug_string[DEBUG_STRING_LENGTH];
	char            error_string[ERROR_STRING_LENGTH];


	sprintf(debug_string,
		"general_rotation_matrix: user_vector = ( %f, %f, %f )\n",
		(float) user_vector[0],
		(float) user_vector[1],
		(float) user_vector[2]);
	debug(debug_string);

	/* COMPUTE INTERMEDIATE ANGLES AND VECTORS */
	angles_from_z(user_vector, &theta, &phi);

	/*
	 * CREATE THE INTERMEDIATE MATRICIES
	 */

	/* TRANSLATE THE POINT TO THE ORIGIN */
	translation_matrix(to_origin, -vector_point[0], -vector_point[1], -vector_point[2]);

	/* IF VECTOR IS NOT Z AXIS, */
	if ((user_vector[0] != (PointElement) 0.0) || (user_vector[1] != (PointElement) 0.0))
	{
		/* ROTATE VECTOR ABOUT Z INTO THE XZ PLANE */
		z_rotation_matrix(rotate_theta, theta);

		/* ROTATE VECTOR ABOUT Y INTO THE Z AXIS */
		y_rotation_matrix(rotate_phi, phi);

	}
	/* ELSE */
	else
	{
		/* MAKE INTERMEDIATE ROTATION MATRICIES INDENTITY */
		identity_matrix(rotate_theta);
		identity_matrix(rotate_phi);

	}

	/* ROTATE BY GIVEN ANGLE AMOUNT */
	z_rotation_matrix(user_rotate, user_angle);

	/* INVERT Y AXIS ROTATION MATRIX */
	transpose_matrix(rotate_theta_inv, rotate_theta);

	/* INVERT Z AXIS ROTATION MATRIX */
	transpose_matrix(rotate_phi_inv, rotate_phi);

	/* UNDO TRANSLATION */
	translation_matrix(to_origin_inv, vector_point[0], vector_point[1], vector_point[2]);

	debug_matrix("to_origin:", to_origin);

	debug_matrix("rotate_theta_inv:", rotate_theta_inv);

	debug_matrix("rotate_phi_inv:", rotate_phi_inv);

	debug_matrix("user_rotate:", user_rotate);

	debug_matrix("rotate_phi:", rotate_phi);

	debug_matrix("rotate_theta:", rotate_theta);

	debug_matrix("\nto_origin_inv:", to_origin_inv);


	/* COMBINE ALL THE MATRICIES */
	matrix_multiply(rotate_theta, to_origin_inv, temp_matrix1);
	matrix_multiply(rotate_phi, temp_matrix1, temp_matrix2);
	matrix_multiply(user_rotate, temp_matrix2, temp_matrix1);
	matrix_multiply(rotate_phi_inv, temp_matrix1, temp_matrix2);
	matrix_multiply(rotate_theta_inv, temp_matrix2, temp_matrix1);
	matrix_multiply(to_origin, temp_matrix1, result_matrix);

}
