
/* $Header: /usr2/meuer/Geom_utilities/Matrix_util/RCS/dot_prod.c,v 1.2 91/02/18 23:14:09 meuer Exp $ */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/dot_prod.c,v $ */

/*
 * Routine to return the dot product of two vectors
 *
 * Mark Meuer
 */

#include	"matrix.h"

PointElement
dot_product(vect1, vect2)
Vector          vect1;
Vector          vect2;
{
	/* DECLARE VARIABLES */
	char            error_string[ERROR_STRING_LENGTH];
	char            debug_string[DEBUG_STRING_LENGTH];
	PointElement    product;
	int             i;

	/* CLEAR THE SUBTOTAL */
	product = 0.0;

	/* FOR EACH ELEMENT IN THE VECTOR, */
	for (i = 0; i < VECTOR_SIZE; i++)
	{
		/* ADD THE PRODUCT OF THIS ELEMENT TO THE VECTOR */
		product += (vect1[i] * vect2[i]);
	}

	return (product);
}
