


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */




 /*
  * Geometry Routines
  * 
  * Geometry Supercomputer Project
  * 
  * DESCRIPTION:  Header file for the bezier routines
  * 
  */

#include "oogl/mesh.h"
#include "oogl/list.h"
#include "oogl/context.h"

#define BEZ_P 		00
#define BEZ_ST 		01
#define	BEZ_C		02
#define BEZ_PST 	(BEZ_P | BEZ_ST)
#define BEZ_BINARY 	0x4
#define BEZ_REMESH 	0x8		/* need to recompute mesh */
#define MAX_BEZ_DEGREE	6
#define MAX_BEZ_DIMN	4
#define BEZ_DEFAULT_MESH_SIZE	10

typedef struct {

  int		flag, degree_u, degree_v, dimn;
  int		nu, nv;	/* these must match mesh dimensions or remake mesh */
	/* ZZZ The above line should go away when drawstate structure is
	   added to library */
  float		*CtrlPnts;
  float		*STCords;
  Mesh 		*mesh;
  ColorA	color[4];		/* if flag & BEZ_C */

} Bezier;

Mesh 		*BezierDice();
char           	*BezierListName();
List 		*BezierListLoad();
List		*BezierListFLoad();
List 		*BezierListSave();
List		*BezierListFSave();
char           	*BezierName();
BBox           	*BezierBound();
Bezier      	*BezierCreate();
Bezier      	*BezierEvert();
Bezier      	*BezierDraw( Bezier *bezier, ContextObject *context );
Bezier      	*BezierDrawIrisGl( Bezier *bezier, ContextObject *context );
Bezier      	*BezierDrawRenderman( Bezier *bezier, ContextObject *context );
Bezier      	*BezierDrawXWindows( Bezier *bezier, ContextObject *context );
Bezier      	*BezierPrint();
void      	BezierDelete();
Bezier      	*BezierTransform();
Bezier		*BezierCopy();

#ifdef GEOM_SM
Bezier		*BezierShare();
Bezier		*BezierPrivate();
#endif /*!GEOM_NOSM*/
