/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/



/******************************************************************
*
*  File:  extern.h
*
*  Purpose:  declare global variables for Evolver program.
*/

#define DEFAULT_COLOR WHITE

extern char *VERSION;

extern char *areaname;  /* length or area */

struct vvvv { element_id id;  /* which element */
              int vord[3];    /* id's of vertices */
             };
extern int gocount;        /* number of iterations left */ 
extern go_display_flag;    /* display each change */
extern box_flag;  /* whether or not to show outline box */

extern element_id junk; /* for MSC bug */
extern element_id xx_id;  /* for macros to prevent multiple evaluation */
extern element_id x1_id,x2_id,x3_id,x4_id,x5_id,x6_id,x7_id,x8_id,x9_id;
extern element_id xa_id,xb_id,xc_id;/*so nested macros don't tromp each other*/

extern FILE *commandfd;  /* command input file */
extern char filename[60]; /* command file name */
extern FILE *logfd;  /* command log file */
extern char datafilename[60];  /* current datafile name */
extern int datafile_flag;  /* 1 for datafile, 0 for command so expression
			      parser knows what's up */
extern int const_expr_flag;  /* 1 for const_expr, 0 for command so expression
			      parser knows what's up */
extern FILE *outfd;    /* for normal output */
extern int estimate_flag;   /* for toggling estimate of energy decrease */
extern int autopop_flag;    /* whether to do autopopping */
extern int autochop_flag;    /* whether to do autochopping */
extern REAL autochop_size;  /* max edge length for autochop */
extern int autopop_count;  /* number of edges found */
extern int autochop_count;  /* number of edges found */
extern int parens;          /* level of parenthesis nesting */
extern int effective_area_flag; /* use quadratic form for area around vertex */
extern int old_area_flag;    /* on for using old effective area */
extern int runge_kutta_flag; /* whether to use runge-kutta method for motion */
extern int fixed_volumes;     /* how many bodies have fixed volumes */
extern double total_time;     /* total scale factor */
extern double star_fraction;  /* weighting factor for star around vertices */

extern char yytext[];
extern int tok;
extern int int_val;
extern double real_val;
extern char yytext[];
extern int yychar;
extern int line_no;

/* squared curvature as part of energy */
extern int square_curvature_flag;  /* set if to be counted */
extern int square_curvature_param;  /* which parameter for modulus */
extern int kusner_flag;   /* set for edge square curvature */
extern int sqgauss_flag;  /* for squared gaussian curvature */
extern double target_length;  /* for string model */
extern int check_increase_flag;  /* to detect blowups */
extern int approx_curve_flag;  /* if approximate curvature in effect */

/* for Dennis DeTurck unit normal motion */
extern int unit_normal_flag;
extern double deturck_factor;  /* weight for unit normal */

extern REAL **identity;  /* handy identity matrix, set up in init_view */
extern REAL **scratch_mat; /* sdim by sdim temp matrix */

/* homothety target value, set when homothety toggled on */
extern double homothety_target;

extern int compcount;  /* integrand components on constraints */
extern char msg[200];     /* for constructing user messages */
extern char errmsg[200];  /* for error() routine */
extern int  parse_error_flag;  /* set when parser hits error */
extern int parse_errors;    /* for counting errors */
extern int  recovery_flag;     /* set while recovering from parsing error */
extern jmp_buf jumpbuf;   /* for error recovery  */
extern jmp_buf cmdbuf;   /* for command error recovery  */
#define UNRECOVERABLE 0
#define RECOVERABLE   1
#define WARNING       2
#define PARSE_ERROR   3
#define EXPRESSION_ERROR 4
#define COMMAND_ERROR 5
#define DATAFILE_ERROR 6

/* for queries */
extern element_id q_id;
extern int celement;
extern int commandverb;
extern int condition_flag;
#define ATTRIBUTE 19382
extern struct expnode qnode;  /* for query expression */
extern struct expnode show_expr;  /* for show expression */
extern int query_intval;
extern REAL query_realval;
extern int set_query_type;
extern ATTR set_query_attr;
extern int query_coord;
/* values for set attribute queries */
#define SET_Q_ATTR  301
#define SET_DENSITY 302
#define SET_VOLUME  303
#define SET_CONSTRAINT 304
#define SET_COORD   305
#define SET_PARAM   306
#define SET_TAG     307
#define UNSET_Q_ATTR 308
#define UNSET_CONSTRAINT 309
#define SET_COLOR  310
#define SET_TRANS  311
#define DID_       4000


extern double simplex_factorial;  /* simplex area factor */
extern double volume_factorial;  /* simplex volume factor */
extern int subsimplex[1<<MAXCOORD][MAXCOORD];  /* for refining simplices */

/* for expression parsing */
#define LISTMAX 500
extern struct treenode *list;   /* tree */
extern short listtop;  /* first spot reserved for root */

/* type of checking to do */
#define PRELIMCHECK  1
#define REGCHECK     2

/* web.dimension where tension resides */
#define STRING   1
#define SOAPFILM 2

/* for vol_project */
#define NO_SET_PRESSURE 0
#define SET_PRESSURE    1

/* boundary projection types */
#define PARAMPROJ  1
#define TANGPROJ   2
#define GRADPROJ   3
#define PLAINPROJ  4

/* maximum number for constraint projection iterations */
#define MAXCONITER 10

/* for telling constr_proj to detect one-sided constraints */
#define DETECT 1
#define NO_DETECT 0

extern REAL constraint_tolerance;

/* vertex averaging modes */
#define NOVOLKEEP 0
#define VOLKEEP   1

extern REAL  overall_size;  /* for anybody who wants to know how big */
extern int breakflag;     /* set by user interrupt */
extern int iterate_flag;  /* so handler knows when iteration in progress */
extern REAL  (*oldcoord)[MAXCOORD];  /* allocated space for old coordinates */
extern int bare_edge_count;  /* edges without facets */

/* ridge or valley indicators  */
#define RIDGE  1
#define VALLEY 2
extern int ridge_color_flag;  /* whether to differently color */
extern int edgeshow_flag;   /* whether to show edges of facets */
extern int triple_edgeshow_flag;   /* whether to show triple edges  */

/* vertex for zooming in on; default is first one read in */
extern zoom_number;

/* for inner clipping for making zoom pictures */
extern int inner_clip_flag;
extern double inner_clip_rad;

/* conjugate gradient stuff */
extern int    conj_grad_flag;  /* whether conjugate gradient in effect */
extern double cg_oldsum;  /* total grad*grad from previous step */
extern REAL   (*cg_hvector)[MAXCOORD];  /* saved direction vector */
extern double cg_gamma;   /* direction adjustment factor */


/* structure for managing the facets of one body */
struct bodyface { facet_id f_id;
                  WRAPTYPE wrap;  /* wraps of base vertex */
                  int      wrapflag; /* whether wrap done */
                };

/* structure for depth sorting triangles */
extern struct tsort { 
               facet_id f_id;    /* facet this is for */
               short  flag;       /* set if not yet displayed */
               float x[FACET_VERTS][MAXCOORD];    /* display coordinates of vertices */
               float normal[MAXCOORD];
               float mins[MAXCOORD];   /* minimum coordinates */
               float maxs[MAXCOORD];   /* maximum coordinates */
             } *trilist;

struct graphdata { REAL  x[MAXCOORD+1];  /* homogeneous coordinates */
                   REAL  norm[MAXCOORD]; /* unit normal */
                   int    color;   /* colormap index */
                   element_id id;  /* which element being graphed */
                 };

typedef struct {float r,g,b,a;} IColor;  /* same as OOGL ColorA */
extern IColor iris_colors[16];
extern float facet_alpha;  /* global transparency */

/* homogeneous coordinate dimensions */
#define HOMDIM 4

/* function pointers for invoking device-specific graphics */
#ifdef NOPROTO
/* first four are for random-order plotting and are fed raw data */
extern void (*graph_start)();  /* called at start of graphing */
extern void (*graph_edge )();  /* called to graph one triangle */
extern void (*graph_facet)();  /* called to graph one triangle */
extern void (*graph_end)();    /* called at end of graphics */
/* second four are for painter algorithm output, are fed digested data */
extern void (*display_edge )();  /* hardware edge  display */
extern void (*display_facet)();  /* hardware facet display */
extern void (*init_graphics)();  /* hardware initialization */
extern void (*finish_graphics)();  /* hardware end of picture */
#else
extern void (*graph_start)(void); 
extern void (*graph_edge )(struct graphdata *); 
extern void (*graph_facet)(struct graphdata *,facet_id); 
extern void (*graph_end)(void);   
extern void (*display_edge )(struct tsort *);
extern void (*display_facet)(struct tsort *);
extern void (*init_graphics)(void);
extern void (*finish_graphics)(void);
#endif

/* graphing flags */
extern  int init_flag; /* whether graphics initialized */
extern  int bdry_showflag;  /* whether to show facets on boundary */
extern  int no_wall_flag;      /* whether to suppress wall facets */
extern  int normflag;
extern  int thickenflag;
extern  int innerflag;
extern  int outerflag;
extern  int colorflag;
extern  int OOGL_flag;   /* whether MinneView initialized */
extern  double thickness;  /* for thickening */

extern FILE * savefd;   /* file for binary dump of web */
extern FILE * data_fd;   /* file for initial data */

extern char cmapname[100];  /* colormap file name */
typedef REAL maprow[4];
extern  maprow *colormap; /* rgba colormap, values 0 to 1 */
extern int fillcolor;   /* current polygon fill color */
/* gaussian integration coefficients */
extern REAL gcombo[EDGE_CTRL][EDGE_INTERP];
extern REAL sdip[EDGE_CTRL][EDGE_INTERP];
extern REAL ssimp[EDGE_CTRL][EDGE_INTERP];
extern REAL gauss2wt[EDGE_INTERP];
extern REAL poly2partial[FACET_CTRL][2][2];

/* general parameters */
extern REAL **view;  /* transformation matrix */ 
extern int steps; 
extern int energy_init;     /* to keep track if we have current config energy */
extern int movie_init;      /* whether movie routine initialized */

/* for vertex popping */
struct verfacet { vertex_id v_id; facet_id f_id; };

#define MAXWULFF 100
extern double wulff_vector[MAXWULFF][MAXCOORD];  /* the vector components */
#ifdef NOPROTO
extern void (*get_wulff)();
#else
extern void (*get_wulff)(REAL *,REAL *);
#endif

extern REAL **phase_data;  /* phase boundary energies */
extern char phase_file_name[60];  /* for dump */
extern int  phase_flag;    /* if phase boundary data in effect */
extern int phasemax;  /* number of phases */	

extern REAL **leftside;  /* volume projection matrix */
extern REAL **rleftside;  /* volume projection matrix */
extern REAL **fleftside;  /* volume projection matrix */
extern REAL *rightside;  /* right side of volume gradient constraints */
extern REAL *pressures; /* multiples of gradients to subtract from force */
extern REAL *vol_deficit; /* bodyu volume deficits */
extern REAL *vol_restore; /* volume restoring gradient coefficients */
extern int no_refine;   /* keyword NOREFINE in data file header sets this
                        to disable initial triangulation of triangular
                        initial faces. */

/* interpolation structures */
#define MAXLEVEL 30
extern int level;  /* refinement level */
extern REAL extrap_val[MAXLEVEL]; /* final value at level */


/* model dependent function pointers */
#ifdef NOPROTO
extern double (*userfunc[])();
extern double (*userfunc_deriv[])();
extern void (*calc_facet_energy)();
extern void (*calc_facet_forces)();
extern void (*calc_facet_volume)();
extern void (*calc_edge_energy)();
extern void (*calc_edge_forces)();
extern void (*calc_edge_area)();
extern void (*string_grad)();
extern void (*film_grad)();
#else
extern double (*userfunc[])(REAL*);
extern double (*userfunc_deriv[])(REAL*,REAL*);
extern void (*calc_facet_energy)(facet_id);
extern void (*calc_facet_forces)(facet_id);
extern void (*calc_facet_volume)(facet_id);
extern void (*calc_edge_energy)(edge_id);
extern void (*calc_edge_forces)(edge_id);
extern void (*calc_edge_area)(edge_id);
extern void (*string_grad)(void);
extern void (*film_grad)(void);
#endif

/* gaussian integration on [0,1] */
#define MAXGAUSS  5
extern REAL *gauss1Dpt;
extern REAL *gauss1Dwt;

/* 2D gauss */
typedef REAL barytype[3];
extern barytype *gauss2Dpt;
extern REAL *gauss2Dwt; 
extern REAL tq7_coord[FACET_INTERP][2]; 
extern REAL tq7_weight[FACET_INTERP];
extern REAL gauss2Dpt1[1][3]; 
extern REAL gauss2Dwt1[1];
extern REAL gauss2Dpt3[3][3]; 
extern REAL gauss2Dwt3[3];
extern REAL gauss2Dpt7[FACET_INTERP][3]; 
extern REAL gauss2Dwt7[FACET_INTERP];
extern REAL poly6[FACET_INTERP][FACET_CTRL];
extern REAL polyparts[FACET_INTERP][FACET_CTRL][2];   /* integration point, control pt, partial */

/* general dimension gauss integration variables and arrays */
extern int ctrl_num;  /* number of control points */
extern int gauss_num; /* number of integration points */
extern REAL *gausswt;  /* weights of integration points */
extern REAL **gpoly;   /* interpolation polynomial value at integration point k
		   for polynomial of control point j */
extern REAL ***gpolypartial; /* partials of interpolation polynomials */
                   /* gausspt,dim,ctrlpt */

extern REAL **metric;  /* metric values at a point */
extern REAL ***metric_partial; /* partial derivatives of metric */
extern REAL **det_array;   /* tangent vector dot products */
extern REAL **tang;    /* tangents to surface at point */
extern double euclidean_area;   /* euclidean area for conformal metrics */


struct veredge { vertex_id v_id; edge_id e_id; }; /* used in verpopst.c */

/* symmetry group stuff */
extern char *symmetry_name;   /* to be sure datafile matches */
#ifdef NOPROTO
extern void (*sym_wrap)();    /* points to user-defined wrap function */
extern void (*sym_form_pullback)(); /* points to user-defined tangent wrapper */
extern WRAPTYPE (*sym_inverse)(); /* points to user-defined symmetry function */
extern WRAPTYPE (*sym_compose)(); /* points to user-defined symmetry function */
#else
extern void (*sym_wrap)(REAL*,REAL*,WRAPTYPE);
extern void (*sym_form_pullback)(REAL*,REAL*,REAL*,WRAPTYPE);
extern WRAPTYPE (*sym_inverse)(WRAPTYPE);
extern WRAPTYPE (*sym_compose)(WRAPTYPE,WRAPTYPE);
#endif

/* specific case of torus symmetry representation */
#define TWRAPBITS 3
#define POSWRAP   1
#define WRAPMASK  3
#define NEGWRAP   WRAPMASK

/* color for transparent facets */
#define CLEAR (-1)

/* from borlandc/graphics.h */
#if	!defined(__COLORS)
#define __COLORS

enum COLORS {
    BLACK,		    /* dark colors */
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,		    /* light colors */
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};
#endif

#ifdef TC
/* so qsort() and bsearch() below agree with prototypes */
#define FCAST (int(*)(const void*,const void *))
#else
#define FCAST
#endif
