/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*************************************************************
*
*  File: display.c
*
*  Purpose:  Overall control of graphics file output.
*/

#include "include.h"

/**************************************************************
*
*  Function: display_file()
*
*  Purpose:  Makes graphical output display file of
*            current object.
*/

void display_file()
{
  void (*old_init)();
  void (*old_finish)();
  void (*old_start)();
  void (*old_end)();  
#ifdef NOPROTO
  void (*old_edge)(); 
  void (*old_facet)();
  void (*old_gfacet)(); 
  void (*old_gedge)();
#else
  void (*old_edge)(struct tsort *); 
  void (*old_facet)(struct tsort *);
  void (*old_gfacet)(struct graphdata *,facet_id); 
  void (*old_gedge)(struct graphdata *);
#endif
  char response[100];
  double val;

  if ( web.zoom_radius < 9000.0 ) 
    { sprintf(errmsg,"Inner clip radius (%g): ",inner_clip_rad);
      prompt(errmsg,response);
      if ( sscanf(response,"%lf",&val) == 1 )
        { inner_clip_rad = val;
          inner_clip_flag = 1;
        }
    }

  if ( web.torus_flag && !OOGL_flag )
   {
     prompt("Display raw cell, connected bodies or clipped cell? (0,1,2): ",response);
     switch ( response[0] )
       {
         case '0' : web.torus_body_flag = 0; 
                    web.torus_clip_flag = 0; 
                    break;
         case '1' : web.torus_body_flag = 1; 
                    web.torus_clip_flag = 0; 
                    break;
         case '2' : web.torus_body_flag = 0; 
                    web.torus_clip_flag = 1; 
                    break;
       }
   }


  /* get user choice */
  outstring("Choose output graph file format: \n");
  outstring("1. Pixar \n");
  outstring("2. MinneView \n");
  outstring("3. PostScript \n");
  outstring("4. Triangle file \n");
  outstring("5. Softimage  \n");
#ifdef OOGL
  outstring("6. Start simultaneous MinneView  \n");
  outstring("7. End simultaneous MinneView  \n");
#endif
  outstring("0. cancel  \n");
  prompt("Choice: ",response);
  switch ( toupper(response[0]) )
    {
      case '1':
      case 'P':  /* Pixar */
                if ( web.dimension != SOAPFILM )
                  error("Will not do Pixar file for STRING model.\n",
                       RECOVERABLE);
                /* fall through, since MinneView same as Pixar */
      case '2':
      case 'M':  /* Minneview */
                if ( web.dimension != SOAPFILM )
                  error("Will not do MinneView file for STRING model.\n",
                       RECOVERABLE);
                old_start = graph_start;
                old_end   = graph_end;
                old_gfacet = graph_facet;
                 graph_start = pix_start;
                 graph_facet = pix_facet;
                 graph_end   = pix_end;

                /* do output */
                graphgen();

                /* restore old graphics */
                graph_start = old_start;
                graph_end   = old_end;
                graph_facet = old_gfacet;
                break;
    
      case '3':
      case 'S': /* PostScript */
                /* save old graphics functions */
                old_init = init_graphics;
                old_finish = finish_graphics;
                old_edge = display_edge;
                old_facet = display_facet;
                old_start = graph_start;
                old_end   = graph_end;
                old_gfacet = graph_facet;
                old_gedge  = graph_edge;

                /* set PostScript functions */
                init_graphics = ps_init;
                finish_graphics = ps_finish;
                if ( web.dimension == STRING )
                  {
                    graph_start = ps_init;
                    graph_edge  = painter_edge;
                    display_edge = ps_edge;
                    graph_end   = ps_finish;
                  }
                else
                  { 
                    graph_start = painter_start;
                    graph_edge  = painter_edge;
                    display_edge = ps_edge;
                    graph_facet = painter_facet;
                    display_facet = ps_facet;
                    graph_end = painter_end;
                  }

                /* do output */
                graphgen();

                /* restore old graphics */
                init_graphics = old_init;
                finish_graphics = old_finish;
                display_edge = old_edge;
                display_facet = old_facet;
                graph_start = old_start;
                graph_end   = old_end;
                graph_facet = old_gfacet;
                graph_edge  = old_gedge;

                break;
 
      case '4':
      case 'F': /* triangle file output */
                /* save old graphics functions */
                old_init = init_graphics;
                old_finish = finish_graphics;
                old_edge = display_edge;
                old_facet = display_facet;
                old_start = graph_start;
                old_end   = graph_end;
                old_gfacet = graph_facet;
                old_gedge  = graph_edge;

                /* set functions */
                init_graphics = fil_init;
                finish_graphics = fil_finish;
                if ( web.dimension == STRING )
                  {
                    graph_start = fil_init;
                    graph_edge  = painter_edge;
                    display_edge = fil_edge;
                    graph_end   = fil_finish;
                  }
                else
                  { 
                    graph_start = painter_start;
                    graph_facet = painter_facet;
                    display_facet = fil_facet;
                    graph_end = painter_end;
                  }

                /* do output */
                graphgen();

                /* restore old graphics */
                init_graphics = old_init;
                finish_graphics = old_finish;
                display_edge = old_edge;
                display_facet = old_facet;
                graph_start = old_start;
                graph_end   = old_end;
                graph_facet = old_gfacet;
                graph_edge  = old_gedge;
                break;
   
        case '5': /* Softimage file */
                softimage();
                break;

        case '6': /* interactive Minneview */
                if ( web.dimension != SOAPFILM )
                  error("Will not do MinneView file for STRING model.\n",
                       RECOVERABLE);
                Begin_OOGL();
                break;

        case '7': /* end MinneView */
                End_OOGL();
                break;

        case '0': break;

        default: outstring("Invalid choice.\n"); break;
     }
  inner_clip_flag = 0; /* turn off inner clipping */
}

