/*
  File: BitArray.h
  Author: James Painter
  Last Modified: September 29, 1985
  Purpose:  Include file to define operations on bit arrays
*/
#ifndef BITARRAY_DEFINED
#define BITARRAY_DEFINED
#define BITS_PER_INT 32  /* For VAX */
extern char *calloc();

/* typedef int *BitArray; */
extern char *malloc();

/* local only */
#define mask( bit_number ) (1 << (bit_number) % BITS_PER_INT)
#define index( bit_number ) ( (bit_number) / BITS_PER_INT )

/* for export */
#define NewBitArray( nBits )   ( (BitArray) malloc( (unsigned) \
                                      (1+index(nBits)*sizeof(int) )))
#define DisposeBitArray( b )  ( free( (char*)b ) )

#define SetBit( bit_number, bitmap ) (bitmap)[index(bit_number)] |=  \
                                     mask(bit_number)
#define ClearBit( bit_number, bitmap ) (bitmap)[index(bit_number)] &= \
                               ~( mask(bit_number) )
#define TestBit( bit_number, bitmap ) (mask(bit_number) & \
                                        (bitmap)[index(bit_number)])
#endif BITARRAY_DEFINED

