/*
  File: WingEdgeUtil.c
  Author: David Meyers
  Last Modified: 21 August 1990
  Purpose: Utilities for display, input and output of WingEdge structures.
 */

#include<stdio.h>
#include<XOut.h>
#include<WingEdge.h>
#include<WETraversal.h>
#include<EulerOps.h>
#define FALSE (0)
#define TRUE (1)

extern void exit();

/**************************************************************************/

extern void DrawFace(TheFace)
 WEFaceNode *TheFace;
{
 WingEdgeNode *CurrentEdge;

 CurrentEdge = TheFace->Edges;
 do /* while(CurrentEdge != TheFace->Edges) */
  {
   DrawDot(CurrentEdge->Org->x, CurrentEdge->Org->y);
   DrawDot(CurrentEdge->Dest->x, CurrentEdge->Dest->y);
   DrawLine(CurrentEdge->Org->x, CurrentEdge->Org->y, 
	    CurrentEdge->Dest->x, CurrentEdge->Dest->y);

   CurrentEdge = NextEdgeCCWFace(TheFace, CurrentEdge);
   if(NULL == CurrentEdge)
    {
     (void)fprintf(stderr,"Error in Wing Edge: NextEdgeCCWFace returns NULL\n");
     exit(1);
    }
  } while(CurrentEdge != TheFace->Edges);
}

/**************************************************************************/

extern void DrawShell(TheShell)
 WEFaceNode *TheShell;
{
 WEFaceNode *CurrentFace = TheShell;

 do /* while CurrentFace != TheShell */
  {
   DrawFace(CurrentFace);
   CurrentFace = CurrentFace->next;
  } while(CurrentFace != TheShell);
}

/**************************************************************************/

int GetLeftBracket(FilePtr)
 FILE *FilePtr;
{
 int CharacterRead;

 for(;;)
  {
   CharacterRead = fgetc(FilePtr);
   if(EOF == CharacterRead)
    {
     return(FALSE);
    }
   if('{' == (char) CharacterRead) return(TRUE);
  }
}

/**************************************************************************/

int GetRightBracket(FilePtr)
 FILE *FilePtr;
{
 int CharacterRead;

 for(;;)
  {
   CharacterRead = fgetc(FilePtr);
   if(EOF == CharacterRead)
    {
     return(FALSE);
    }
   if('}' == (char) CharacterRead) return(TRUE);
  }
}

/**************************************************************************/

void GetIdentifier(FilePtr, ID)
 FILE *FilePtr;
 char *ID;
{
 int NumberMatched;

 NumberMatched = fscanf(FilePtr,"%s", ID);

 if (1 != NumberMatched)
  {
   (void)fprintf(stderr, "Error reading identifier");
   exit(1);
  }
}

/**************************************************************************/

void ReadPointValues(FilePtr, x, y)
 FILE *FilePtr;
 double *x, *y;
{
 int Debug = FALSE;

 if (2 != fscanf(FilePtr, "%lf %lf", x, y))
  {
   (void)fprintf(stderr,"improper format, ReadPointValues\n");
   exit(1);
  }
 else if(Debug)
  {
   (void)fprintf(stderr,"ReadPointValues got x=%lf, y=%lf\n", *x, *y);
  }
}

/**************************************************************************/

void ReadPoint(FilePtr, x, y)
 FILE *FilePtr;
 double *x, *y;
{
 char Identifier[10];
 int Debug = FALSE;

 if (GetLeftBracket(FilePtr))
  {
   GetIdentifier(FilePtr, Identifier);
   if (!strcmp("POINT", Identifier))
    {
     if(Debug)
      {
       (void)fprintf(stderr, "Calling ReadPointValues\n"); (void)fflush(stderr);
      }
     ReadPointValues(FilePtr, x, y);
     if(Debug)
      {
       (void)fprintf(stderr, "Back from ReadPointValues\n"); 
       (void)fflush(stderr);
       (void)fprintf(stderr, "x=%lf, y=%lf\n",*x, *y);
       (void)fflush(stderr);
      }
     if (!GetRightBracket(FilePtr))
      {
       (void)fprintf(stderr, "failed to find right bracket, ReadPoint\n");
       exit(1);
      }
    }
   else
    {
     (void)fprintf(stderr,"improper format, ReadPoint\n");
     exit(1);
    }
  }
}

/**************************************************************************/

extern WEFaceNode *ReadPolygon(FilePtr)
 FILE *FilePtr;
{
 int i, n;
 int Result;
 char Identifier[10];
 WEFaceNode *ThePolygon = NULL;
 WEVertexNode *FirstVertex = NULL, *CurrentVertex = NULL;
 WingEdgeNode *FirstEdge, *CurrentEdge;

 if (!GetLeftBracket(FilePtr))
  {
   (void)fprintf(stderr,"Failed to find Left bracket, ReadPolygon\n");
   exit(1);
  }

 GetIdentifier(FilePtr, Identifier);
 if (strcmp("POLYGON", Identifier))
  {
   (void)fprintf(stderr, "Improper format, expecting POLYGON, ReadPolygon\n");
   exit(1);
  }

 Result = fscanf(FilePtr, "%d", &n);
 if (1 != Result)
  {
   (void)fprintf(stderr, "improper format, ReadPolygon\n");
   exit(1);
  }
 else
  {
   /* initialize the WingEdge structure with MakeVertexFaceShell */

   MakeVertexFaceShell(&ThePolygon, &FirstVertex);
   ReadPoint(FilePtr, &(FirstVertex->x), &(FirstVertex->y));
   CurrentVertex = FirstVertex;
   MakeEdgeVertex(ThePolygon, CurrentVertex, CurrentVertex->Edges);
   CurrentEdge = CurrentVertex->Edges; FirstEdge = CurrentEdge;
   CurrentVertex = NextVertexCCW(ThePolygon, CurrentVertex);
   ReadPoint(FilePtr, &(CurrentVertex->x), &(CurrentVertex->y));

   for (i=2; i<n; i++)
    {
     /* 
       add vertices and edges one at a time with MakeEdgeVertex, and get the
       requisite x and y values using ReadPoint
      */
     MakeEdgeVertex(ThePolygon, CurrentVertex, CurrentEdge);
     CurrentEdge = NextEdgeCCWFace(ThePolygon, CurrentEdge);
     CurrentVertex = NextVertexCCW(ThePolygon, CurrentVertex);
     ReadPoint(FilePtr, &(CurrentVertex->x), &(CurrentVertex->y));
    }
   if(!GetRightBracket(FilePtr))
    {
     (void)fprintf(stderr, "failed to find right bracket, ReadPolygon\n");
     exit(1);
    }
  }

 /* close the polygon with MakeEdgeFace */
 MakeEdgeFace(CurrentVertex, FirstVertex, ThePolygon, CurrentEdge, FirstEdge);

 /* make a boundary with KillFaceMakeBoundary */
 ThePolygon = FirstEdge->Left;
 KillFaceMakeBoundary(FirstEdge->Right);

 return(ThePolygon);
}

/**************************************************************************/
