C
C This program, originally available on the Motorola DSP bulletin board,
C is provided under a DISCLAIMER OF WARRANTY available from Motorola DSP
C Operation, 6501 William Cannon Drive, West, Austin, Texas  78735-8598.
C
        CHARACTER*90 INLINE,F,TEMP*6,MODFILE
        INTEGER DSPMEM(0:5459),ROMMEM(0:16384)

        CALL GETSG('X',0,'INPUT MODULE FILE: ',MODFILE)

        DO J=0,5459
            DSPMEM(J)=J
        END DO

        OPEN (UNIT=3,FILE=MODFILE,STATUS='OLD',DEFAULTFILE='BROM1.MOD')

900     CONTINUE
        READ(3,910,ERR=1950)F
910     FORMAT(A)
        READ(3,920)IROFF
920     FORMAT(BZ,Z4)
        PRINT *
        WRITE(6,930)F,IROFF
930     FORMAT(' FILE:',A10,' OFFSET TO USE:',Z4)
        OPEN (UNIT=1,FILE=F,STATUS='OLD',DEFAULTFILE='.LOD')


1000    CONTINUE
        READ(1,110)INLINE
110     FORMAT(A)
1005    CONTINUE
        IF (INLINE(1:8).EQ.'_DATA P ') GOTO 1100
        IF (INLINE(1:4).EQ.'_END') GOTO 1900
        GOTO 1000

1100    CONTINUE
        READ(INLINE,1110)LADD
1110    FORMAT(8X,Z4)               
        WRITE(5,1115)LADD  
1115    FORMAT(' P SEGMENT AT ADDRESS: ',Z4)
        LADD=LADD-IROFF
        WRITE(6,1117)LADD
1117    FORMAT(' TRANSLATED TO:',Z4)
1120    CONTINUE
        READ(1,110)INLINE
        ISOF=1
1125    CONTINUE
        IF (INLINE(1:1).EQ.'_') GOTO 1005
        IF (INLINE(ISOF:ISOF+6).EQ.'      ') GOTO 1120
        TEMP=INLINE(ISOF:ISOF+6)
        READ(TEMP,1130)DSPMEM(LADD)
1130    FORMAT(Z6)
C       WRITE(6,1131)LADD,DSPMEM(LADD)
1131    FORMAT(' ADDRESS: ',Z4,' DATA: ',Z6)
        LADD=LADD+1
        ISOF=ISOF+7
        GOTO 1125
1900    CONTINUE
        PRINT *,'*** END DETECTED ***'
        CLOSE (UNIT=1)
        GOTO 900
1950    CONTINUE
C
C       CONVERT 24 BIT DATA TO 3 CONSECUTIVE 8 BIT BYTES
C
        DO I=0,5459
            M=DSPMEM(I)
C           WRITE(6,2000)I,M
2000    FORMAT(' LOCATION:',Z4,' DATA:',Z6)
            DO J=0,2
                M1=M/256
                M2=M1*256
                ROMMEM(3*I+J)=M-M2
C               WRITE(6,2001)J,3*I+J,ROMMEM(3*I+J)
2001    FORMAT(' J',I2,' ADD',I3,' VALUE',Z2)
                M=M1
            END DO
        END DO

        OPEN (UNIT=2,FILE='DSPBUG.LOW',STATUS='UNKNOWN',
        1 CARRIAGECONTROL='LIST')
C
C       OUTPUT HEADER FOR S FILE
C
        WRITE(2,40)
40      FORMAT('S007000048445239E1')
C
C       OUTPUT EPROM DATA
C
        DO M=0,511
            CALL S19(ROMMEM,M*16,M*16,16)
        END DO
C
C       WRITE TERMINATION RECORD
C
        WRITE(2,2030)
2030    FORMAT('S9030000FC')
        CLOSE (UNIT=2)


        OPEN (UNIT=2,FILE='DSPBUG.MID',STATUS='UNKNOWN',
        1 CARRIAGECONTROL='LIST')
C
C       OUTPUT HEADER FOR S FILE
C
        WRITE(2,40)
C
C       OUTPUT EPROM DATA
C
        DO M=0,511
            CALL S19(ROMMEM,M*16+8192-2,M*16,16)
        END DO
C
C       WRITE TERMINATION RECORD
C
        WRITE(2,2030)
        CLOSE (UNIT=2)

        END
C
C
C
        SUBROUTINE S19(MEM,IST,NEW,LEN)
        DIMENSION MEM(0:*),IADD(4)
        CHARACTER*60 S,HEXDIG
        HEXDIG='0123456789ABCDEF'
        S='S1'
        IP=2
        ICK=0
        IBT=LEN+3
        ICK=ICK+IBT
        I1=IBT/16
        I2=IBT-16*I1
        S=S(:IP)//HEXDIG(I1+1:I1+1)//HEXDIG(I2+1:I2+1)
        IP=IP+2
        I1=NEW
        DO 10 M=1,4
            I2=I1/16
            IADD(M)=I1-16*I2
            I1=I2
10      CONTINUE
        ICK=ICK+NEW/256
        ICK=ICK+(NEW-256*(NEW/256))
        DO 20 M=4,1,-1
            S=S(:IP)//HEXDIG(IADD(M)+1:IADD(M)+1)
            IP=IP+1
20      CONTINUE
        DO 100 M=1,LEN
            I1=MEM(M-1+IST)
            ICK=ICK+I1
            I2=I1/16
            I1=I1-16*I2
            S=S(:IP)//HEXDIG(I2+1:I2+1)//HEXDIG(I1+1:I1+1)
            IP=IP+2
100     CONTINUE
        ICK=255-JMOD(ICK,256)
        I1=ICK/16
        I2=ICK-16*I1
        S=S(:IP)//HEXDIG(I1+1:I1+1)//HEXDIG(I2+1:I2+1)
        IP=IP+2
        WRITE(2,200)S(:IP)
200     FORMAT(A)
        RETURN
        END
