#define Object XObject
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/Separator.h>
#undef Object

#include "Application.h"
#include "MenuBar.h"
#include "CascadeButton.h"
#include "PushButton.h"



@implementation MenuBar
- init:(Widget)par
{ return [self init: "menuBar" parent:par]; }
	
- init:(const char*)name mainWindow:mw
{
  return [self init:name parent:[mw main]];
}

- init:(const char*)name parent:(Widget)mw
{
  int width;

  _w = XmCreateMenuBar(mw,name,NULL,0);
  XtVaSetValues(_w,XmNresizable,TRUE,NULL);
  XtManageChild(_w);
  [super installDestroyHandler];
  return self;
}

- helpButton
{
  id hb=[self addSubMenuItem:self xname:"help"];
  XtVaSetValues(_w,XmNmenuHelpWidget,[hb baseWidget],NULL);
  return hb;  
}

- width:(int)w
{
  XtVaSetValues(_w,XmNwidth,w,NULL);
  return self;
}
- height:(int)h
{
  XtVaSetValues(_w,XmNheight,h,NULL);
  return self;
}

- (int)width
{
  int w;
  XtVaGetValues(_w,XmNwidth,&w,NULL);
  return w;
}

- (int)height
{
  int h;
  XtVaGetValues(_w,XmNheight,&h,NULL);
  return h;
}





- addMenuItem:m  xname:(const char*)n
{
  char buffer[1024], *name;
  id button;

//  if(m==self) return nil; // can't add just a button to a menu bar, must have submenus
  
  if(n==NULL) { sprintf(buffer,"%sButton",n); name=buffer; }
  else name=n;

  if(m==self)
    button = [[CascadeButton alloc] init:name parent:_w];
  else 
    button = [[PushButton new] init:name parent:[m subMenuId]];

  return button;
}

- addSubMenuItem:m xname:(const char*)n // always returns a button object
{
  char buffer[1024];
  id cascade;
  Widget parent;
  Widget pulldown;

  if(m==self) parent=_w;
  else if([m class] == [CascadeButton class]) // it _must_ be a cascade button then
      parent = [m subMenuId];
  else parent = _w;

  // create a pulldown menu pain for this item
  sprintf(buffer,"%sPulldownMenu",n);
  pulldown =   XmCreatePulldownMenu (parent,buffer , NULL, 0);
  
  // every main menu option must have a cascade button that pops it up
  sprintf(buffer,"%sButton",n);
  cascade = [[CascadeButton new] init:buffer parent:parent];
  [cascade subMenuId: pulldown];
  
  return cascade;
}

- addItem:m
{
  id o;
  
//  o = [[Button new:te parent:] init:te];
//  [[o target: t] message:s];



  return self;
}

- addSeparatorItem:m
{
    XmCreateSeparator([m baseWidget],"separator",NULL,0);
    return self;
}

@end
