#include <assert.h>
#include <stdio.h>
#include <sys/param.h>
#define Object XObject
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Label.h>
#include <Xm/Protocols.h>
#undef Object

#include "Application.h"
#include "MainWindow.h"



static void mwmCloseWindowCallback(Widget w,XtPointer clientdata, XtPointer calldata)
{
  MainWindow *obj=(MainWindow*)clientdata;
  [obj close];
}




@implementation MainWindow
+ new
{
  return [self new:"MainWindow"];
}
+ new:(const char*)name
{
  id mw=[super new:name];
  [XApp registerWindow: self];
  delegate=nil;
  return mw;
}

- close
{
    [super free];
    if(delegate!=nil && [delegate respondsTo:@selector(windowWillClose)])
       [delegate windowWillClose];
    XtDestroyWidget(_w);
    return self;
}

- title:(const char*)t
{
  XtVaSetValues(_w,XmNtitle,t,NULL);
  return self;
}

- width:(int)w
{
  XtVaSetValues(_w,XmNwidth,w,NULL);
  return self;
}

- height:(int)h
{
  XtVaSetValues(_w,XmNheight,h,NULL);
  return self;
}

- (int)width
{
  int w;
  XtVaGetValues(_w,XmNwidth,&w,NULL);
  return w;
}

- (int)height
{
  int h;
  XtVaGetValues(_w,XmNheight,&h,NULL);
  return h;
}

- x:(int)x
{
  XtVaSetValues(_w,XmNx,x,NULL);
  return self;
}
- y:(int)y
{
  XtVaSetValues(_w,XmNy,y,NULL);
  return self;
}
- (int)x
{
  int x;
  XtVaGetValues(_w,XmNx,&x,NULL);
  return x;
}
- (int)y
{
  int y;
  XtVaGetValues(_w,XmNy,&y,NULL);
  return y;
}



- init
{
  return [self init:"MainWindow"];
}

- init:(const char*)xname;
{
  XmString xmstr = XmStringCreateSimple ( "BLAH" );
  Widget label, blah;
  Atom WM_DELETE_WINDOW;
 
  [super init:xname];
  _w = XtCreatePopupShell (xname, 
			   applicationShellWidgetClass,
			   [XApp baseWidget],
			   NULL, 0 );
  assert(_w);  
  XtVaSetValues(_w,
		XmNallowShellResize,TRUE,
		XmNdeleteResponse, XmDO_NOTHING,
		NULL);
  WM_DELETE_WINDOW=XmInternAtom(XtDisplay(_w),"WM_DELETE_WINDOW",False);
  XmAddWMProtocolCallback(_w,WM_DELETE_WINDOW,mwmCloseWindowCallback,self);


  [super installDestroyHandler]; 
  
  // Use a Motif XmMainWindow widget to handle window layout
  _main = XtCreateManagedWidget ( "mainWindow",
				 xmMainWindowWidgetClass,
				 _w,
				 NULL, 0 );
  [XApp registerWindow: self];
   return self;
}



- (Widget)workArea { return _workArea; }
- workArea:(Widget)w
{
  _workArea = w;
  assert ( _workArea );
  
  // Designate the _workArea widget as the XmMainWindow
  // widget's XmNworkWindow widget
  XtVaSetValues ( _main,
		 XmNworkWindow, _workArea,
		 NULL );
  
  // Manage the work area if the derived class hasn't already.
  
  if ( !XtIsManaged ( _workArea ) )
    XtManageChild ( _workArea );

  return self;
}


- manage
{
  assert ( _w );
  XtPopup ( _w, XtGrabNone );
  
  // Map the window, in case the window is iconified
  
  if ( XtIsRealized ( _w ) )
    XMapRaised ( XtDisplay ( _w ), XtWindow ( _w ) );

  return self;
}
- unmanage
{
  assert ( _w );
  XtPopdown ( _w );

  return self;
}
- iconify
{
  assert ( _w );
  
  // Set the widget to have an initial iconic state
  // in case the base widget has not yet been realized
  
  XtVaSetValues ( _w, XmNiconic, TRUE, NULL );
  
  // If the widget has already been realized,
  // iconify the window
  
  if ( XtIsRealized ( _w ) )
    XIconifyWindow ( XtDisplay ( _w ), XtWindow ( _w ), 0 );

  return self;
}

- makeKeyAndOrderFront:sender
{
	return [XApp makeKeyAndOrderFront: self];
}
- orderBack: sender
{
  return self;
}


- menuBar:mb
{
  XtVaSetValues(_main, XmNmenuBar, [mb baseWidget],NULL); 
  return self;
}

- (Widget)main
{ return _main;}

- delegate
{
    return delegate;
}
- delegate:o
{
    delegate=o;
    return self;
}


- (BOOL)canBecomeMainWindow
{
    if(canBeMainWindow) return YES;
    return NO;
}


- isMainMenuWindow
{
    canBeMainWindow=NO;
    return self;
}

- setTitleAsFilename:(const char*)p
{
    char buffer[MAXPATHLEN+1], *ptr;

    if(p!=NULL)
    {
	/* find the filename */
	ptr=p+strlen(p); /* got to end of string */
	while(*ptr!='/' && ptr!=p) p--;
	if(*ptr=='/') 
	{
	    *ptr='\0';
	    ptr++;
	    sprintf(buffer,"%s - %s/",ptr,p);
	} else if(ptr==p)
	{
	    sprintf(buffer,"%s",p); 
	}
	else sprintf(buffer,"Error separating path components");
    } else 
    {
	sprintf(buffer,"untitled");
    }
    [self title:buffer];

    return self;
}





@end
