#define Object XObject
#include <Xm/List.h>
#undef Object
#include "ListView.h"


static void listCallback(Widget w, XtPointer clientdata, XmListCallbackStruct *calldata)
{
  ListView *obj= (ListView*)clientdata;
  [obj callback:calldata];
}




@implementation ListView

- callback:(XmListCallbackStruct*)d
{
  SEL msg;
  switch(d->reason) 
    {
    case XmCR_SINGLE_SELECT:
      msg = @selector(singleSelection:);
      break;
    case XmCR_MULTIPLE_SELECT:
      msg = @selector(multipleSelection:);
      break;
    case XmCR_EXTENDED_SELECT:
      msg = @selector(extendedSelection:);
      break;
    case XmCR_BROWSE_SELECT:
      msg = @selector(browseSelection:);
      break;
    case XmCR_DEFAULT_ACTION:
      msg = @selector(defaultSelection:);
      break;
    }
  if(delegate!=nil && [delegate respondsTo:msg]) [delegate perform:msg with:d];
  else if([self respondsTo:msg]) [self perform:msg with:d];
  return self;
}


- items:(char**)list count:(int)n
{
  XmStringTable str_list;
  int i;


  str_list = (XmStringTable)XtMalloc(n*sizeof(XmString*));
  for(i=0;i<n;i++) 
    {
      str_list[i] = XmStringCreateSimple(list[i]);
    }
  XtVaSetValues(_w,
		XmNitems, str_list,
		XmNitemCount, n,
		NULL);

  for(i=0;i<n;i++) XmStringFree(str_list[i]);
  XtFree(str_list);
  return self;
}

- selectSingle
{
  return [self setSelectionTypeTo:XmSINGLE_SELECT];
}

- selectMultiple
{
  return [self setSelectionTypeTo:XmMULTIPLE_SELECT];
}

- selectExtended
{
  return [self setSelectionTypeTo:XmEXTENDED_SELECT];
}

- selectBrowse
{
  return [self setSelectionTypeTo:XmBROWSE_SELECT];
}

- setSelectionTypeTo:(XtPointer)sel
{
  XtVaSetValues(_w,XmNselectionPolicy,sel,NULL);
  return self;
}


- init;
{
  return [self init:"list"];
}

- init:(const char*)name parent:(Widget)p
{
  delegate = nil;
  [[super init] xname:name];
  _w = XmCreateScrolledList(p,name,NULL,0);
  XtAddCallback(_w,XmNdefaultActionCallback,listCallback,(XtPointer)self);
  XtAddCallback(_w,XmNsingleSelectionCallback,listCallback,(XtPointer)self);
  XtAddCallback(_w,XmNmultipleSelectionCallback,listCallback,(XtPointer)self);
  XtAddCallback(_w,XmNextendedSelectionCallback,listCallback,(XtPointer)self);
  XtAddCallback(_w,XmNbrowseSelectionCallback,listCallback,(XtPointer)self);
  XtVaSetValues(XtParent(_w), XmNwidth, 100, XmNheight,100,NULL);
  XtManageChild(_w);

  return self;
}


- delegate:o
{
  delegate=o;
  return self;
}

- delegate
{ 
  return delegate;
}

@end
