#include <assert.h>
#include <stdio.h>
#define Object XObject
#include <Xm/PushB.h>
#undef Object

#include "ObjCCallback.h"
#include "Button.h"


static void activateCallback(Widget w, XtPointer clientdata, XtPointer calldata)
{
  Button *obj= (Button*)clientdata;
  [obj activate];
}


@implementation Button

- labelTypePixmap
{
  [self labelType:XmPIXMAP];
  return self;
}

- labelTypeString
{
  [self labelType:XmSTRING];
  return self;
}



- labelType:(String)t
{
  XtVaSetValues(_w,XmNlabelType,t,NULL);
  return self;
}


- labelPixmap:(Pixmap)p
{
  XtVaSetValues(_w,XmNlabelPixmap,p,NULL);
  return self;
}

- armPixmap:(Pixmap)p
{
  XtVaSetValues(_w,XmNarmPixmap,p,NULL);
  return self;
}






- sensitive:(BOOL)s
{
  XtVaSetValues(_w,XmNsensitive,s,NULL);
  return self;
}

- marginTop:(int)t bottom:(int)b height:(int)h 
{
  XtVaSetValues(_w,
		XmNmarginTop,t,
		XmNmarginHeight,h,
		XmNmarginBottom,b,
		NULL);
  return self;
}

- labelInsensitivePixmap:(Pixmap)p
{
  XtVaSetValues(_w,XmNlabelInsensitivePixmap,p,NULL);
  return self;
}


- activateCallbackMethod:co
{
  printf("callback activated\n");
  printf("%s\n",[co clientData]);
  [co free];
  return self;
}


- target:nt message:(SEL)nm
{
  [[self target:nt] message:nm];
  return self;
}


- activate
{
  if(target!=nil && [target respondsTo: message]) 
    [target perform: message with: self];
  return self;
}

- init:(const char*)name parent:(Widget)parent type:(WidgetClass*)t
{
  [super init:name];
  _w = XtCreateManagedWidget(_name,
			     *t,
			     parent,
			     NULL, 0);
  //ObjCAddCallback(_w,XmNactivateCallback,"this is great",self,@selector(activateCallback:));
  //XtAddCallback(_w,XmNactivateCallback,activateCallback, self);
  //XtVaSetValues(_w, XmNwidth, 100, XmNheight, 100,NULL);
  target = nil;
  return self;
}


- activateCallback:(XtPointer)d
{
  ObjCAddCallback(_w,XmNactivateCallback,d,self,target,message);
  return self;
}

- target:nt message:(SEL)msg activateCallback:(XtPointer)d
{
  [[[self target:nt] message:msg] activateCallback:d]; 
  return self;
}

- target:newTarget
{
  target = newTarget;
  return self;
}
- target { return target; }
- message:(SEL)newMsg
{
  message = newMsg;
  return self;
}

- accelerator:(const char*)acc 
{
  XtVaSetValues(_w, XmNaccelerator, acc,NULL);
  return self;
}

- accelerator:(const char*)acc acceleratorText:(const char*)text
{
  XmString str=XmStringCreateSimple(text);
  XtVaSetValues(_w, XmNaccelerator, acc, XmNacceleratorText,str,NULL);
  XmStringFree(str);
  return self;
}

- mnemonic:(char)m
{
  XtVaSetValues(_w,XmNmnemonic,m,NULL);
  return self;
}


- label:(const char*)l mnemonic:(char)m 
{
  [[self label:l] mnemonic:m];
  return self;
}

- label:(const char*)l mnemonic:(char)m accelerator:(const char*)acc
{
  [[[self label:l] mnemonic:m] accelerator:acc];
  return self;
}


- label:(const char*)l mnemonic:(char)m accelerator:(const char*)a acceleratorText:(const char*)t
{
  [[[self label:l] mnemonic:m] accelerator:a acceleratorText:t];
  return self;
}





- label:(const char*)newLabel
{
  XmString str;
  assert(_w);
  str = XmStringCreateSimple(newLabel);
  XtVaSetValues(_w,XmNlabelString,str,NULL);
  XmStringFree(str);
  return self;
}
@end
