static char rcsid[] = "$Id: handler.c,v 1.2 1992/01/17 23:02:13 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  handler.c
 *
 *    Contain action handlers for the parser to invoke upon a gdb command.
 *
 *    TextSetTopPosition():	Set the top character position of textdisplayed
 *    AdjustText():		Adjust the portion of text displayed.
 *    stop_at_handler():	Place stop sign on line specified.
 *    stop_in_handler():	Place stop sign on function specified.
 *    func_handler():		Display function, if specified.
 *    file_handler():		Display file, if specified.
 *    use_handler():		Record directory paths.
 */

#include <ctype.h>
#include "global.h"
#include <Xm/Xm.h>
#include <Xm/Text.h>

Boolean		Echo = True;		/* display gdb output if true */
static Boolean	Skip_func_handler = False;

/*  Display text starting from the top position specified by pos */

void TextSetTopPosition(w, pos)
    Widget w;
    XmTextPosition pos;
{
    Arg args[MAXARGS];

    XtSetArg(args[0], XmNtopCharacter, pos);
    XtSetValues(w, args, 1);
}

short currpos;

/*
 *  Adjust text so that 'line' will fall into the viewable part of the
 *  source window.
 *  Arrows, stop signs, and line label and Vertical Scroll bar
 *  are updated accordingly.
 */
void AdjustText(line)
    int	   	line;
{
    FileRec 		*file;
    int	    		nlines = 0;
    int			i;
    XmTextPosition 	pos;
    Dimension width;
    Arg                 args[5];

    if ((file = displayedFile) == NULL || line <= 0) return;
    file->currentline = line;

    if (line < file->topline || line > file->bottomline ) {
	/* Position line about 30% from the top */
	nlines = file->lines / 3;
	if (line < nlines)			   /* near top */
	    file->topline = 1;
	else if (line > file->lastline - nlines)  /* near bottom */
	    file->topline = MAX(file->lastline - file->lines + 1, 1);
	else
	    file->topline = line - nlines;
	file->bottomline = MIN(file->topline + file->lines - 1, 
			       file->lastline);
	TextSetTopPosition(sourceWindow, file->linepos[file->topline]);
	file->topPosition = file->linepos[file->topline];
    }
    XmTextSetInsertionPosition(sourceWindow, file->linepos[line]);

    /* Text window might have scrolled, check topline & bottomline */
    pos = XmTextGetTopCharacter(sourceWindow);

    for (i=1; pos >= file->linepos[i]; i++);
    if (file->topline != i-1) {
	file->topline = i-1;
	file->bottomline = MIN (file->topline + file->lines - 1,
				file->lastline);
    }

    if(pos != currpos)
      {
	UpdateScrollV(file);
	currpos = pos;
      }

    XtMapWidget(sourceWindow);

    if (line <= file->lastline)
      UpdateLineLabel(line);
    else
      UpdateMessageWindow("Line number is out of range.", NULL);
    UpdateStops(file);
    UpdateArrow(file);
    UpdateUpdown(file);
    UpdateBomb(file);
}

