static char rcsid[] = "$Id: gdb_regex.c,v 1.1.1.1 1992/01/10 18:30:28 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

#include "global.h"
#include "regex.h"

/*

		.		--> any character but '\n'
		*		--> any character 0 to n times
		+		--> any character 1 to n times
		?		--> any character 0 or 1 time
		^		--> begin of line or NOT following character
		$		--> end of line or '$'
		\\w		--> character '0..9a..zA...Z'
		\\W		--> character NOT '0..9a..zA...Z'
		\\<		--> word begin (word is composed of 
		                    0..9a..zA...Z)
		\\>		--> word end (word is composed of 
		                    0..9a..zA...Z)
		\\b		--> word bound
		\\B		--> not word bound
		\\|		--> means OR
		\\`		--> begin buffer
		\\\'	        --> end buffer
		
*/


PatternRec output_pattern[] = {

  /* exec with Message after */
  {"\\(.*\n\\)*\032\032\\([^ ]+\\):\\([0-9]+\\):\\([0-9]+\\):\\([^ ]+\\):0x.+\n\\([ ]*[^0-9].*\n\\)\\(\\([0-9]+:.*\n\\(\\( .*\n\\)*}\n\\)?\\)*\\)",
     NULL,
     {6, -1, -1, 3, 2, 7}},

  /* exec with Message before */
  {"\\(.*\n\\)*\\([ ]*[^ ].*\n\\)\032\032\\([^ ]+\\):\\([0-9]+\\):\\([0-9]+\\):\\([^ ]+\\):0x.+\n\\(\\([0-9]+:.*\n\\(\\( .*\n\\)*}\n\\)?\\)*\\)",
     NULL,
     {2, -1, -1, 4, 3, 7}},
  
  /* exec without Message */
  {"\\(.*\n\\)*\032\032\\(\\([^ ]+\\):\\([0-9]+\\):\\([0-9]+\\):\\([^ ]+\\):0x.+\n\\)\\(\\([0-9]+:.*\n\\(\\( .*\n\\)*}\n\\)?\\)*\\)",
     NULL,
     {2, -1, -1, 4, 3, 7}},

  /* done */
  {"\\(.*\n\\)*\n\\(Program terminated with signal \\|Program exited with code 0\\|Program exited normally\\).*\n\\(.*\n\\)*",
     NULL,
     {-1, -1, -1, -1, -1, -1}},

  /* break */
  {"\\(.*\n\\)*Breakpoint \\([0-9]+\\) at [^ ]+: file \\([^ ]+\\), line \\([0-9]+\\).\n",
     NULL,
     {-1, 2, -1, 4, 3, -1}},

  /* info directories */
  {"Source directories searched:[ ]*\\([^ ]+\\)[ ]*\n",
     NULL,
     { -1, -1, -1, -1, 1, -1}},

  /* up, down, frame*/
    {"\\(.*\n\\)*\\(#[0-9]+[ ]+\\(0x[^ \n]+[ ]+in[ ]+\\)?\\([^ \n]+\\)[^\032]*\\)\032\032\\([^ \n]+\\):\\([0-9]+\\):\\([0-9]+\\):\\([^ \n]+\\):0x.+\n",
     NULL,
     {2, -1, 4, 6, 5, -1}},

  /* bell */
  {"\\(Undefined command: .*\n\\|Already at the \\(top\\|bottom\\) call level\n\\|\
No active stack frames\n\\|no program to run\n\\|no process to run\n\\|\
program is not active\n\\|can't continue execution\n\\|\
.*\ncan't write to process.*\n\\|\
\\(Top\\|End\\)-of-file; did not find search string:.*\n\\)",
  NULL,
  {-1, -1, -1, -1, -1}},
  
  /* search */
  {"\\([0-9]+\\).*\n",
     NULL,
     {-1, -1, -1, 1, -1, -1}},
  
  /* info line */
  {"\\(Line \\(number \\)?[0-9]+ \\(of\\|is out of range for\\) \"\\([^ ]+\\)\".*\\)\n",
     NULL,
     {-1, -1, -1, -1, 4, -1}},
  
  /* print */
  {"\\(warning: .*\n\\)?\\(\\(.*\\) = .*\n\\(.*\n\\)*\\)",
     NULL,
     { 3, -1, -1, -1, -1, 2}},

  /* start gdb (debug)  */
  {"\\(.*\n\\)*GDB [0-9]+.[0-9]+, Copyright [0-9]+ Free Software Foundation, Inc.\\(.*\n\\)*",
     NULL,
     { -1, -1, -1, -1, -1, -1}},

  /* directory */
  {"\\([^ ]+ is already in the source path.[ ]*\n\\)*Source directories searched:[ ]*\\([^ ]+\\)[ ]*\n",
     NULL,
     { -1, -1, -1, -1, 1, -1}},
  
  /* list */
  {"\\(.*\n\\)*\\(\\([0-9]+\\).*\n\\)",
     NULL,
     { -1, -1, -1, 3, -1, -1}},
  
  /* display */
  {"\\([0-9]+:.*\n\\)",
     NULL,
     { -1, -1, -1, -1, -1, 1}},

  /* info display */
  {"\\(\\([0-9]+:.*\n\\(\\( .*\n\\)*}\n\\)?\\)*\\)",
     NULL,
     { -1, -1, -1, -1, -1, 1}},

  /* pwd or cd */
  {"Working directory[ ]+\\([^ ]+\\).[ ]*\n\\([ ]*(canonically[ ]+\\([^ ]+\\)).\n\\)?",
     NULL,
     { 1, -1, -1, -1, -1, 3}},

  /* program received signal */
  {"\\(.*\n\\)*\n\\(Program received signal \\([-]?[0-9]+\\), [^ ]+.*\n\\)\\(.*\n\\)*",
     NULL,
     { 2, 3, -1, -1, -1, -1}},
  
  /* special for test in filter_display_info() */
  {"\\([^0-9].*\n\\)*\\([0-9]+:.*\n\\)\\(.*\n\\)*",
     NULL,
     { -1, -1, -1, -1, -1, 2}},
  
  /* special for test in filter_reading_symbols() */
  {"\\(.*\n\\)*\\(Reading in symbols for .*done.\n\\)\\(.*\n\\)*",
     NULL,
     { 2, -1, -1, -1, -1, -1}},

  /* The End */
  NULL   
};

PatternRec command_pattern[] = {
  /* run -r - cont - c - next - n - step - s - nexti - ni - stepi - si - return
     jump - until - u */

  {"[ ]*\\(run\\|r\\|cont\\|c\\|next\\|n\\|step\\|s\\|nexti\\|stepi\\|ni\\|si\\|ret[urn]*\\|j[ump]*\\|unt[il]*\\|u\\)\\( .*\\)?\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  /* break - tbreak */

  {"[ ]*\\(t\\)?\\(b\\|br\\|bre\\|brea\\|break\\)\\( .*\\)?\n",
     NULL, {-1, -1, -1, -1, -1, -1}},

  {"[ ]*show[ ]+directories[ ]*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* 'frame' is special case of 'frame n' since it does not change the
     current frame. Else 'frame n' is like up or down. */
  
  {"[ ]*fr[ame]*[ ]*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  {"[ ]*\\(up\\|down\\|dow\\|do\\|fr[ame]*\\)\\( .*\\)?\n", 
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* delete - d - clear - enable - disable - dis - disa */
  /* gdb commands 'delete display' 'enable display' and 
     'delete environment are also found here. This is 
     superfluous, but no problem */
  
  {"[ ]*\\(del[ete]*\\|d\\|cl[ear]*\\|en[able]*\\|disab[le]*\\|dis\\|disa\\)\\( .*\\)?\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  {"[ ]*fi[nish]*[ ]*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  {"[ ]*info[ ]+line[ ]*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* symbol-file */
  {"[ ]*sy.*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  {"[ ]*cd[ ]*[^ ]+[ ]*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* directory */
  {"[ ]*dir.*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  {"[ ]*pwd[ ]*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* list */
  {"[ ]*l.*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* forward-search or reverse-search or search */
  
  {"[ ]*\\(fo[rward-search]*\\|rev[erse-search]*\\|sea[rch]*\\)[ ]*",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* 'display' is a special case of 'display exp' since it does not
     add any expression to be displayed */
  
  {"[ ]*disp[lay]*[ ]*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  {"[ ]*disp[lay]\\(/[^ ]+\\)?*[ ]*[^ ]+[ ]*.*\n",	
     NULL, {-1, -1, -1, -1, -1, -1}},
	
  /* undisplay */
  {"[ ]*und.*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* Note that Token.mesg (if any) is updated with 
     print command (see 1) */
  
  {"[ ]*print[ ]*\\([^ ]?\\([ ]+[^ ]+\\)*\\)[ ]*\n",	
     NULL, { 1, -1, -1, -1, -1, -1}},

  {"[ ]*info[ ]+break[ ]*\n",				
     NULL, {-1, -1, -1, -1, -1, -1}},
  
  /* source (note that Token.TK_FILE is updated here) */
  {"[ ]*so[urce]*[ ]*\\(.*\\)\n",
     NULL, {-1, -1, -1, -1,  1, -1}},
  
  /* exec-file (just used internally) */
  {"[ ]*exec-file .*\n",
     NULL, {-1, -1, -1, -1, -1, -1}},

  /* core-file */
  {"[ ]*cor[e-file]*.*\n", NULL,
     {-1, -1, -1, -1, -1, -1}},

  /* define */
  {"[ ]*def[ine]*[ ]+[^ ]+\n", NULL,
     {-1, -1, -1, -1, -1, -1}},

  /* document */
  {"[ ]*doc[ument]*[ ]+[^ ]+\n", NULL,
     {-1, -1, -1, -1, -1, -1}},

  /* end of define or document */
  {"[ ]*end[ ]*\n", NULL,
     {-1, -1, -1, -1, -1, -1}},

  {"[ ]*h[elp]*\\([ ]*\\|[ ]+.*\\)\n", NULL,
     {-1, -1, -1, -1, -1, -1}},

  NULL
};




