;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   PROGRAM:	sine.asm
;;
;;   AUTHOR:	Leonard Manzara
;;
;;   THIS PROGRAM, WHEN USED IN CONJUNCTION WITH sine.c, PRODUCES A SINE TONE THROUGH
;;   THE NeXT'S D/A CONVERTER.  ASSEMBLE THIS WITH:  asm56000 -a -b -l sine.asm
;;   BASED HEAVILY ON  dsp_example_3.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	include	'ioequ.asm'


;;  MEMORY STORAGE
DMA_DONE	equ	0
x_DMA_flags	equ	$00ff
x_OutputValue	equ	$00fe

y_DMA_size	equ	$00ff
y_Buffer_count	equ	$00fe

XRAMLO		equ	8192
YTABLERAM	equ	8192

TABLE_LENGTH	equ	1

DMA_R_REQ	equ	$050001		; message to host to request DMA transfer


;; INTERRUPT VECTORS
	org	p:$0
	jmp	<reset			; reset interrupt

	org	p:$0024			; set flag when dma transfer done
	bset	#DMA_DONE,x:x_DMA_flags

	org	p:$0026			; host command to start sine wave send
	jmp	<main

	org	p:$0028			; host command to stop sine wave send
	jmp	<reset



;; RESET SUBROUTINE
	org	p:$40
reset
	movec	#6,omr			; chip set to mode 2; ROM enabled
	bset	#0,x:m_pbc		; configure port B so it acts as host interface
	bset	#3,x:m_pcddr		; program pin 3 (pc3) of port C to be output
	
	bclr	#3,x:m_pcd		; zero to enable the external ram
	
	movep	#>$000000,x:m_bcr	; set 0 wait states for all external RAM
	movep	#>$00b400,x:m_ipr	; set interrupt priority register to SSI=0, SCI=1, HOST=0

	move	#>$0200,a
	move	a,y:y_DMA_size		; set buffersize to 512
	move	#>XRAMLO,r7		; set pointer to beginning of DMA buffer

	clr	a
	move	a,x:x_DMA_flags		; clear DMA flags
	move 	a,y:y_Buffer_count	; set Buffer count to 0

	jsr	read_table		; read initial table value(s)
	move	y:YTABLERAM,n2		; intialize n2, for pitch
	nop				; waste a cycle to let n2 set

	bset	#m_hcie,x:m_hcr		; enable host command interrupts
	move	#0,sr			; unmask interrupts

_loop	jmp	_loop			; loop until interrupt sends us to main



;; MAIN ROUTINE
main
	move	#>$0100,r2		; load in origin of sine table into r2
	move	#>$0100-1,m2		; make it mod 256
	nop				; waste one cycle to allow r2 and m2 to be initialized

_toploop
	jsr	poll_table
	move	y:(r2)+n2,a		; read value from sine table
	rep	#16			; shift and extra 8 to drop the volume	<jf>
	  asr	a			; shift the value right to avoid clipping
	jsr	putHost			; since stereo put it into
	jsr	putHost			; DMA buffer twice
	jmp	_toploop		; loop forever



;; PUTHOST SUBROUTINE
putHost
	move	a,x:x_OutputValue	; store a, so we can restore it at end of routine
	move	a,x:(r7)+		; put output value into DMA register, increment pointer

	move	y:y_Buffer_count,b
	move	#>1,a
	add	a,b
	move	b,y:y_Buffer_count	; increment buffer count by 1

	move	y:y_DMA_size,a
	cmp	b,a
	jgt	_exit			; if Buffer count < DMA size, exit
					; (only send DMA buffer when it is full)

_transfer
	jclr	#m_htde,x:m_hsr,_transfer	; loop until htde bit HSR is set
	movep	#DMA_R_REQ,x:m_htx	; send DMA initiate read message to host

_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	; loop until host acknowledges (HF1=1)

	move	#>XRAMLO,r7		; point to beginning of DMA buffer
	move	y:y_DMA_size,b		; initialize loop size
	do	b,_send_loop		; top of DMA buffer send loop
_send	jclr	#m_htde,x:m_hsr,_send	; loop until htde bit of HSR is set
	movep	x:(r7)+,x:m_htx		; send buffer element to host
_send_loop
	btst	#DMA_DONE,x:x_DMA_flags	; if interrupt has set flags, then go to end
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_send_loop	; else keep sending zeroes until interrupt sets flags
	movep	#0,x:m_htx
	jmp	_send_loop
_endDMA
	bclr	#DMA_DONE,x:x_DMA_flags	; reset flag to 0, we know we are done--be ready to
					; set flag on next interrupt
_ackEnd
	jset	#m_hf1,x:m_hsr,_ackEnd	; loop until host acknowledge has ended (HF1=0)
	move	#>XRAMLO,r7		; reset DMA buffer pointer to beginning
	clr	a			; reset buffer count
	move	a,y:y_Buffer_count
_exit	move	x:x_OutputValue,a	; put output value into a, in case it's needed by the
	rts				; calling routine



read_table
	bset	#m_hf3,x:m_hcr		; set HF3 (tells host that DSP ready to receive data)
	move	#>YTABLERAM,r3		; reset pointer to beginning of table

	do	#TABLE_LENGTH,_tableloop	; loop until table filled
_loop	jclr	#m_hrdf,x:m_hsr,_loop	; loop until hrdf bit of HSR becomes set
	movep	x:m_hrx,y:(r3)+		; move data into y memory; increment pointer
_tableloop

	bclr	#m_hf3,x:m_hcr		; clear HF3 (tells host that DSP finished reading data)
	rts						; calling routine

;; section added by joe freeman to allow run time changing of sine wave
;; note: potential problem here because we do not do any flag handshaking to sync up frames?
poll_table
	jclr	#m_hrdf,x:m_hsr,_exitpoll	; if no new table data ready then blow it off
	move	#>YTABLERAM,r3		; reset pointer to begining of table
	do	#TABLE_LENGTH,_pollloop	; loop untill table is filled
_loop	jclr #m_hrdf,x:m_hsr,_loop	; loop untill hrdf bit of HSR becomes set
	movep	x:m_hrx,y:(r3)+		; move data into y memory and increment pointer
_pollloop
	move	y:YTABLERAM,n2		;initialize n2 for pitch
	nop							; waste a cycle so n2 can set (needed?)
	rts							; go home
_exitpoll
	rts
	

