/* set 128 SoundBlaster voices from patches in a Glib library;
   e.g.:
	setsb default.sb
				--gl
*/
#include <stdio.h>
#include <linux/soundcard.h>
#include <fcntl.h>

#define SBVOICESIZE 52
#define SBOFFSET 0x24

char   *basename ();

main(int argc, char *argv[])
{	int sb, f, c, n, v;
	int first_voice = 0, num_voices = 128;
	struct sbi_instrument instr;
	char *progname;
	char buf[52];

	progname = basename (argv[0]);
	if (!strcmp(progname,"setdrums")) {
		first_voice = 128;
		num_voices = 16;
	}

	if (argc != 2) {
		fprintf(stderr,"library file?\n");
		exit(1);
	}
	if ((f = open(argv[1], O_RDONLY, 0)) == -1) {
		fprintf(stderr,"can't find that library file\n");
		exit(1);
	}
	if ((sb=open("/dev/sequencer", O_WRONLY, 0)) == -1) {
		fprintf(stderr,"can't open sequencer device\n");
		exit(1);
	}
	for (v = 0; v < num_voices; v++) {
		if (read(f, buf, SBVOICESIZE) != SBVOICESIZE) {
			fprintf(stderr,"short library file\n");
			exit(1);
		}
		instr.channel = v + first_voice;
		for (n = SBOFFSET; n < SBVOICESIZE; n++)
			instr.operators[n - SBOFFSET] = buf[n];
		if (ioctl(sb, SNDCTL_FM_LOAD_INSTR, &instr) == -1) {
			fprintf(stderr,"can't load instrument %d\n", v);
			exit(1);
		}
	}
}

char   *basename (s)
char   *s;
{
	char   *p;

	if (p = (char *)strrchr (s, '/'))
		return (++p);
	else
		return (s);
}				/* basename */

