/*
**  wt -- a 3d game engine
**
**  Copyright (C) 1994 by Chris Laurel
**  email:  claurel@mr.net
**  snail mail:  Chris Laurel, 5700 W Lake St #208,  St. Louis Park, MN  55416
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* input.c -- This file is a device independent layer between the input
**   system and the rest of wt.  The main reason that it exists is to
**   possibly support multiple input devices in the future (e.g. a Linux
**   mouse library.)  Right now, all the options are mutually exclusive, but
**   that need not always be the case . . .
*/


#include "input.h"
#ifdef LINUXVGA
#include "linux-console.h"
#endif
#ifdef X11GRAPHICS
#include "x11input.h"
#endif


void init_input_devices(void)
{
#ifdef LINUXVGA
     linux_console_init();
#endif
#ifdef X11GRAPHICS
     x11_input_init();
#endif
}


Intent *read_input_devices(void)
{
#ifdef LINUXVGA
     return linux_console_read();
#endif
#ifdef X11GRAPHICS
     return x11_read();
#endif
}
