// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

#ifndef __BPbitmap__
#define __BPbitmap__

#include <stdlib.h>	// for NULL
#include <iostream.h>
#include <math.h>
#include <string.h>	// for memcpy
#include <vgagl.h>	// for gl_* functions

#include "FastMath.h"	// sin/cos tables, Fixed Point math stuff

class Bitmap;
typedef Bitmap *BitmapPtr;

// Note: 'V' prefix indicates class variable
class Bitmap {
    public:
	Bitmap() : Vwidth(0), Vheight(0), Vsize(0),
		   Vmap(NULL), Vcmap(NULL), Valloc(0) {};
    
        Bitmap(int w, int h) : Vwidth(w), Vheight(h), Vsize(w*h),
        		       Vmap(NULL), Vcmap(NULL), Valloc(0) {};

        // copy constructor
	Bitmap( const Bitmap& b )
		{ 
		copy( b ); 
		}
        		       
	~Bitmap() 
		{ 
		if (Valloc) delete [] Vmap; 
		if (Vcmap) delete [] Vcmap;
		}

	// make 'this' bitmap be a clone of bitmap 'b'
	void copy( const Bitmap& b );

	// copy with scaling. Take bitmap b, scale it to width/height (w/h)
	// are copy result to 'this' object	
	void copy( const Bitmap& b, int w, int h );

	// display bitmap on screen using svgalib calls
    	void put(int x, int y) const
		{ 
		if (Vcmap)
			gl_putboxmaskcompiled( x, y, Vwidth, Vheight, Vcmap ); 
		else if (Vmap)
			gl_putboxmask( x, y, Vwidth, Vheight, Vmap ); 
		}

	// rotate bitmap 90 clockwise
	void rotc90();
	// rotate bitmap 90 counter-clockwise
	void rotcc90();

	// rotate so many degrees.
	// degrees=0..TRIGSIZE (defined in FastMath.h)
	void rot(Angle degrees);
		
	// p is a pointer to a width*height sized buffer of colormap
	// values (0-255) that defines the bitmap.  Just happens to be
	// the type of bitmap supported by the svgalib gl_putbox functions.
	// Gee, what a coincidence ;-)
	void setMap( unsigned char *p )
		{
		if (Valloc) delete [] Vmap;
		Valloc = 0; 
		Vmap = p; 
		}

	void compile();	// compile bitmap - put() will then use the usually
			// faster compiled bitmap to draw on the screen.
			// note - if you change the bitmap using any of
			// the set or rotate functions, you must recompile.

	const unsigned char* map() const { return Vmap; }
	
	int  width() const 	{ return Vwidth; }
    	int  height() const	{ return Vheight; }
	int  size() const	{ return Vsize; }

    private:

        unsigned char   *Vmap;	// pointer to bitmap
	unsigned char	*Vcmap;	// pointer to compiled bitmap

    	char	Valloc;	// flag: 1=mem was allocated for map, 0 otherwise;
        int	Vwidth;
        int	Vheight;
        int	Vsize;

	// allocate memory for the bitmap
	void	allocMem( int w, int h );

	// calc offset into bitmap given x,y co-ord
	int offset(int x, int y) const;

    };

inline int Bitmap::offset(int x, int y) const return r;
	{
	r = y*Vwidth+x;
	}

#endif
